/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MagnetClipboardListener
extends WindowAdapter {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$search$MagnetClipboardListener == null ? (class$com$limegroup$gnutella$gui$search$MagnetClipboardListener = MagnetClipboardListener.class$("com.limegroup.gnutella.gui.search.MagnetClipboardListener")) : class$com$limegroup$gnutella$gui$search$MagnetClipboardListener);
    private static final MagnetClipboardListener instance = new MagnetClipboardListener();
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final ClipboardOwner owner = new ClipboardOwner(){

        public void lostOwnership(Clipboard c, Transferable t) {
        }
    };
    private final StringSelection empty = new StringSelection("");
    private final ProcessingQueue clipboardParser = new ProcessingQueue("clipboard parser");
    private Runnable parser = new Runnable(){

        public void run() {
            MagnetClipboardListener.this.parseAndLaunch();
        }
    };
    private static String currentMagnet;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$MagnetClipboardListener;

    private void parseAndLaunch() {
        Transferable data = null;
        try {
            data = this.CLIPBOARD.getContents(this);
        }
        catch (IllegalStateException isx) {
            return;
        }
        if (data == null) {
            return;
        }
        if (!data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        String contents = null;
        try {
            contents = (String)data.getTransferData(DataFlavor.stringFlavor);
        }
        catch (IOException iox) {
            LOG.info("problem occured while trying to parse clipboard, do nothing", iox);
            return;
        }
        catch (UnsupportedFlavorException ufx) {
            LOG.error("UnsupportedFlavor??", ufx);
            return;
        }
        if (contents == null) {
            return;
        }
        final MagnetOptions[] opts = ExternalControl.parseMagnet(contents);
        if (opts == null) {
            return;
        }
        LOG.info("clipboard contains " + contents);
        this.purgeClipboard();
        final String address = contents;
        final String name = opts[0].getDN() != null ? opts[0].getDN() + "   \n" : "the file   ";
        Runnable r = new Runnable(){

            public void run() {
                if (GUIMediator.showYesNoMessage("DOWNLOAD_MAGNET_DIALOG", name + GUIMediator.getStringResource("DOWNLOAD_FROM") + "   \n" + address) == 101) {
                    ExternalControl.downloadMagnet(opts);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private MagnetClipboardListener() {
    }

    public static MagnetClipboardListener getInstance() {
        return instance;
    }

    public void windowActivated(WindowEvent e) {
        this.clipboardParser.add(this.parser);
    }

    private void purgeClipboard() {
        try {
            this.CLIPBOARD.setContents(this.empty, this.owner);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

