/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchInputManager;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class SearchMediator {
    static final String DOWNLOAD_STRING = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");
    static final String KILL_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_KILL_STRING");
    static final String STOP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_STOP_STRING");
    static final String LAUNCH_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_LAUNCH_STRING");
    static final String BROWSE_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BROWSE_STRING");
    static final String CHAT_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_CHAT_STRING");
    static final String REPEAT_SEARCH_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_REPEAT_SEARCH_STRING");
    static final String BROWSE_HOST_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BROWSE_STRING");
    static final String BITZI_LOOKUP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BITZI_LOOKUP_STRING");
    static final String BLOCK_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BLOCK_STRING");
    private static final SearchInputManager INPUT_MANAGER = new SearchInputManager();
    private static final SearchResultDisplayer RESULT_DISPLAYER = new SearchResultDisplayer();

    public SearchMediator() {
        String splashScreenString = GUIMediator.getStringResource("SPLASH_STATUS_SEARCH_WINDOW");
        GUIMediator.setSplashScreenString(splashScreenString);
        GUIMediator.addRefreshListener(RESULT_DISPLAYER);
        RESULT_DISPLAYER.setSearchListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ResultPanel panel = RESULT_DISPLAYER.getSelectedResultPanel();
                if (panel == null) {
                    INPUT_MANAGER.clearFilters();
                } else {
                    INPUT_MANAGER.setFiltersFor(panel);
                }
            }
        });
    }

    public static void rebuildInputPanel() {
        INPUT_MANAGER.rebuild();
    }

    public static void addressChanged() {
        INPUT_MANAGER.addressChanged();
    }

    public static void showSearchInput() {
        INPUT_MANAGER.goToSearch();
    }

    public static void requestSearchFocus() {
        INPUT_MANAGER.requestSearchFocus();
    }

    public static void updateResults() {
        RESULT_DISPLAYER.updateResults();
    }

    static byte[] repeatSearch(ResultPanel rp, SearchInformation info) {
        if (!SearchMediator.validate(info)) {
            return null;
        }
        byte[] guidBytes = RouterService.newQueryGUID();
        GUID newGuid = new GUID(guidBytes);
        RouterService.stopQuery(new GUID(rp.getGUID()));
        rp.setGUID(newGuid);
        INPUT_MANAGER.panelReset(rp);
        if (info.isBrowseHostSearch()) {
            IpPort ipport = info.getIpPort();
            String host = ipport.getAddress();
            int port = ipport.getPort();
            if (host != null && port != 0) {
                GUIMediator.instance().setSearching(true);
                SearchMediator.reBrowseHost(host, port, rp);
            }
        } else {
            GUIMediator.instance().setSearching(true);
            SearchMediator.doSearch(guidBytes, info);
        }
        return guidBytes;
    }

    static void doBrowseHost(ResultPanel rp) {
        TableLine line = rp.getSelectedLine();
        if (line == null) {
            return;
        }
        RemoteFileDesc rfd = line.getBrowseHostEnabledRFD();
        if (rfd == null) {
            return;
        }
        byte[] serventIDBytes = rfd.getClientGUID();
        Set proxies = rfd.isReplyToMulticast() ? Collections.EMPTY_SET : rfd.getPushProxies();
        GUID serventID = new GUID(serventIDBytes);
        String host = rfd.getHost();
        int port = rfd.getPort();
        SearchMediator.doBrowseHost2(host, port, serventID, proxies, rfd.supportsFWTransfer());
    }

    public static void doBrowseHost(RemoteFileDesc rfd) {
        SearchMediator.doBrowseHost2(rfd.getHost(), rfd.getPort(), new GUID(rfd.getClientGUID()), rfd.getPushProxies(), rfd.supportsFWTransfer());
    }

    public static void doBrowseHost(String host, int port, GUID guid) {
        if (guid == null) {
            SearchMediator.doBrowseHost2(host, port, null, null, false);
        } else {
            SearchMediator.doBrowseHost2(host, port, new GUID(guid.bytes()), null, false);
        }
    }

    private static void reBrowseHost(String host, int port, ResultPanel in) {
        GUID guid = new GUID(GUID.makeGuid());
        in.setGUID(guid);
        BrowseHostHandler bhh = RouterService.doAsynchronousBrowseHost(host, port, guid, new GUID(GUID.makeGuid()), null, false);
        in.setBrowseHostHandler(bhh);
        INPUT_MANAGER.panelReset(in);
    }

    private static void doBrowseHost2(String host, int port, GUID serventID, Set proxies, boolean canDoFWTransfer) {
        GUID guid = new GUID(GUID.makeGuid());
        ResultPanel rp = SearchMediator.addBrowseHostTab(guid, host + ":" + port);
        BrowseHostHandler bhh = RouterService.doAsynchronousBrowseHost(host, port, guid, serventID, proxies, canDoFWTransfer);
        rp.setBrowseHostHandler(bhh);
    }

    public static void browseHostFailed(GUID guid) {
        RESULT_DISPLAYER.browseHostFailed(guid);
    }

    public static byte[] triggerSearch(SearchInformation info) {
        if (!SearchMediator.validate(info)) {
            return null;
        }
        byte[] guid = RouterService.newQueryGUID();
        if (!info.isBrowseHostSearch()) {
            SearchMediator.addResultTab(new GUID(guid), info);
        }
        if (info.isKeywordSearch()) {
            GUIMediator.instance().checkForJavaVersion();
        }
        SearchMediator.doSearch(guid, info);
        return guid;
    }

    public static byte[] triggerSearch(String query) {
        return SearchMediator.triggerSearch(SearchInformation.createKeywordSearch(query, null, MediaType.getAnyTypeMediaType()));
    }

    private static boolean validate(SearchInformation info) {
        String query = info.getQuery();
        String xml = info.getXML();
        MediaType media = info.getMediaType();
        if (query.equals("")) {
            return false;
        }
        if (!(query.length() > 2 || query.length() == 2 && (Character.isDigit(query.charAt(0)) && Character.isLetter(query.charAt(1)) || Character.isLetter(query.charAt(0)) && Character.isDigit(query.charAt(1))))) {
            GUIMediator.showError("ERROR_THREE_CHARACTER_SEARCH");
            return false;
        }
        if (query.length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
            if (xml == null || xml.equals("")) {
                GUIMediator.showError("ERROR_SEARCH_TOO_LARGE");
            } else {
                GUIMediator.showError("ERROR_XML_SEARCH_TOO_LARGE");
            }
            return false;
        }
        if (xml != null && xml.length() > SearchSettings.MAX_XML_QUERY_LENGTH.getValue()) {
            GUIMediator.showError("ERROR_XML_SEARCH_TOO_LARGE");
            return false;
        }
        if (!info.isBrowseHostSearch() && !RouterService.isConnected()) {
            if (!RouterService.isConnecting()) {
                GUIMediator.showMessage("SEARCH_NOT_CONNECTED", QuestionsHandler.NO_NOT_CONNECTED);
            } else {
                GUIMediator.showMessage("SEARCH_STILL_CONNECTING", QuestionsHandler.NO_STILL_CONNECTING);
            }
        }
        return true;
    }

    private static void doSearch(byte[] guid, SearchInformation info) {
        String query = info.getQuery();
        String xml = info.getXML();
        MediaType media = info.getMediaType();
        if (info.isXMLSearch()) {
            RouterService.query(guid, query, xml, media);
        } else if (info.isKeywordSearch()) {
            RouterService.query(guid, query, media);
        } else if (info.isWhatsNewSearch()) {
            RouterService.queryWhatIsNew(guid, media);
        } else if (info.isBrowseHostSearch()) {
            IpPort ipport = info.getIpPort();
            SearchMediator.doBrowseHost(ipport.getAddress(), ipport.getPort(), null);
        }
    }

    private static ResultPanel addResultTab(GUID guid, SearchInformation info) {
        return RESULT_DISPLAYER.addResultTab(guid, info);
    }

    private static ResultPanel addBrowseHostTab(GUID guid, String desc) {
        return RESULT_DISPLAYER.addResultTab(guid, SearchInformation.createBrowseHostSearch(desc));
    }

    public static void handleQueryResult(RemoteFileDesc rfd, HostData data, Set alts) {
        byte[] replyGUID = data.getMessageGUID();
        ResultPanel rp = SearchMediator.getResultPanelForGUID(new GUID(replyGUID));
        if (rp != null) {
            SearchResult sr = new SearchResult(rfd, data, alts);
            RESULT_DISPLAYER.addQueryResult(replyGUID, sr, rp);
        }
    }

    static void doDownload(final ResultPanel rp) {
        final TableLine[] lines = rp.getAllSelectedLines();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.downloadAll(lines, new GUID(rp.getGUID()));
                rp.refresh();
            }
        });
    }

    private static void downloadAll(TableLine[] lines, GUID guid) {
        for (int i = 0; i < lines.length; ++i) {
            SearchMediator.downloadLine(lines[i], guid);
        }
    }

    private static void downloadLine(TableLine line, GUID guid) {
        Serializable next;
        if (line == null) {
            return;
        }
        HashSet alts = new HashSet();
        LinkedList<RemoteFileDesc> otherRFDs = new LinkedList<RemoteFileDesc>();
        RemoteFileDesc[] rfds = line.getAllRemoteFileDescs();
        alts.addAll(line.getAlts());
        RemoteFileDesc sha1RFD = null;
        for (int i = 0; i < rfds.length; ++i) {
            next = rfds[i];
            ((RemoteFileDesc)next).setDownloading(true);
            ((RemoteFileDesc)next).setRetryAfter(0);
            if (((RemoteFileDesc)next).getSHA1Urn() != null) {
                sha1RFD = next;
            }
            alts.remove(new Endpoint(((RemoteFileDesc)next).getHost(), ((RemoteFileDesc)next).getPort()));
        }
        if (sha1RFD == null) {
            sha1RFD = rfds[0];
        }
        Iterator i = alts.iterator();
        while (i.hasNext()) {
            next = (Endpoint)i.next();
            otherRFDs.add(new RemoteFileDesc(sha1RFD, (IpPort)((Object)next)));
        }
        SearchMediator.downloadWithOverwritePrompt(rfds, otherRFDs, guid);
    }

    private static void downloadWithOverwritePrompt(RemoteFileDesc[] rfds, List alts, GUID queryGUID) {
        LimeXMLDocument doc;
        String action;
        int actLine;
        if (rfds.length < 1) {
            return;
        }
        if (SearchMediator.containsExe(rfds) && !SearchMediator.userWantsExeDownload()) {
            return;
        }
        boolean pureFound = false;
        for (actLine = 0; actLine < rfds.length; ++actLine) {
            if (rfds[actLine].getIndex() != 0xFFFFFFFFL) continue;
            pureFound = true;
            break;
        }
        if (pureFound && (action = (doc = rfds[actLine].getXMLDoc()).getAction()) != null && !action.equals("")) {
            GUIMediator.openURL(action);
            return;
        }
        try {
            try {
                RouterService.download(rfds, alts, false, queryGUID);
            }
            catch (FileExistsException e) {
                String fname = e.getFileName();
                String msgKey = "MESSAGE_OVERWRITE_EXISTING_FILE";
                String msg = "(" + fname + ")?";
                int response = GUIMediator.showYesNoMessage(msgKey, msg);
                if (response != 101) {
                    return;
                }
                try {
                    RouterService.download(rfds, alts, true, queryGUID);
                }
                catch (FileExistsException e2) {
                    Assert.that(false, "download(rfd, true) threw unexpected exception");
                }
            }
        }
        catch (AlreadyDownloadingException e) {
            GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", (Object)("\"" + e.getFilename() + "\"."), QuestionsHandler.ALREADY_DOWNLOADING);
        }
        catch (FileNotFoundException fnfe) {
            GUIMediator.showError("ERROR_ACCESSING_SAVE_DIRECTORY");
        }
    }

    private static boolean containsExe(RemoteFileDesc[] rfd) {
        for (int i = 0; i < rfd.length; ++i) {
            if (!rfd[i].getFileName().toLowerCase(Locale.US).endsWith("exe")) continue;
            return true;
        }
        return false;
    }

    private static boolean userWantsExeDownload() {
        String middleMsg = GUIMediator.getStringResource("SEARCH_VIRUS_MSG_TWO");
        int response = GUIMediator.showYesNoMessage("SEARCH_VIRUS_MSG_ONE", middleMsg, "SEARCH_VIRUS_MSG_THREE", QuestionsHandler.PROMPT_FOR_EXE);
        return response == 101;
    }

    static void setTabDisplayCount(ResultPanel rp) {
        RESULT_DISPLAYER.setTabDisplayCount(rp);
    }

    static void killSearch() {
        RESULT_DISPLAYER.killSearch();
    }

    static void panelSelected(ResultPanel panel) {
        INPUT_MANAGER.setFiltersFor(panel);
    }

    static void searchKilled(ResultPanel panel) {
        INPUT_MANAGER.panelRemoved(panel);
        ResultPanel rp = RESULT_DISPLAYER.getSelectedResultPanel();
        if (rp != null) {
            INPUT_MANAGER.setFiltersFor(rp);
        }
    }

    static void checkToStopLime() {
        RESULT_DISPLAYER.checkToStopLime();
    }

    static ResultPanel getResultPanelForGUID(GUID rguid) {
        return RESULT_DISPLAYER.getResultPanelForGUID(rguid);
    }

    public static boolean queryIsAlive(GUID guid) {
        return SearchMediator.getResultPanelForGUID(guid) != null;
    }

    public static JComponent getSearchComponent() {
        return INPUT_MANAGER.getComponent();
    }

    public static JComponent getResultComponent() {
        return RESULT_DISPLAYER.getComponent();
    }
}

