/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.statistics.panes.AverageStatHandler;
import com.limegroup.gnutella.gui.statistics.panes.StatisticDisplayer;
import com.limegroup.gnutella.statistics.Statistic;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;

final class AveragesPainter
extends JComponent
implements ComponentListener,
StatisticDisplayer {
    private final List LIST = new LinkedList();
    private static final String NAME = GUIMediator.getStringResource("STATS_LEGEND_NAME");
    private static final String AVERAGE = GUIMediator.getStringResource("STATS_LEGEND_AVERAGE");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final int NAME_COLUMN_WIDTH = 160;
    private static final int AVERAGE_COLUMN_WIDTH = 54;
    private static final int RECT_WIDTH = 214;

    AveragesPainter() {
        this.addComponentListener(this);
    }

    public void registerStatistic(Statistic stat, String displayName) {
    }

    public void registerDualStatistic(Statistic totalBytes, Statistic totalMessages, String displayName) {
        AverageStatHandler averageHandler = new AverageStatHandler(totalBytes, totalMessages, displayName);
        this.LIST.add(averageHandler);
    }

    public void refresh() {
        this.repaint();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setWriteStatsToFile(boolean write) {
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font oldFont = g.getFont();
        Font tempFont = new Font(oldFont.getName(), oldFont.getStyle(), oldFont.getSize() - 1);
        g.setFont(tempFont);
        FontMetrics m = g.getFontMetrics();
        int rowHeight = m.getHeight() + 1;
        int rowBase = m.getLeading() / 2 + m.getMaxAscent();
        boolean yOrig = false;
        int xName = this.getWidth() / 2 - 107;
        int xAverage = xName + 160;
        int xMax = xAverage + 54;
        int margin = 3;
        int y = 0;
        g.drawString(NAME, xName + 3, y + rowBase);
        g.drawString(AVERAGE, xAverage + 3, y + rowBase);
        g.drawLine(xName, y += rowHeight, xName + 214, y);
        ++y;
        Iterator iter = this.LIST.iterator();
        while (iter.hasNext()) {
            AverageStatHandler handler = (AverageStatHandler)iter.next();
            double totalBytes = handler.getByteStat().getTotal();
            double totalNumber = handler.getNumberStat().getTotal();
            double averageDouble = 0.0;
            if (totalNumber != 0.0) {
                averageDouble = totalBytes / totalNumber;
            }
            NUMBER_FORMAT.setMaximumFractionDigits(3);
            String average = NUMBER_FORMAT.format(averageDouble);
            String name = handler.getDisplayName();
            g.drawString(name, xName + 3, y + rowBase);
            g.drawString(average, xAverage + 3, y + rowBase);
            y += rowHeight;
        }
        g.drawRect(xName, 0, 214, y - 0);
        g.drawLine(xAverage, 0, xAverage, y);
        g.drawLine(xMax, 0, xMax, y);
        g.setFont(oldFont);
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

