/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.statistics.panes.StatHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

final class GraphLegend {
    private final JPanel PANEL = new BoxPanel();
    private final List LIST = new LinkedList();
    private int _curHeight = 20;

    GraphLegend() {
        Dimension size = new Dimension(150, this._curHeight);
        this.PANEL.setPreferredSize(size);
        this.PANEL.setMaximumSize(size);
        this.PANEL.setBorder(new LineBorder(Color.black));
        this.PANEL.add(new LegendPainter());
    }

    public void add(StatHandler handler) {
        this._curHeight += 20;
        Dimension size = new Dimension(150, this._curHeight);
        this.PANEL.setPreferredSize(size);
        this.PANEL.setMaximumSize(size);
        this.PANEL.revalidate();
        this.LIST.add(handler);
    }

    JComponent getComponent() {
        return this.PANEL;
    }

    private class LegendPainter
    extends JComponent {
        private LegendPainter() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int dim = 15;
            Iterator iter = GraphLegend.this.LIST.iterator();
            int i = 0;
            int x = 6;
            int y = 12;
            while (iter.hasNext()) {
                StatHandler handler = (StatHandler)iter.next();
                String name = handler.getDisplayName();
                Color oldColor = g.getColor();
                g.drawRect(120, y - 1, 21, dim + 1);
                g.setColor(handler.getColor());
                g.fillRect(121, y, 20, dim);
                g.setColor(oldColor);
                g.drawString(name, x, y + dim - 1);
                ++i;
                y += 20;
            }
        }
    }
}

