/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.MouseObserver;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public final class DefaultMouseListener
implements MouseListener {
    private MouseObserver cm;

    public DefaultMouseListener(MouseObserver cm) {
        this.cm = cm;
    }

    public void mouseClicked(MouseEvent event) {
        if (this.tryPopup(event)) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(event)) {
            this.cm.handleRightMouseClick(event);
        } else if (event.getClickCount() >= 2) {
            this.cm.handleMouseDoubleClick(event);
        }
    }

    public void mousePressed(MouseEvent event) {
        this.tryPopup(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.tryPopup(event);
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public boolean tryPopup(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.cm.handlePopupMenu(ev);
            return true;
        }
        return false;
    }
}

