/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.tables.DragListener;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.MouseEventConsumptionChecker;
import com.limegroup.gnutella.gui.tables.TableDragRecognitionWrapper;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;

public final class DragManager {
    private static final CellRendererPane PANE = new CellRendererPane();
    private static final int IMAGE_WIDTH = 300;
    private static final int IMAGE_ROW_HEIGHT = 16;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;

    private DragManager() {
    }

    public static void install(JTree tree) {
        try {
            DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(tree, 0x40000001, DragListener.instance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void install(LimeJTable table) {
        int i;
        MouseDragGestureRecognizer recognizer;
        int i2;
        ToolTipManager.sharedInstance().unregisterComponent(table);
        MouseListener[] oldMouseListeners = (MouseListener[])table.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = DragManager.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
        MouseMotionListener[] oldMouseMotionListeners = (MouseMotionListener[])table.getListeners(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = DragManager.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener);
        for (i2 = 0; i2 < oldMouseListeners.length; ++i2) {
            table.removeMouseListener(oldMouseListeners[i2]);
        }
        for (i2 = 0; i2 < oldMouseMotionListeners.length; ++i2) {
            table.removeMouseMotionListener(oldMouseMotionListeners[i2]);
        }
        try {
            recognizer = (MouseDragGestureRecognizer)DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(table, 0x40000001, DragListener.instance());
        }
        catch (Throwable failed) {
            int i3;
            for (i3 = 0; i3 < oldMouseListeners.length; ++i3) {
                table.addMouseListener(oldMouseListeners[i3]);
            }
            for (i3 = 0; i3 < oldMouseMotionListeners.length; ++i3) {
                table.addMouseMotionListener(oldMouseMotionListeners[i3]);
            }
            ToolTipManager.sharedInstance().registerComponent(table);
            return;
        }
        table.removeMouseListener(recognizer);
        table.removeMouseMotionListener(recognizer);
        TableDragRecognitionWrapper inputListener = new TableDragRecognitionWrapper(table, recognizer);
        table.addMouseListener(inputListener);
        table.addMouseMotionListener(inputListener);
        if (CommonUtils.isJava14OrLater()) {
            DragSource.getDefaultDragSource().addDragSourceListener(inputListener);
        } else {
            table.putClientProperty("limewire.dragRecognizer", inputListener);
        }
        for (i = 0; i < oldMouseListeners.length; ++i) {
            table.addMouseListener(MouseEventConsumptionChecker.proxy(oldMouseListeners[i]));
        }
        for (i = 0; i < oldMouseMotionListeners.length; ++i) {
            table.addMouseMotionListener(MouseEventConsumptionChecker.proxy(oldMouseMotionListeners[i]));
        }
        table.setMouseEventsProxied(true);
        ToolTipManager.sharedInstance().registerComponent(table);
    }

    public static Image createDragImage(Transferable t) {
        if (!t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return null;
        }
        List l = null;
        try {
            l = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException ufe) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        if (l.size() == 0) {
            return null;
        }
        int height = 16 * l.size();
        BufferedImage buffer = new BufferedImage(300, height, 2);
        Graphics g = buffer.getGraphics();
        JLabel label = new JLabel();
        label.setVerticalAlignment(1);
        label.setOpaque(false);
        int y = 0;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            Icon icon = IconManager.instance().getIconForFile(f);
            label.setIcon(icon);
            label.setText(f.getName());
            PANE.paintComponent(g, label, null, 0, y, 300, height - y);
            y += 16;
        }
        g.dispose();
        return buffer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

