/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.licenses.CCConstants;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import com.limegroup.gnutella.licenses.VerificationListener;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class CCLicense
implements License,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$licenses$CCLicense == null ? (class$com$limegroup$gnutella$licenses$CCLicense = CCLicense.class$("com.limegroup.gnutella.licenses.CCLicense")) : class$com$limegroup$gnutella$licenses$CCLicense);
    private static final ProcessingQueue VQUEUE = new ProcessingQueue("CCLicense");
    private static final long serialVersionUID = 8213994964631107858L;
    private transient int verified = 0;
    private transient URI licenseLocation;
    private transient String license;
    private long lastVerifiedTime;
    private Map allWorks;
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$CCLicense;

    CCLicense(String license, URI uri) {
        this.license = license;
        this.licenseLocation = uri;
    }

    public boolean isVerifying() {
        return this.verified == 1;
    }

    public boolean isVerified() {
        return this.verified == 2;
    }

    public String getLicense() {
        return this.license;
    }

    public URL getLicenseDeed(URN urn) {
        Details details = this.getDetails(urn);
        if (details == null || details.licenseURL == null) {
            return this.guessLicenseDeed();
        }
        return details.licenseURL;
    }

    public long getLastVerifiedTime() {
        return this.lastVerifiedTime;
    }

    public URI getLicenseURI() {
        return this.licenseLocation;
    }

    private URL guessLicenseDeed() {
        return CCConstants.guessLicenseDeed(this.license);
    }

    public boolean isValid(URN urn) {
        return this.getDetails(urn) != null;
    }

    public License copy(String license, URI licenseURI) {
        CCLicense newL = null;
        try {
            newL = (CCLicense)this.clone();
            newL.license = license;
            newL.licenseLocation = licenseURI;
        }
        catch (CloneNotSupportedException error) {
            ErrorService.error(error);
        }
        return newL;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.verified = 2;
    }

    public String getLicenseDescription(URN urn) {
        Iterator i;
        List permitted = Collections.EMPTY_LIST;
        List prohibited = Collections.EMPTY_LIST;
        List required = Collections.EMPTY_LIST;
        Details details = this.getDetails(urn);
        if (details != null) {
            permitted = details.permitted;
            prohibited = details.prohibited;
            required = details.required;
        }
        StringBuffer sb = new StringBuffer();
        if (permitted != null && !permitted.isEmpty()) {
            sb.append("Permitted: ");
            i = permitted.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (prohibited != null && !prohibited.isEmpty()) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("Prohibited: ");
            i = prohibited.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (required != null && !required.isEmpty()) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append("Required: ");
            i = required.iterator();
            while (i.hasNext()) {
                sb.append(i.next().toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        if (sb.length() == 0) {
            sb.append("Permissions unknown.");
        }
        return sb.toString();
    }

    private void clear() {
        if (this.allWorks != null) {
            this.allWorks.clear();
        }
    }

    public void verify(VerificationListener listener) {
        this.verified = 1;
        this.clear();
        VQUEUE.add(new Verifier(listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBody(String url) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Contacting: " + url);
        }
        HttpClient client = HttpClientManager.getNewClient();
        GetMethod get = new GetMethod(url);
        get.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
        try {
            HttpClientManager.executeMethodRedirecting(client, get);
            String string = get.getResponseBodyAsString();
            return string;
        }
        catch (IOException ioe) {
            LOG.warn("Can't contact license server: " + url, ioe);
            String string = null;
            return string;
        }
        finally {
            get.releaseConnection();
        }
    }

    private void addWork(URN urn, String licenseURL) {
        URL url = null;
        try {
            url = new URL(licenseURL);
        }
        catch (MalformedURLException murl) {
            LOG.warn("Unable to make licenseURL out of: " + licenseURL, murl);
        }
        Details details = this.getDetails(urn);
        if (details != null) {
            URL guessed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found existing details item for URN: " + urn);
            }
            if (url != null && (guessed = this.guessLicenseDeed()) != null && guessed.equals(url)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating license URL to be: " + url);
                }
                details.licenseURL = url;
            }
            return;
        }
        details = new Details(url);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding new " + details + " for urn: " + urn);
        }
        if (this.allWorks == null) {
            this.allWorks = new HashMap(1);
        }
        this.allWorks.put(urn, details);
    }

    private Details getDetails(URN urn) {
        if (this.allWorks == null) {
            return null;
        }
        Details details = (Details)this.allWorks.get(urn);
        if (details != null) {
            return details;
        }
        if (urn != null) {
            return (Details)this.allWorks.get(null);
        }
        return (Details)this.allWorks.values().iterator().next();
    }

    private List getDetailsForLicenseURL(URL url) {
        if (this.allWorks == null || url == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<Details> details = new LinkedList<Details>();
        Iterator i = this.allWorks.values().iterator();
        while (i.hasNext()) {
            Details detail = (Details)i.next();
            if (detail.licenseURL == null || !url.equals(detail.licenseURL)) continue;
            details.add(detail);
        }
        return details;
    }

    private String locateRDF(String body) {
        if (body == null || body.trim().equals("")) {
            return null;
        }
        int startRDF = body.indexOf("<rdf:RDF");
        if (startRDF >= body.length() - 1) {
            return null;
        }
        int endRDF = body.indexOf("rdf:RDF", startRDF + 6);
        if (startRDF == -1 || endRDF == -1) {
            return null;
        }
        if ((endRDF = body.indexOf(62, endRDF)) == -1) {
            return null;
        }
        return body.substring(startRDF, endRDF + 1);
    }

    protected void doVerification(String body, boolean parseWork) {
        Node child;
        int i;
        String rdf;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to verify: " + body);
        }
        if ((rdf = this.locateRDF(body)) == null) {
            return;
        }
        DOMParser parser = new DOMParser();
        InputSource is = new InputSource(new StringReader(rdf));
        try {
            parser.parse(is);
        }
        catch (IOException ioe) {
            LOG.debug("IOX parsing RDF\n" + rdf, ioe);
            return;
        }
        catch (SAXException saxe) {
            LOG.debug("SAX parsing RDF\n" + rdf, saxe);
            return;
        }
        Element doc = parser.getDocument().getDocumentElement();
        NodeList children = doc.getChildNodes();
        if (parseWork) {
            for (i = 0; i < children.getLength(); ++i) {
                child = children.item(i);
                if (!child.getNodeName().equals("Work")) continue;
                this.parseWorkItem(child);
            }
        }
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (!child.getNodeName().equals("License")) continue;
            this.parseLicenseItem(child);
        }
    }

    protected void parseWorkItem(Node work) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing work item.");
        }
        NamedNodeMap attributes = work.getAttributes();
        Node about = attributes.getNamedItem("rdf:about");
        URN expectedURN = null;
        if (about != null) {
            try {
                expectedURN = URN.createSHA1Urn(about.getNodeValue());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        NodeList children = work.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node resource;
            Node child = children.item(i);
            if (!child.getNodeName().equals("license") || (resource = (attributes = child.getAttributes()).getNamedItem("rdf:resource")) == null) continue;
            this.addWork(expectedURN, resource.getNodeValue());
        }
    }

    protected void parseLicenseItem(Node license) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing license item.");
        }
        NamedNodeMap attributes = license.getAttributes();
        Node about = attributes.getNamedItem("rdf:about");
        List details = Collections.EMPTY_LIST;
        if (about != null) {
            String value = about.getNodeValue();
            try {
                details = this.getDetailsForLicenseURL(new URL(value));
            }
            catch (MalformedURLException murl) {
                LOG.warn("Unable to create license URL for: " + value, murl);
            }
        }
        if (!details.iterator().hasNext()) {
            return;
        }
        LinkedList required = null;
        LinkedList prohibited = null;
        LinkedList permitted = null;
        NodeList children = license.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equalsIgnoreCase("requires")) {
                if (required == null) {
                    required = new LinkedList();
                }
                this.addPermission(required, child);
                continue;
            }
            if (name.equalsIgnoreCase("permits")) {
                if (permitted == null) {
                    permitted = new LinkedList();
                }
                this.addPermission(permitted, child);
                continue;
            }
            if (!name.equalsIgnoreCase("prohibits")) continue;
            if (prohibited == null) {
                prohibited = new LinkedList();
            }
            this.addPermission(prohibited, child);
        }
        Iterator i = details.iterator();
        while (i.hasNext()) {
            Details detail = (Details)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting license details for " + details);
            }
            detail.required = required;
            detail.prohibited = prohibited;
            detail.permitted = permitted;
        }
    }

    private void addPermission(List permissions, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node resource = attributes.getNamedItem("rdf:resource");
        if (resource != null) {
            String value = resource.getNodeValue();
            int slash = value.lastIndexOf(47);
            if (slash != -1 && slash != value.length() - 1) {
                String permission = value.substring(slash + 1);
                if (!permissions.contains(permission)) {
                    permissions.add(permission);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Added permission: " + permission);
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("Duplicate permission: " + permission + "!");
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.trace("Unable to find permission name: " + value);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("No resource item for permission.");
        }
    }

    private void updateLicenseDetails() {
        if (this.allWorks == null) {
            return;
        }
        Iterator i = this.allWorks.values().iterator();
        while (i.hasNext()) {
            Details details = (Details)i.next();
            if (details.isDescriptionAvailable() || details.licenseURL == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updating licenseURL for :" + details);
            }
            String url = details.licenseURL.toExternalForm();
            Object data = LicenseCache.instance().getData(url);
            String body = null;
            if (data != null && data instanceof String) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using cached data for url: " + url);
                }
                body = (String)data;
            } else {
                body = this.locateRDF(this.getBody(url));
                if (body != null) {
                    LicenseCache.instance().addData(url, body);
                } else {
                    LOG.debug("Couldn't retrieve license details from url: " + url);
                }
            }
            if (body == null) continue;
            this.doVerification(body, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Verifier
    implements Runnable {
        private final VerificationListener vc;

        Verifier(VerificationListener listener) {
            this.vc = listener;
        }

        public void run() {
            CCLicense.this.doVerification(CCLicense.this.getBody(CCLicense.this.licenseLocation.toString()), true);
            CCLicense.this.lastVerifiedTime = System.currentTimeMillis();
            CCLicense.this.updateLicenseDetails();
            CCLicense.this.verified = 2;
            LicenseCache.instance().addVerifiedLicense(CCLicense.this);
            if (this.vc != null) {
                this.vc.licenseVerified(CCLicense.this);
            }
        }
    }

    private static class Details
    implements Serializable {
        private static final long serialVersionUID = -1719502030054241350L;
        URL licenseURL;
        List required;
        List permitted;
        List prohibited;

        Details() {
        }

        Details(URL url) {
            this.licenseURL = url;
        }

        boolean isDescriptionAvailable() {
            return this.required != null || this.permitted != null || this.prohibited != null;
        }

        public String toString() {
            return "details:: license: " + this.licenseURL;
        }
    }
}

