/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.licenses;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.BadLicense;
import com.limegroup.gnutella.licenses.CCLicense;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseCache;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LicenseFactory {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$licenses$LicenseFactory == null ? (class$com$limegroup$gnutella$licenses$LicenseFactory = LicenseFactory.class$("com.limegroup.gnutella.licenses.LicenseFactory")) : class$com$limegroup$gnutella$licenses$LicenseFactory);
    static /* synthetic */ Class class$com$limegroup$gnutella$licenses$LicenseFactory;

    private LicenseFactory() {
    }

    public static boolean isVerifiedAndValid(URN urn, String licenseString) {
        URI uri = LicenseFactory.getLicenseURI(licenseString);
        return uri != null && LicenseCache.instance().isVerifiedAndValid(urn, uri);
    }

    public static License create(String licenseString) {
        License license;
        URI licenseURI;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Attempting to create license from: " + licenseString);
        }
        if ((licenseURI = LicenseFactory.getLicenseURI(licenseString)) == null) {
            LOG.warn("Unable to locate licenseURI, bailing");
            if (licenseString != null) {
                return new BadLicense(licenseString);
            }
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating license from URI: " + licenseURI);
        }
        if ((license = LicenseCache.instance().getLicense(licenseString, licenseURI)) == null) {
            LOG.debug("No cached license, creating new.");
            license = new CCLicense(licenseString, licenseURI);
        }
        return license;
    }

    public static void persistCache() {
        LicenseCache.instance().persistCache();
    }

    static URI getLicenseURI(String license) {
        if (license == null) {
            return null;
        }
        int verifyAt = license.indexOf("verify at");
        if (verifyAt == -1) {
            return null;
        }
        int urlStart = verifyAt + "verify at".length();
        if (urlStart >= license.length()) {
            return null;
        }
        String url = license.substring(urlStart).trim();
        URI uri = null;
        try {
            uri = new URI(url.toCharArray());
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                throw new URIException("Invalid scheme: " + scheme);
            }
            String authority = uri.getAuthority();
            if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                throw new URIException("Invalid authority: " + authority);
            }
        }
        catch (URIException e) {
            uri = null;
            LOG.error("Unable to create URI", e);
        }
        return uri;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

