/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.settings.Setting;
import java.util.Properties;

public abstract class AbstractNumberSetting
extends Setting {
    protected final Object MAX_VALUE;
    protected final Object MIN_VALUE;

    protected AbstractNumberSetting(Properties defaultProps, Properties props, String key, String defaultValue, String simppKey, Comparable max, Comparable min) {
        super(defaultProps, props, key, defaultValue, simppKey);
        if (max != null && min != null && max.compareTo(min) < 0) {
            throw new IllegalArgumentException("max less than min");
        }
        this.MAX_VALUE = max;
        this.MIN_VALUE = min;
    }

    protected void setValue(String value) {
        if (this.isSimppEnabled()) {
            Assert.that(this.MAX_VALUE != null, "simpp setting created with no max");
            Assert.that(this.MIN_VALUE != null, "simpp setting created with no min");
            if (!this.isInRange(value)) {
                return;
            }
        }
        super.setValue(value);
    }

    protected abstract boolean isInRange(String var1);
}

