/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.Setting;
import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;

public class FileArraySetting
extends Setting {
    private File[] value;

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        this(defaultProps, props, key, defaultValue, null);
    }

    FileArraySetting(Properties defaultProps, Properties props, String key, File[] defaultValue, String simppKey) {
        super(defaultProps, props, key, FileArraySetting.decode(defaultValue), simppKey);
        this.setPrivate(true);
    }

    public File[] getValue() {
        return this.value;
    }

    public void setValue(File[] value) {
        super.setValue(FileArraySetting.decode(value));
    }

    protected void loadValue(String sValue) {
        this.value = FileArraySetting.encode(sValue);
    }

    private static final File[] encode(String src) {
        if (src == null || src.length() == 0) {
            return new File[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        File[] dirs = new File[tokenizer.countTokens()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = new File(tokenizer.nextToken());
        }
        return dirs;
    }

    private static final String decode(File[] src) {
        if (src == null || src.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < src.length; ++i) {
            buffer.append(src[i].getAbsolutePath());
            if (i >= src.length - 1) continue;
            buffer.append(';');
        }
        return buffer.toString();
    }
}

