/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.ByteSetting;
import com.limegroup.gnutella.settings.CharArraySetting;
import com.limegroup.gnutella.settings.ColorSetting;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.FloatSetting;
import com.limegroup.gnutella.settings.FontNameSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LongSetting;
import com.limegroup.gnutella.settings.PasswordSetting;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.settings.StringArraySetting;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.util.FileUtils;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class SettingsFactory {
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private LongSetting LAST_EXPIRE_TIME = null;
    private File SETTINGS_FILE;
    private final String HEADING;
    protected final Properties DEFAULT_PROPS = new Properties();
    protected final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private ArrayList settings = new ArrayList(10);
    private Map simppKeyToSetting = new HashMap();
    private boolean expired = false;

    public SettingsFactory(File settingsFile) {
        this(settingsFile, "");
    }

    public SettingsFactory(File settingsFile, String heading) {
        this.SETTINGS_FILE = settingsFile;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = heading;
        this.reload();
    }

    public synchronized Iterator iterator() {
        return this.settings.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reload() {
        block17: {
            if (!this.SETTINGS_FILE.isFile()) {
                this.setExpireValue();
                return;
            }
            fis = null;
            try {
                try {
                    fis = new FileInputStream(this.SETTINGS_FILE);
                    try {
                        this.PROPS.load(fis);
                    }
                    catch (IllegalArgumentException ignored) {
                    }
                    catch (StringIndexOutOfBoundsException sioobe) {
                    }
                    catch (IOException iox) {
                        msg = iox.getMessage();
                        if (msg != null && (msg = msg.toLowerCase()).indexOf("corrupted") == -1) {
                            throw iox;
                        }
                        this.SETTINGS_FILE.delete();
                        MessageService.showError("ERROR_PROPS_CORRUPTED");
                    }
                    var5_8 = null;
                    if (fis == null) break block17;
                }
                catch (IOException e) {
                    ErrorService.error(e);
                    var5_8 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                    break block17;
                }
            }
            catch (Throwable var4_12) {
                var5_9 = null;
                if (fis == null) throw var4_12;
                ** try [egrp 3[TRYBLOCK] [7 : 119->126)] { 
lbl41:
                // 1 sources

                fis.close();
                throw var4_12;
lbl43:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var4_12;
            }
            try {}
            catch (IOException e) {}
            fis.close();
        }
        ii = this.settings.iterator();
        while (true) {
            if (!ii.hasNext()) {
                this.setExpireValue();
                return;
            }
            set = (Setting)ii.next();
            set.reload();
        }
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized void changeFile(File toUse) {
        this.SETTINGS_FILE = toUse;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.revertToDefault();
        this.reload();
    }

    public synchronized void revertToDefault() {
        Iterator ii = this.settings.iterator();
        while (ii.hasNext()) {
            Setting set = (Setting)ii.next();
            set.revertToDefault();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void save() {
        File parent;
        Properties toSave = (Properties)this.PROPS.clone();
        Iterator ii = this.settings.iterator();
        while (ii.hasNext()) {
            Setting set = (Setting)ii.next();
            if (set.shouldAlwaysSave() || !set.isDefault()) continue;
            toSave.remove(set.getKey());
        }
        OutputStream out = null;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        if ((parent = FileUtils.getParentFile(this.SETTINGS_FILE)) != null) {
            parent.mkdirs();
            FileUtils.setWriteable(parent);
        }
        FileUtils.setWriteable(this.SETTINGS_FILE);
        try {
            out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
        }
        catch (IOException ioe) {
            this.SETTINGS_FILE.delete();
            out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
        }
        toSave.store(out, this.HEADING);
        Object var7_7 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException e) {
                ErrorService.error(e);
                Object var7_8 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    Properties getProperties() {
        return this.PROPS;
    }

    public synchronized StringSetting createStringSetting(String key, String defaultValue) {
        StringSetting result = new StringSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized StringSetting createSettableStringSetting(String key, String defaultValue, String simppKey) {
        StringSetting result = new StringSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized BooleanSetting createBooleanSetting(String key, boolean defaultValue) {
        BooleanSetting result = new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized BooleanSetting createSettableBooleanSetting(String key, boolean defaultValue, String simppKey) {
        BooleanSetting result = new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized IntSetting createIntSetting(String key, int defaultValue) {
        IntSetting result = new IntSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized IntSetting createSettableIntSetting(String key, int defaultValue, String simppKey, int max, int min) {
        IntSetting result = new IntSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey, max, min);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized ByteSetting createByteSetting(String key, byte defaultValue) {
        ByteSetting result = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ByteSetting createSettableByteSetting(String key, byte defaultValue, String simppKey, byte max, byte min) {
        ByteSetting result = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey, max, min);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized LongSetting createLongSetting(String key, long defaultValue) {
        LongSetting result = new LongSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized LongSetting createSettableLongSetting(String key, long defaultValue, String simppKey, long max, long min) {
        LongSetting result = new LongSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey, max, min);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized FileSetting createFileSetting(String key, File defaultValue) {
        File parent;
        String parentString = defaultValue.getParent();
        if (parentString != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        FileSetting result = new FileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileSetting createSettableFileSetting(String key, File defaultValue, String simppKey) {
        File parent;
        String parentString = defaultValue.getParent();
        if (parentString != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        FileSetting result = new FileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized ColorSetting createColorSetting(String key, Color defaultValue) {
        ColorSetting result = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized ColorSetting createSettableColorSetting(String key, Color defaultValue, String simppKey) {
        ColorSetting result = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized CharArraySetting createCharArraySetting(String key, char[] defaultValue) {
        CharArraySetting result = CharArraySetting.createCharArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized CharArraySetting createSettableCharArraySetting(String key, char[] defaultValue, String simppKey) {
        CharArraySetting result = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized FloatSetting createFloatSetting(String key, float defaultValue) {
        FloatSetting result = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FloatSetting createSettableFloatSetting(String key, float defaultValue, String simppKey, float max, float min) {
        FloatSetting result = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey, max, min);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized StringArraySetting createStringArraySetting(String key, String[] defaultValue) {
        StringArraySetting result = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized StringArraySetting createSettableStringArraySetting(String key, String[] defaultValue, String simppKey) {
        StringArraySetting result = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized FileArraySetting createFileArraySetting(String key, File[] defaultValue) {
        FileArraySetting result = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FileArraySetting createSettableFileArraySetting(String key, File[] defaultValue, String simppKey) {
        FileArraySetting result = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized BooleanSetting createExpirableBooleanSetting(String key, boolean defaultValue) {
        BooleanSetting result = this.createBooleanSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    public synchronized IntSetting createExpirableIntSetting(String key, int defaultValue) {
        IntSetting result = this.createIntSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    public synchronized FontNameSetting createFontNameSetting(String key, String defaultValue) {
        FontNameSetting result = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    public synchronized FontNameSetting createSettableFontNameSetting(String key, String defaultValue, String simppKey) {
        FontNameSetting result = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue, simppKey);
        this.handleSettingInternal(result, simppKey);
        return result;
    }

    public synchronized PasswordSetting createPasswordSetting(String key, String defaultValue) {
        PasswordSetting result = new PasswordSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result, null);
        return result;
    }

    private synchronized void handleSettingInternal(Setting setting, String simppKey) {
        this.settings.add(setting);
        setting.reload();
        if (simppKey != null) {
            SimppSettingsManager simppSetMan = SimppSettingsManager.instance();
            String simppValue = simppSetMan.getRemanentSimppValue(simppKey);
            if (simppValue != null) {
                simppSetMan.cacheUserPref(setting, setting.getValueAsString());
                setting.setValue(simppValue);
            }
            this.simppKeyToSetting.put(simppKey, setting);
        }
    }

    synchronized Setting getSettingForSimppKey(String simppKey) {
        return (Setting)this.simppKeyToSetting.get(simppKey);
    }
}

