/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

public class SequenceNumberExtender {
    private static final long BASE_INCREMENT = 65536L;
    private static final long LOW_BASE_SWITCH_POINT = 32767L;
    private static final long HIGH_BASE_SWITCH_POINT = 16383L;
    private long lowBase = 0L;
    private long highBase = 0L;
    private boolean highSwitchPending = true;
    private boolean lowSwitchPending = false;

    public SequenceNumberExtender() {
    }

    public SequenceNumberExtender(long base) {
        this.lowBase = base &= 0xFFFFFFFFFFFF0000L;
        this.highBase = base;
    }

    public long extendSequenceNumber(long sequenceNumber) {
        if (sequenceNumber >= 16383L && sequenceNumber < 32767L && this.highSwitchPending) {
            this.highBase = this.lowBase;
            this.highSwitchPending = false;
            this.lowSwitchPending = true;
        }
        if (sequenceNumber > 32767L && this.lowSwitchPending) {
            this.lowBase += 65536L;
            this.highSwitchPending = true;
            this.lowSwitchPending = false;
        }
        long extendedSeqNo = sequenceNumber < 16383L ? sequenceNumber + this.lowBase : sequenceNumber + this.highBase;
        return extendedSeqNo;
    }
}

