/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.statistics.UploadStat;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PushProxyUploadState
extends UploadState {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$uploader$PushProxyUploadState == null ? (class$com$limegroup$gnutella$uploader$PushProxyUploadState = PushProxyUploadState.class$("com.limegroup.gnutella.uploader.PushProxyUploadState")) : class$com$limegroup$gnutella$uploader$PushProxyUploadState);
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$uploader$PushProxyUploadState;

    public PushProxyUploadState(HTTPUploader uploader) {
        super(uploader);
        LOG.debug("creating push proxy upload state");
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        LOG.debug("writing headers");
        byte[] clientGUID = GUID.fromHexString(this.UPLOADER.getFileName());
        InetAddress hostAddress = this.UPLOADER.getNodeAddress();
        int hostPort = this.UPLOADER.getNodePort();
        if (clientGUID.length != 16 || hostAddress == null || !NetworkUtils.isValidPort(hostPort) || !NetworkUtils.isValidAddress(hostAddress)) {
            String str = "HTTP/1.1 400 Push Proxy: Bad Request\r\n\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this.debug("PPUS.doUpload(): unknown host.");
            UploadStat.PUSH_PROXY_REQ_BAD.incrementStat();
            return;
        }
        Map params = this.UPLOADER.getParameters();
        int fileIndex = 0;
        Object index = params.get(P_FILE);
        if (index != null) {
            fileIndex = (Integer)index;
        }
        PushRequest push = new PushRequest(GUID.makeGuid(), 0, clientGUID, fileIndex, hostAddress.getAddress(), hostPort);
        try {
            RouterService.getMessageRouter().sendPushRequest(push);
        }
        catch (IOException ioe) {
            String str = "HTTP/1.1 410 Push Proxy: Servent not connected\r\n\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this.debug("PPUS.doUpload(): push failed.");
            this.debug(ioe);
            UploadStat.PUSH_PROXY_REQ_FAILED.incrementStat();
            return;
        }
        UploadStat.PUSH_PROXY_REQ_SUCCESS.incrementStat();
        String str = "HTTP/1.1 202 Push Proxy: Message Sent\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: application/x-gnutella-packets\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + this.BAOS.size() + "\r\n";
        ostream.write(str.getBytes());
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        LOG.debug("writing body");
        ostream.write(this.BAOS.toByteArray());
        this.UPLOADER.setAmountUploaded(this.BAOS.size());
        this.debug("PPUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return false;
    }

    private final void debug(String out) {
    }

    private final void debug(Exception out) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

