/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Buffer
implements Cloneable {
    private final int size;
    private Object[] buf;
    private int head;
    private int tail;

    public Buffer(int size) {
        Assert.that(size >= 1);
        this.size = size + 1;
        this.head = 0;
        this.tail = 0;
    }

    public Buffer(Buffer other) {
        this.size = other.size;
        this.head = other.head;
        this.tail = other.tail;
        if (other.buf != null) {
            this.buf = new Object[other.buf.length];
            System.arraycopy(other.buf, 0, this.buf, 0, other.buf.length);
        }
    }

    private void initialize() {
        if (this.buf == null) {
            this.buf = new Object[this.size + 1];
        }
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public boolean isFull() {
        return this.increment(this.tail) == this.head;
    }

    public final int size() {
        return this.getSize();
    }

    public int getSize() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.size - this.head + this.tail;
    }

    public int getCapacity() {
        return this.size - 1;
    }

    private int decrement(int i) {
        if (i == 0) {
            return this.size - 1;
        }
        return i - 1;
    }

    private int increment(int i) {
        if (i == this.size - 1) {
            return 0;
        }
        return i + 1;
    }

    private int index(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.getSize()) {
            throw new IndexOutOfBoundsException("index: " + i);
        }
        return (i + this.head) % this.size;
    }

    public Object get(int i) throws IndexOutOfBoundsException {
        this.initialize();
        return this.buf[this.index(i)];
    }

    public void set(int i, Object o) throws IndexOutOfBoundsException {
        this.initialize();
        this.buf[this.index((int)i)] = o;
    }

    public Object add(Object x) {
        return this.addFirst(x);
    }

    public Object addFirst(Object x) {
        this.initialize();
        Object ret = null;
        if (this.isFull()) {
            ret = this.removeLast();
        }
        this.head = this.decrement(this.head);
        this.buf[this.head] = x;
        return ret;
    }

    public Object addLast(Object x) {
        this.initialize();
        Object ret = null;
        if (this.isFull()) {
            ret = this.removeFirst();
        }
        this.buf[this.tail] = x;
        this.tail = this.increment(this.tail);
        return ret;
    }

    public boolean contains(Object x) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(x)) continue;
            return true;
        }
        return false;
    }

    public Object first() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.head];
    }

    public Object last() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.buf[this.decrement(this.tail)];
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object ret = this.buf[this.head];
        this.buf[this.head] = null;
        this.head = this.increment(this.head);
        return ret;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.tail = this.decrement(this.tail);
        Object ret = this.buf[this.tail];
        this.buf[this.tail] = null;
        return ret;
    }

    public Object remove(int i) throws IndexOutOfBoundsException {
        Object ret = this.get(i);
        int j = this.index(i);
        while (j != this.tail) {
            this.buf[j] = this.buf[this.increment(j)];
            j = this.increment(j);
        }
        this.tail = this.decrement(this.tail);
        this.buf[this.tail] = null;
        return ret;
    }

    public boolean remove(Object x) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!x.equals(this.get(i))) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public boolean removeAll(Object x) {
        boolean ret = false;
        for (int i = 0; i < this.getSize(); ++i) {
            if (!x.equals(this.get(i))) continue;
            this.remove(i);
            --i;
            ret = true;
        }
        return ret;
    }

    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    public Iterator iterator() {
        return new BufferIterator();
    }

    public Object clone() {
        return new Buffer(this);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        boolean isFirst = true;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!isFirst) {
                buf.append(", ");
            } else {
                isFirst = false;
            }
            buf.append(iter.next().toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private class BufferIterator
    extends UnmodifiableIterator {
        int i;
        int oldHead;
        int oldTail;

        BufferIterator() {
            this.i = Buffer.this.head;
            this.oldHead = Buffer.this.head;
            this.oldTail = Buffer.this.tail;
        }

        public boolean hasNext() {
            this.ensureNoModifications();
            return this.i != Buffer.this.tail;
        }

        public Object next() throws NoSuchElementException {
            this.ensureNoModifications();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object ret = Buffer.this.buf[this.i];
            this.i = Buffer.this.increment(this.i);
            return ret;
        }

        private void ensureNoModifications() {
            if (this.oldHead != Buffer.this.head || this.oldTail != Buffer.this.tail) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

