/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaFileManager
extends FileManager {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$xml$MetaFileManager == null ? (class$com$limegroup$gnutella$xml$MetaFileManager = MetaFileManager.class$("com.limegroup.gnutella.xml.MetaFileManager")) : class$com$limegroup$gnutella$xml$MetaFileManager);
    private final Object META_LOCK = new Object();
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$MetaFileManager;

    public synchronized Response[] query(QueryRequest request) {
        Response[] metas;
        LimeXMLDocument doc;
        Response[] result = super.query(request);
        if (this.shouldIncludeXMLInResponse(request) && (doc = request.getRichQuery()) != null && (metas = this.query(doc)) != null) {
            result = this.union(result, metas, doc);
        }
        return result;
    }

    protected boolean isValidXMLMatch(Response r, LimeXMLDocument doc) {
        return LimeXMLUtils.match(r.getDocument(), doc, true);
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest qr) {
        return qr.desiresXMLResponses() || qr.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fd) {
        List docs = fd.getLimeXMLDocuments();
        if (docs.size() == 0) {
            return;
        }
        if (docs.size() == 1) {
            response.setDocument((LimeXMLDocument)docs.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDesc fileChanged(File f) {
        FileDesc removed;
        FileDesc fd;
        if (LOG.isTraceEnabled()) {
            LOG.debug("File Changed: " + f);
        }
        if ((fd = this.getFileDescForFile(f)) == null) {
            return null;
        }
        CreationTimeCache ctCache = CreationTimeCache.instance();
        Long cTime = ctCache.getCreationTime(fd.getSHA1Urn());
        List xmlDocs = fd.getLimeXMLDocuments();
        if (LimeXMLUtils.isEditableFormat(f)) {
            try {
                LimeXMLDocument diskID3Doc = MetaDataReader.readDocument(f);
                xmlDocs = this.resolveWriteableDocs(xmlDocs, diskID3Doc);
            }
            catch (IOException e) {
                return super.fileChanged(f);
            }
        }
        if (fd != (removed = this.removeFileIfShared(f, false))) {
            Assert.that(false, "wanted to remove: " + fd + "\ndid remove: " + removed);
        }
        _needRebuild = true;
        fd = this.addFileIfShared(f, xmlDocs, false);
        if (fd != null && cTime != null) {
            CreationTimeCache creationTimeCache = ctCache;
            synchronized (creationTimeCache) {
                ctCache.removeTime(fd.getSHA1Urn());
                ctCache.addTime(fd.getSHA1Urn(), cTime);
                ctCache.commitTime(fd.getSHA1Urn());
            }
        }
        FileManagerEvent evt = null;
        evt = fd != null ? new FileManagerEvent(this, 4, new FileDesc[]{removed, fd}) : new FileManagerEvent(this, 2, new FileDesc[]{removed});
        RouterService.getCallback().handleFileManagerEvent(evt);
        return fd;
    }

    private List resolveWriteableDocs(List allDocs, LimeXMLDocument id3Doc) {
        LimeXMLDocument audioDoc = null;
        LimeXMLSchema audioSchema = LimeXMLSchemaRepository.instance().getSchema(AudioMetaData.schemaURI);
        Iterator iter = allDocs.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument doc = (LimeXMLDocument)iter.next();
            if (doc.getSchema() != audioSchema) continue;
            audioDoc = doc;
            break;
        }
        if (id3Doc.equals(audioDoc)) {
            return allDocs;
        }
        ArrayList<LimeXMLDocument> retList = new ArrayList<LimeXMLDocument>();
        retList.addAll(allDocs);
        if (audioDoc == null) {
            retList.add(id3Doc);
            return retList;
        }
        retList.remove(audioDoc);
        List audioList = audioDoc.getOrderedNameValueList();
        List id3List = id3Doc.getOrderedNameValueList();
        for (int i = 0; i < audioList.size(); ++i) {
            NameValue nameVal = (NameValue)audioList.get(i);
            if (!AudioMetaData.isNonLimeAudioField(nameVal.getName())) continue;
            id3List.add(nameVal);
        }
        audioDoc = new LimeXMLDocument(id3List, AudioMetaData.schemaURI);
        retList.add(audioDoc);
        return retList;
    }

    protected FileDesc removeFileIfShared(File f, boolean notify) {
        FileDesc fd = super.removeFileIfShared(f, notify);
        if (fd == null) {
            return null;
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        List xmlDocs = fd.getLimeXMLDocuments();
        LinkedList<String> schemas = new LinkedList<String>();
        Iterator i = xmlDocs.iterator();
        while (i.hasNext()) {
            schemas.add(((LimeXMLDocument)i.next()).getSchemaURI());
        }
        i = schemas.iterator();
        while (i.hasNext()) {
            String uri = (String)i.next();
            LimeXMLReplyCollection col = mapper.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
        _needRebuild = true;
        return fd;
    }

    protected FileDesc addFileIfShared(File file, List metadata, boolean notify) {
        FileDesc fd = super.addFileIfShared(file, false);
        if (fd == null) {
            return null;
        }
        if (metadata == null || metadata.size() == 0) {
            LimeXMLDocument doc;
            if (!LimeXMLUtils.isSupportedFormat(file)) {
                return fd;
            }
            try {
                doc = MetaDataReader.readDocument(file);
            }
            catch (IOException ioe) {
                return fd;
            }
            metadata = new LinkedList<LimeXMLDocument>();
            metadata.add(doc);
        }
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LinkedList<String> schemasAddedTo = new LinkedList<String>();
        Iterator iter = metadata.iterator();
        while (iter.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)iter.next();
            String uri = currDoc.getSchemaURI();
            LimeXMLReplyCollection collection = mapper.getReplyCollection(uri);
            if (collection == null || schemasAddedTo.contains(uri)) continue;
            schemasAddedTo.add(uri);
            if (LimeXMLUtils.isMP3File(file) && AudioMetaData.isCorrupted(currDoc)) {
                currDoc = AudioMetaData.fixCorruption(currDoc);
            }
            collection.addReplyWithCommit(file, fd, currDoc, true);
        }
        _needRebuild = true;
        if (notify && fd != null) {
            FileManagerEvent evt = new FileManagerEvent(this, 1, new FileDesc[]{fd});
            RouterService.getCallback().handleFileManagerEvent(evt);
        }
        return fd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadSettingsBlocking(boolean notifyOnClear) {
        RouterService.getCallback().setAnnotateEnabled(false);
        super.loadSettingsBlocking(notifyOnClear);
        if (this.loadThreadInterrupted()) {
            return;
        }
        Object object = this.META_LOCK;
        synchronized (object) {
            SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
            LimeXMLSchemaRepository schemaRepository = LimeXMLSchemaRepository.instance();
            if (this.loadThreadInterrupted()) {
                return;
            }
            String[] schemas = schemaRepository.getAvailableSchemaURIs();
            int len = schemas.length;
            FileDesc[] fds = super.getAllSharedFileDescriptors();
            for (int i = 0; i < len && !this.loadThreadInterrupted(); ++i) {
                String s = LimeXMLSchema.getDisplayString(schemas[i]);
                LimeXMLReplyCollection collection = new LimeXMLReplyCollection(fds, schemas[i], s.equalsIgnoreCase("audio"));
                mapper.add(schemas[i], collection);
            }
        }
        RouterService.getCallback().setAnnotateEnabled(true);
    }

    private Response[] union(Response[] normals, Response[] metas, LimeXMLDocument requested) {
        int i;
        if (normals == null || normals.length == 0) {
            return metas;
        }
        if (metas == null || metas.length == 0) {
            return normals;
        }
        HashSet<Response> unionSet = new HashSet<Response>();
        for (i = 0; i < metas.length; ++i) {
            unionSet.add(metas[i]);
        }
        for (i = 0; i < normals.length; ++i) {
            unionSet.add(normals[i]);
        }
        Response[] retArray = new Response[unionSet.size()];
        retArray = unionSet.toArray(retArray);
        return retArray;
    }

    protected void buildQRT() {
        super.buildQRT();
        Iterator iter = this.getXMLKeyWords().iterator();
        while (iter.hasNext()) {
            _queryRouteTable.add((String)iter.next());
        }
        iter = this.getXMLIndivisibleKeyWords().iterator();
        while (iter.hasNext()) {
            _queryRouteTable.addIndivisible((String)iter.next());
        }
    }

    private List getXMLKeyWords() {
        ArrayList words = new ArrayList();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        int len = schemas.length;
        for (int i = 0; i < len; ++i) {
            LimeXMLReplyCollection collection = map.getReplyCollection(schemas[i]);
            if (collection == null) continue;
            words.addAll(collection.getKeyWords());
        }
        return words;
    }

    private List getXMLIndivisibleKeyWords() {
        ArrayList<String> words = new ArrayList<String>();
        SchemaReplyCollectionMapper map = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository rep = LimeXMLSchemaRepository.instance();
        String[] schemas = rep.getAvailableSchemaURIs();
        for (int i = 0; i < schemas.length; ++i) {
            LimeXMLReplyCollection collection;
            if (schemas[i] != null) {
                words.add(schemas[i]);
            }
            if ((collection = map.getReplyCollection(schemas[i])) == null) continue;
            words.addAll(collection.getKeyWordsIndivisible());
        }
        return words;
    }

    private Response[] query(LimeXMLDocument queryDoc) {
        String schema = queryDoc.getSchemaURI();
        SchemaReplyCollectionMapper mapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection replyCol = mapper.getReplyCollection(schema);
        if (replyCol == null) {
            return null;
        }
        List matchingReplies = replyCol.getMatchingReplies(queryDoc);
        int s = matchingReplies.size();
        if (s == 0) {
            return null;
        }
        Response[] retResponses = new Response[s];
        int z = 0;
        Iterator i = matchingReplies.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currDoc = (LimeXMLDocument)i.next();
            File file = currDoc.getIdentifier();
            Response res = null;
            if (file == null) {
                res = new Response(0xFFFFFFFFL, 0L, " ");
            } else {
                FileDesc fd = RouterService.getFileManager().getFileDescForFile(file);
                if (fd == null) continue;
                res = new Response(fd);
                fd.incrementHitCount();
                RouterService.getCallback().handleSharedFileUpdate(fd.getFile());
            }
            res.setDocument(currDoc);
            retResponses[z] = res;
            ++z;
        }
        if (z == 0) {
            return null;
        }
        if (z < s) {
            Response[] temp = new Response[z];
            System.arraycopy(retResponses, 0, temp, 0, z);
            retResponses = temp;
        }
        return retResponses;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

