/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.UIManager;
import phex.Res;
import phex.common.Environment;
import phex.msg.GUID;
import phex.utils.FileUtils;
import phex.utils.IPUtils;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class Cfg {
    public static final int DEFAULT_SOCKS5_PORT = 1080;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 65536;
    public static final short DEFAULT_LOGGER_VERBOSE_LEVEL = 6;
    public static final boolean DEFAULT_ENABLE_HIT_SNOOPING = true;
    public static final boolean DEFAULT_IS_CHAT_ENABLED = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_LEAF = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_ULTRAPEER = true;
    public static final boolean DEFAULT_FORCE_UP_CONNECTIONS = false;
    public static final boolean DEFAULT_IS_NOVENDOR_NODE_DISCONNECTED = false;
    public static final int DEFAULT_FREELOADER_FILES = 0;
    public static final int DEFAULT_FREELOADER_SHARE_SIZE = 0;
    public static final int DEFAULT_HOST_ERROR_DISPLAY_TIME = 1000;
    public static final int DEFAULT_TTL = 7;
    public static final int DEFAULT_MAX_TTL = 7;
    public static final int DEFAULT_UP_2_UP_CONNECTIONS = 5;
    public static final int DEFAULT_UP_2_LEAF_CONNECTIONS = 10;
    public static final int DEFAULT_UP_2_PEER_CONNECTIONS = 4;
    public static final int DEFAULT_LEAF_2_UP_CONNECTIONS = 3;
    public static final int DEFAULT_LEAF_2_PEER_CONNECTIONS = 3;
    public static final int DEFAULT_PEER_CONNECTIONS = 4;
    public static final int DEFAULT_MAX_CONNECTTO_HISTORY_SIZE = 10;
    public static final int DEFAULT_MAX_SEARCHTERM_HISTORY_SIZE = 10;
    public static final boolean DEFAULT_ARE_PARTIAL_FILES_SHARED = true;
    public static final boolean DEFAULT_FORCE_TOBE_ULTRAPEER = false;
    public static final int DEFAULT_MAX_DOWNLOADS_PER_IP = 1;
    public static final boolean DEFAULT_ALLOW_UPLOAD_QUEUING = true;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_SIZE = 100;
    public static final int DEFAULT_MIN_UPLOAD_QUEUE_POLL_TIME = 45;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_POLL_TIME = 120;
    public static final short DEFAULT_DOWNLOAD_SPLIT_TYPE = 0;
    public static final short DEFAULT_DOWNLOAD_SPLIT_TYPE_VALUE = 10;
    public static final int UNLIMITED_BANDWIDTH = Integer.MAX_VALUE;
    public static int MIN_SEARCH_TERM_LENGTH = 2;
    public static final String GENERAL_GNUTELLA_NETWORK = "<General Gnutella Network>";
    public GUID mProgramClientID = new GUID();
    public String mMyIP = "";
    public int mListeningPort = -1;
    public int mMaxUpload = 4;
    public int mMaxUploadPerIP = 1;
    public int mUploadMaxBandwidth = 102400;
    public int mNetMaxHostToCatch = 1000;
    public int mNetMaxSendQueue = 500;
    public int mSearchMaxConcurrent = 10;
    public int mNetMaxRate = 50000;
    public int mDownloadMaxBandwidth = 102400;
    public boolean mDownloadAutoRemoveCompleted = false;
    public String mDownloadDir = ".";
    public int mDownloadMaxRetry = 999;
    public int mDownloadRetryWait = 4000;
    public boolean mAutoConnect = true;
    public int mNetMinConn = 4;
    public boolean mAutoCleanup = true;
    public int mUploadMaxSearch = 64;
    public boolean mShareBrowseDir = true;
    public int mPushTransferTimeout = 30000;
    public ArrayList mNetIgnoredHosts;
    public Vector mNetInvalidHosts = new Vector();
    public Vector mFilteredSearchHosts = new Vector();
    public String mCurrentNetwork = "<General Gnutella Network>";
    public Vector mNetNetworkHistory = new Vector();
    public boolean mAutoJoin = true;
    public boolean mDisconnectApplyPolicy = true;
    public int mDisconnectDropRatio = 70;
    public boolean mProxyUse = false;
    public String mProxyHost = "";
    public int mProxyPort = 1080;
    public boolean useProxyAuthentication = false;
    public String mProxyUserName = "";
    public String mProxyPassword = "";
    public Font mFontMenu = new Font("Dialog", 0, 11);
    public Font mFontLabel = new Font("Dialog", 0, 11);
    public Font mFontTable = new Font("Dialog", 0, 11);
    public String mFindText = "";
    public boolean mFindMatchCase = false;
    public boolean mFindDown = true;
    public boolean mUIDisplayTooltip = true;
    public String mLFClassName;
    public String mUploadDir = "";
    public String mUploadFileExclusions = "";
    public String mUploadFileInclusions = "*";
    public boolean mUploadScanRecursively = true;
    public boolean mUploadAutoRemoveCompleted = false;
    public boolean mPhexPingResponse = true;
    public boolean monitorSearchHistory = false;
    public String searchMonitorFile = "";
    public int searchHistoryLength = 10;
    public boolean connectedToLAN = true;
    public boolean minimizeToBackground = true;
    public boolean showCloseOptionsDialog = true;
    public String incompleteDir = ".";
    public ArrayList filteredCatcherPorts = new ArrayList();
    public short maxWorkerPerDownload = (short)3;
    public short maxTotalDownloadWorker = (short)6;
    public boolean allowUploadQueuing;
    public int maxUploadQueueSize;
    public int minUploadQueuePollTime;
    public int maxUploadQueuePollTime;
    public short downloadSplitType;
    public int downloadSplitValue;
    public int maxDownloadsPerIP;
    public short maxFailedConnectionsInARow = (short)10;
    public int networkSpeedKbps = 256;
    public int maxTotalBandwidth = 16384;
    public String runningPhexVersion = "";
    public String runningBuildNumber = "";
    public boolean isBehindFirewall = false;
    public boolean isHttpProxyUsed = false;
    public String httpProxyHost = "";
    public int httpProxyPort = 80;
    public String lastUpdateCheckVersion = "0";
    public String lastBetaUpdateCheckVersion = "0";
    public long lastUpdateCheckTime = 0L;
    public boolean showUpdateNotification = true;
    public boolean showBetaUpdateNotification = false;
    public int mSocketTimeout = 20000;
    public int privateSocketTimeout = 2000;
    public int mNetConnectionTimeout = 30000;
    public int searchRetryTimeout = 30000;
    public short loggerVerboseLevel;
    public short logType = 1;
    public boolean logToConsole = false;
    public long maxLogFileLength = 524288L;
    public boolean enableHitSnooping;
    public int maxMessageLength;
    public boolean isChatEnabled;
    public boolean allowUPConnections;
    public boolean allowToBecomeLeaf;
    public boolean forceUPConnections;
    public boolean allowToBecomeUP;
    public boolean forceToBeUltrapeer;
    public int up2upConnections;
    public int up2leafConnections;
    public int up2peerConnections;
    public int leaf2upConnections;
    public int leaf2peerConnections;
    public int peerConnections;
    public boolean isNoVendorNodeDisconnected;
    public int freeloaderFiles;
    public int freeloaderShareSize;
    public int hostErrorDisplayTime;
    public int ttl;
    public int maxTTL;
    public ArrayList connectToHistory;
    public int maxConnectToHistorySize;
    public ArrayList searchTermHistory;
    public int maxSearchTermHistorySize;
    public boolean arePartialFilesShared;
    public long movingTotalUptime;
    public int movingTotalUptimeCount;
    public long maximalUptime;
    private File configFile;
    private Properties mSetting;

    public Cfg(File file) {
        this.configFile = file;
        this.mSetting = new Properties();
    }

    public void load() {
        Object object;
        this.loadDefaultValues();
        try {
            object = new FileInputStream(this.configFile);
            this.mSetting.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
        this.deserializeSimpleFields();
        this.deserializeComplexFields();
        this.handlePhexVersionAdjustments();
        if (this.mListeningPort == -1) {
            object = new Random(System.currentTimeMillis());
            this.mListeningPort = ((Random)object).nextInt();
            this.mListeningPort = this.mListeningPort < 0 ? -this.mListeningPort : this.mListeningPort;
            this.mListeningPort %= 20000;
            this.mListeningPort += 4000;
        }
        this.updateHTTPProxySettings();
        if (this.mLFClassName == null) {
            this.mLFClassName = Environment.getInstance().isMacOSX() ? UIManager.getSystemLookAndFeelClassName() : UIManager.getCrossPlatformLookAndFeelClassName();
        }
        object = new File(this.mDownloadDir);
        ((File)object).mkdirs();
        object = new File(this.incompleteDir);
        ((File)object).mkdirs();
    }

    public void save() {
        Logger.logMessage(Logger.FINEST, (short)255, "Saving configuration.");
        this.mSetting.clear();
        this.serializeSimpleFields();
        this.serializeComplexField();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.configFile);
            this.mSetting.store(fileOutputStream, "PHEX Config Values");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
    }

    private void loadDefaultValues() {
        this.downloadSplitType = 0;
        this.downloadSplitValue = 10;
        this.maxDownloadsPerIP = 1;
        this.enableHitSnooping = true;
        this.maxMessageLength = 65536;
        this.isChatEnabled = true;
        this.allowToBecomeLeaf = true;
        this.forceUPConnections = false;
        this.forceToBeUltrapeer = false;
        this.allowToBecomeUP = true;
        this.isNoVendorNodeDisconnected = false;
        this.freeloaderFiles = 0;
        this.freeloaderShareSize = 0;
        this.hostErrorDisplayTime = 1000;
        this.ttl = 7;
        this.maxTTL = 7;
        this.up2upConnections = 5;
        this.up2leafConnections = 10;
        this.up2peerConnections = 4;
        this.leaf2upConnections = 3;
        this.leaf2peerConnections = 3;
        this.peerConnections = 4;
        this.arePartialFilesShared = true;
        this.allowUploadQueuing = true;
        this.maxUploadQueueSize = 100;
        this.minUploadQueuePollTime = 45;
        this.maxUploadQueuePollTime = 120;
        this.loggerVerboseLevel = (short)6;
        this.connectToHistory = new ArrayList();
        this.maxConnectToHistorySize = 10;
        this.searchTermHistory = new ArrayList();
        this.maxSearchTermHistorySize = 10;
    }

    private String get(String string) {
        String string2 = (String)this.mSetting.get(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    private String get(String string, String string2) {
        String string3 = this.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private boolean getBool(String string, boolean bl) {
        return this.get(string, bl ? "true" : "false").equals("true");
    }

    private void set(String string, String string2) {
        if (string2 != null) {
            this.mSetting.put(string, string2);
        }
    }

    private void set(String string, long l) {
        this.mSetting.put(string, String.valueOf(l));
    }

    private void set(String string, boolean bl) {
        this.mSetting.put(string, bl ? "true" : "false");
    }

    private void serializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            String string = fieldArray[n].getName();
            int n2 = fieldArray[n].getModifiers();
            Class<?> clazz = fieldArray[n].getType();
            if (Modifier.isPublic(n2) && !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                try {
                    if (clazz.getName().equals("int")) {
                        this.set(string, fieldArray[n].getInt(this));
                    } else if (clazz.getName().equals("short")) {
                        this.set(string, fieldArray[n].getShort(this));
                    } else if (clazz.getName().equals("long")) {
                        this.set(string, fieldArray[n].getLong(this));
                    } else if (clazz.getName().equals("boolean")) {
                        this.set(string, fieldArray[n].getBoolean(this));
                    } else if (clazz.getName().equals("java.lang.String")) {
                        this.set(string, (String)fieldArray[n].get(this));
                    }
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error in field: " + string);
                }
            }
            ++n;
        }
    }

    private void serializeComplexField() {
        try {
            this.set("mProgramClientID", this.mProgramClientID.toHexString());
            StringBuffer stringBuffer = new StringBuffer(16 * this.mNetIgnoredHosts.size());
            int n = 0;
            while (n < this.mNetIgnoredHosts.size()) {
                String[] stringArray = (String[])this.mNetIgnoredHosts.get(n);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n;
            }
            this.set("mNetIgnoredHosts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n2 = 0;
            while (n2 < this.mFilteredSearchHosts.size()) {
                String[] stringArray = (String[])this.mFilteredSearchHosts.elementAt(n2);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n2;
            }
            this.set("mFilteredSearchHosts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n3 = 0;
            while (n3 < this.mNetInvalidHosts.size()) {
                String[] stringArray = (String[])this.mNetInvalidHosts.elementAt(n3);
                stringBuffer.append(stringArray[0]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[1]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[2]);
                stringBuffer.append('.');
                stringBuffer.append(stringArray[3]);
                stringBuffer.append(' ');
                ++n3;
            }
            this.set("mNetInvalidHosts", stringBuffer.toString());
            int n4 = this.filteredCatcherPorts.size();
            stringBuffer.setLength(0);
            int n5 = 0;
            while (n5 < n4) {
                stringBuffer.append((String)this.filteredCatcherPorts.get(n5));
                stringBuffer.append(" ");
                ++n5;
            }
            this.set("filteredCatcherPorts", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n6 = 0;
            while (n6 < this.mNetNetworkHistory.size()) {
                stringBuffer.append(this.mNetNetworkHistory.elementAt(n6));
                stringBuffer.append(" ");
                ++n6;
            }
            this.set("mNetNetworkHistory", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n7 = 0;
            while (n7 < this.connectToHistory.size()) {
                stringBuffer.append(this.connectToHistory.get(n7));
                stringBuffer.append(" ");
                ++n7;
            }
            this.set("connectToHistory", stringBuffer.toString());
            stringBuffer.setLength(0);
            int n8 = 0;
            while (n8 < this.searchTermHistory.size()) {
                stringBuffer.append(this.searchTermHistory.get(n8));
                stringBuffer.append(',');
                ++n8;
            }
            this.set("searchTermHistory", stringBuffer.toString());
            this.set("mFontMenu", this.mFontMenu.getName() + ";" + this.mFontMenu.getStyle() + ";" + this.mFontMenu.getSize());
            this.set("mFontLabel", this.mFontLabel.getName() + ";" + this.mFontLabel.getStyle() + ";" + this.mFontLabel.getSize());
            this.set("mFontTable", this.mFontTable.getName() + ";" + this.mFontTable.getStyle() + ";" + this.mFontTable.getSize());
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    private void deserializeSimpleFields() {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            String string = fieldArray[n].getName();
            int n2 = fieldArray[n].getModifiers();
            Class<?> clazz = fieldArray[n].getType();
            String string2 = "";
            if (Modifier.isPublic(n2) && !Modifier.isTransient(n2) && !Modifier.isStatic(n2)) {
                try {
                    string2 = this.get(string);
                    if (string2 != null) {
                        if (clazz.getName().equals("int")) {
                            fieldArray[n].setInt(this, Integer.parseInt(string2));
                        } else if (clazz.getName().equals("short")) {
                            fieldArray[n].setShort(this, Short.parseShort(string2));
                        } else if (clazz.getName().equals("long")) {
                            fieldArray[n].setLong(this, Long.parseLong(string2));
                        } else if (clazz.getName().equals("boolean")) {
                            fieldArray[n].setBoolean(this, string2.equals("true"));
                        } else if (clazz.getName().equals("java.lang.String")) {
                            fieldArray[n].set(this, string2);
                        }
                    }
                }
                catch (Exception exception) {
                    Logger.logError(exception, "Error in field: " + string + ", value: " + string2);
                }
            }
            ++n;
        }
    }

    private void deserializeComplexFields() {
        block26: {
            try {
                String string;
                String string2;
                String string3;
                String string4;
                try {
                    this.mProgramClientID.fromHexString(this.get("mProgramClientID"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string5 = this.get("mNetIgnoredHosts", "");
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                if (this.mNetIgnoredHosts == null) {
                    this.mNetIgnoredHosts = new ArrayList(stringTokenizer.countTokens());
                } else {
                    this.mNetIgnoredHosts.clear();
                    this.mNetInvalidHosts.ensureCapacity(stringTokenizer.countTokens());
                }
                while (stringTokenizer.hasMoreTokens()) {
                    this.mNetIgnoredHosts.add(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
                }
                this.mNetInvalidHosts.trimToSize();
                String string6 = this.get("mFilteredSearchHosts", "");
                if (string6 != null) {
                    stringTokenizer = new StringTokenizer(string6);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.mFilteredSearchHosts.addElement(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
                    }
                }
                if ((string4 = this.get("mNetInvalidHosts")) != null) {
                    stringTokenizer = new StringTokenizer(string4);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.mNetInvalidHosts.addElement(IPUtils.splitIP2Parts(stringTokenizer.nextToken()));
                    }
                }
                if ((string3 = this.get("filteredCatcherPorts")) != null) {
                    stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.filteredCatcherPorts.add(stringTokenizer.nextToken());
                    }
                }
                String string7 = this.get("mNetNetworkHistory", "");
                stringTokenizer = new StringTokenizer(string7);
                while (stringTokenizer.hasMoreTokens()) {
                    this.mNetNetworkHistory.addElement(stringTokenizer.nextToken());
                }
                String string8 = this.get("connectToHistory", "");
                if (string8 != null) {
                    stringTokenizer = new StringTokenizer(string8);
                    while (stringTokenizer.hasMoreTokens()) {
                        this.connectToHistory.add(stringTokenizer.nextToken());
                    }
                }
                if ((string2 = this.get("searchTermHistory", "")) != null) {
                    stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        this.searchTermHistory.add(stringTokenizer.nextToken().trim());
                    }
                }
                if ((string = this.get("mFontMenu")) != null) {
                    try {
                        stringTokenizer = new StringTokenizer(string, ";");
                        this.mFontMenu = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = this.get("mFontLabel")) != null) {
                    try {
                        stringTokenizer = new StringTokenizer(string, ";");
                        this.mFontLabel = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((string = this.get("mFontTable")) == null) break block26;
                try {
                    stringTokenizer = new StringTokenizer(string, ";");
                    this.mFontTable = new Font(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
    }

    public void updateHTTPProxySettings() {
        System.setProperty("http.agent", Environment.getPhexVendor());
        if (this.isHttpProxyUsed) {
            System.setProperty("http.proxyHost", this.httpProxyHost);
            System.setProperty("http.proxyPort", String.valueOf(this.httpProxyPort));
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
    }

    private void handlePhexVersionAdjustments() {
        if (!(this.runningPhexVersion != null && this.runningPhexVersion.length() != 0 || this.runningBuildNumber != null && this.runningBuildNumber.length() != 0)) {
            return;
        }
        if (this.runningPhexVersion == null || this.runningPhexVersion.length() == 0) {
            this.runningPhexVersion = "0.6";
        }
        if (VersionUtils.compare("0.7", this.runningPhexVersion) > 0) {
            this.updatesFor0_7();
        }
        if (VersionUtils.compare("0.8", this.runningPhexVersion) > 0) {
            this.updatesFor0_8();
        }
        if (this.runningBuildNumber == null || this.runningBuildNumber.length() == 0) {
            this.runningBuildNumber = "35";
        }
        if (VersionUtils.compare("36", this.runningBuildNumber) > 0) {
            this.updatesForBuild36();
        }
        this.runningBuildNumber = Environment.getInstance().getProperty("build.number");
        this.runningPhexVersion = Res.getStr("Program.Version");
        this.save();
    }

    private void updatesFor0_7() {
        try {
            File file = Environment.getInstance().getPhexConfigFile("phexdownload.xml");
            if (file.exists()) {
                FileUtils.copyFile(file, new File(file.getAbsolutePath() + ".v0.6.4"));
            }
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        this.runningPhexVersion = "0.7";
    }

    private void updatesFor0_8() {
        this.peerConnections = this.mNetMinConn;
        this.runningPhexVersion = "0.8";
        this.mUploadMaxSearch = 64;
        this.mNetMaxHostToCatch = 1000;
    }

    private void updatesForBuild36() {
        this.runningBuildNumber = "36";
        this.allowToBecomeLeaf = this.allowUPConnections;
    }
}

