/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import phex.xml.XJBMediaType;

public class MediaType {
    public static final String MEDIA_TYPE_ANY = "AnyMediaType";
    public static final String MEDIA_TYPE_AUDIO = "AudioMediaType";
    public static final String MEDIA_TYPE_VIDEO = "VideoMediaType";
    public static final String MEDIA_TYPE_PROGRAM = "ProgramMediaType";
    private static MediaType[] allMediaTypes = new MediaType[4];
    private String name;
    private String[] fileTypes;
    private String fileTypesView;

    private MediaType(String string, String[] stringArray) {
        this.name = string;
        this.fileTypes = stringArray;
    }

    public String getName() {
        return this.name;
    }

    public String getFileTypesView() {
        if (this.fileTypesView == null) {
            if (this.fileTypes == null) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.fileTypes.length * 5);
            int n = 0;
            while (n < this.fileTypes.length) {
                stringBuffer.append(this.fileTypes[n]);
                if (n < this.fileTypes.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            this.fileTypesView = stringBuffer.toString();
        }
        return this.fileTypesView;
    }

    public boolean isExtensionOf(String string) {
        if (this.fileTypes == null) {
            return true;
        }
        string = string.toLowerCase();
        int n = 0;
        while (n < this.fileTypes.length) {
            if (this.fileTypes[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isFilenameOf(String string) {
        if (this.fileTypes == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1, string.length());
        return this.isExtensionOf(string2);
    }

    public static MediaType[] getAllMediaTypes() {
        return allMediaTypes;
    }

    public static MediaType getMediaTypeAny() {
        return allMediaTypes[0];
    }

    public static XJBMediaType convertToXJBMediaType(MediaType mediaType) {
        if (mediaType.name.equals(MEDIA_TYPE_ANY)) {
            return XJBMediaType.ANY;
        }
        if (mediaType.name.equals(MEDIA_TYPE_AUDIO)) {
            return XJBMediaType.AUDIO;
        }
        if (mediaType.name.equals(MEDIA_TYPE_VIDEO)) {
            return XJBMediaType.VIDEO;
        }
        if (mediaType.name.equals(MEDIA_TYPE_PROGRAM)) {
            return XJBMediaType.PROGRAM;
        }
        throw new IllegalArgumentException("Unknown media type: " + mediaType.name);
    }

    public static MediaType convertFromXJBMediaType(XJBMediaType xJBMediaType) {
        if (xJBMediaType == XJBMediaType.ANY) {
            return allMediaTypes[0];
        }
        if (xJBMediaType == XJBMediaType.AUDIO) {
            return allMediaTypes[1];
        }
        if (xJBMediaType == XJBMediaType.VIDEO) {
            return allMediaTypes[2];
        }
        if (xJBMediaType == XJBMediaType.PROGRAM) {
            return allMediaTypes[3];
        }
        throw new IllegalArgumentException("Unknown media type: " + xJBMediaType.toString());
    }

    static {
        MediaType.allMediaTypes[0] = new MediaType(MEDIA_TYPE_ANY, null);
        MediaType.allMediaTypes[1] = new MediaType(MEDIA_TYPE_AUDIO, new String[]{"mp3", "wav", "ra", "ram", "rmj", "au", "aif", "aiff", "ogg"});
        MediaType.allMediaTypes[2] = new MediaType(MEDIA_TYPE_VIDEO, new String[]{"avi", "divx", "mov", "mpg", "mpeg", "rm", "ram", "asf", "swf", "qt", "jve"});
        MediaType.allMediaTypes[3] = new MediaType(MEDIA_TYPE_PROGRAM, new String[]{"exe", "bin", "zip", "tar", "tgz", "gz", "gzip"});
    }
}

