/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import phex.common.bandwidth.BandwidthController;

public class ControllerWindowTimer
extends Thread {
    private static final long oneSecondInMillis = 1000L;
    private static final long paneLengthInMillis = 1000L;
    protected static final ControllerWindowTimer instance = new ControllerWindowTimer(1000L);
    private final List throttles;
    private final long resetPeriodInMillis;
    private long lastSlideTime = 0L;

    private ControllerWindowTimer(long l) {
        super("ThrottleResetTimer");
        this.resetPeriodInMillis = l;
        this.throttles = new LinkedList();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThrottleController(BandwidthController bandwidthController) {
        List list = this.throttles;
        synchronized (list) {
            this.throttles.add(bandwidthController);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean deregisterThrottleController(BandwidthController bandwidthController) {
        List list = this.throttles;
        synchronized (list) {
            return this.throttles.remove(bandwidthController);
        }
    }

    public long getRemainingTimeThisPeriod() {
        return this.resetPeriodInMillis - (System.currentTimeMillis() - this.lastSlideTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.resetPeriodInMillis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            List list = this.throttles;
            synchronized (list) {
                ListIterator listIterator = this.throttles.listIterator();
                while (listIterator.hasNext()) {
                    BandwidthController bandwidthController = (BandwidthController)listIterator.next();
                    bandwidthController.newRatePeriod();
                }
                this.lastSlideTime = System.currentTimeMillis();
            }
        }
    }
}

