/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import phex.common.Environment;
import phex.connection.ProtocolNotSupportedException;
import phex.host.HostAddress;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;
import phex.utils.VersionUtils;

public class GWebCacheConnection {
    private static final String PING_QUERY = "ping=1";
    private static final String HOST_FILE_QUERY = "hostfile=1";
    private static final String URL_FILE_QUERY = "urlfile=1";
    private static final String IP_QUERY = "ip=";
    private static final String URL_QUERY = "url=";
    private static final String QUERY_POSTFIX = "&client=PHEX&version=" + VersionUtils.getProgramVersion();
    private URL gWebCacheURL;
    private HttpURLConnection connection;
    private BufferedReader reader;
    boolean isCacheBad;

    public GWebCacheConnection(URL uRL) throws ProtocolNotSupportedException {
        if (!uRL.getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        this.gWebCacheURL = uRL;
        this.isCacheBad = false;
    }

    public URL getGWebCacheURL() {
        return this.gWebCacheURL;
    }

    public boolean sendPingRequest() {
        try {
            URL uRL = new URL(this.gWebCacheURL, this.gWebCacheURL.getPath() + '?' + PING_QUERY + QUERY_POSTFIX);
            this.openConnection(uRL);
            String string = this.reader.readLine();
            if (string.startsWith("PONG")) {
                return true;
            }
            this.isCacheBad = true;
            return false;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.logMessage(Logger.FINEST, (short)16, unknownHostException);
            this.isCacheBad = true;
            return false;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            return false;
        }
    }

    public HostAddress[] sendHostFileRequest() {
        try {
            Object[] objectArray;
            URL uRL = new URL(this.gWebCacheURL, this.gWebCacheURL.getPath() + '?' + HOST_FILE_QUERY + QUERY_POSTFIX);
            this.openConnection(uRL);
            String string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                return null;
            }
            boolean bl = false;
            ArrayList<HostAddress> arrayList = new ArrayList<HostAddress>(20);
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            while (string != null) {
                objectArray = HostAddress.parseIP(string);
                if (objectArray == null) {
                    string = this.reader.readLine();
                    bl = true;
                    continue;
                }
                byte by = phexSecurityManager.controlHostIPAccess((byte[])objectArray);
                switch (by) {
                    case 2: 
                    case 3: {
                        string = this.reader.readLine();
                        break;
                    }
                    default: {
                        int n = HostAddress.parsePort(string);
                        if (n != -1) {
                            HostAddress hostAddress = new HostAddress((byte[])objectArray, n);
                            arrayList.add(hostAddress);
                        } else {
                            bl = true;
                        }
                        string = this.reader.readLine();
                    }
                }
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                return null;
            }
            objectArray = new HostAddress[arrayList.size()];
            arrayList.toArray(objectArray);
            return objectArray;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            return null;
        }
    }

    public URL[] sendURLFileRequest() {
        try {
            URL[] uRLArray;
            URL uRL = new URL(this.gWebCacheURL, this.gWebCacheURL.getPath() + '?' + URL_FILE_QUERY + QUERY_POSTFIX);
            this.openConnection(uRL);
            String string = this.reader.readLine();
            if (string != null && string.startsWith("ERROR")) {
                this.isCacheBad = true;
                return null;
            }
            boolean bl = false;
            ArrayList<URL[]> arrayList = new ArrayList<URL[]>(20);
            while (string != null) {
                try {
                    uRLArray = new URL(string);
                    if (!uRLArray.getProtocol().equals("http")) {
                        throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
                    }
                    arrayList.add(uRLArray);
                }
                catch (MalformedURLException malformedURLException) {
                    bl = true;
                }
                string = this.reader.readLine();
            }
            if (arrayList.size() == 0 && bl) {
                this.isCacheBad = true;
                return null;
            }
            uRLArray = new URL[arrayList.size()];
            arrayList.toArray(uRLArray);
            return uRLArray;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            return null;
        }
    }

    public boolean updateRequest(String string, String string2) {
        if (string == null && string2 == null) {
            throw new IllegalArgumentException("Must provide at least one of hostIP or cacheURL.");
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append(IP_QUERY);
                stringBuffer.append(URLEncoder.encode(string));
            }
            if (string2 != null) {
                if (string != null) {
                    stringBuffer.append('&');
                }
                stringBuffer.append(URL_QUERY);
                stringBuffer.append(URLEncoder.encode(string2));
            }
            URL uRL = new URL(this.gWebCacheURL, this.gWebCacheURL.getPath() + '?' + stringBuffer.toString() + QUERY_POSTFIX);
            this.openConnection(uRL);
            String string3 = this.reader.readLine();
            if (string3.startsWith("OK")) {
                return true;
            }
            this.isCacheBad = true;
            return false;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)16, iOException);
            this.isCacheBad = true;
            return false;
        }
    }

    public boolean isCacheBad() {
        return this.isCacheBad;
    }

    private void openConnection(URL uRL) throws IOException {
        this.connection = (HttpURLConnection)uRL.openConnection();
        this.connection.setUseCaches(false);
        this.connection.setRequestProperty("User-Agent", Environment.getPhexVendor());
        try {
            this.reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        int n = this.connection.getResponseCode();
        Logger.logMessage(Logger.FINE, (short)16, "GWebCache connection to " + uRL + " returned response code: " + n);
        if (n >= 400 && n <= 599) {
            throw new ConnectException("GWebCache service not available, response code: " + n);
        }
    }
}

