/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.GUID;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class IncomingConnectionDispatcher
implements Runnable {
    public static final String GET_REQUEST_PREFIX = "GET ";
    public static final String GIV_REQUEST_PREFIX = "GIV ";
    public static final String CHAT_REQUEST_PREFIX = "CHAT ";
    private Socket socket;

    public IncomingConnectionDispatcher(Socket socket) {
        this.socket = socket;
    }

    public void run() {
        block17: {
            GnutellaInputStream gnutellaInputStream = null;
            try {
                if (!NetworkManager.getInstance().isNetworkJoined()) {
                    throw new IOException("Network not joined.");
                }
                InputStream inputStream = this.socket.getInputStream();
                gnutellaInputStream = new GnutellaInputStream(inputStream, ServiceManager.getInstance().getNetworkBandwidthController());
                this.socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
                String string = gnutellaInputStream.readLine();
                if (string == null) {
                    throw new IOException("Disconnected from remote host during handshake");
                }
                Logger.logMessage(Logger.FINE, (short)16, "ConnectionRequest " + string);
                String string2 = NetworkManager.getInstance().getNetworkGreeting();
                if (string.startsWith(string2 + "/")) {
                    HostAddress hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                    Host host = new Host(hostAddress, this.socket, gnutellaInputStream);
                    host.setType(Host.TYPE_INCOMING);
                    host.setStatus(3, "");
                    HostManager.getInstance().acceptIncomingConnection(host, string);
                    break block17;
                }
                if (string.startsWith(GET_REQUEST_PREFIX)) {
                    HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest(string);
                    HTTPProcessor.parseHTTPHeaders(hTTPRequest, gnutellaInputStream);
                    Logger.logMessage(Logger.FINEST, (short)255, "GET Request: " + hTTPRequest.buildHTTPRequestString());
                    if (hTTPRequest.isGnutellaRequest()) {
                        UploadManager.getInstance().handleUploadRequest(this.socket, gnutellaInputStream, hTTPRequest);
                    } else {
                        HostAddress hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                        Host host = new Host(hostAddress);
                        host.setType(Host.TYPE_INCOMING);
                        host.setSocket(this.socket);
                        host.setStatus(3, "");
                        ShareManager.getInstance().httpRequestHandler(hTTPRequest, host);
                    }
                    break block17;
                }
                if (string.startsWith(GIV_REQUEST_PREFIX)) {
                    String string3 = string.substring(4);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                    String string4 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "/");
                    String string5 = stringTokenizer2.nextToken();
                    String string6 = URLDecoder.decode(stringTokenizer2.nextToken());
                    GUID gUID = new GUID(string5);
                    PushHandler.handleIncommingGIV(this.socket, gUID, string6);
                    break block17;
                }
                if (string.startsWith(CHAT_REQUEST_PREFIX)) {
                    HostAddress hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), this.socket.getPort());
                    Logger.logMessage(Logger.FINE, (short)16, "Chat request from: " + hostAddress.getFullHostName());
                    ChatManager.getInstance().acceptChat(this.socket, gnutellaInputStream, hostAddress);
                    break block17;
                }
                throw new IOException("Unknown connection request: " + string);
            }
            catch (HTTPMessageException hTTPMessageException) {
                Logger.logMessage(Logger.FINE, (short)16, hTTPMessageException);
                if (gnutellaInputStream != null) {
                    gnutellaInputStream.close();
                }
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                Logger.logMessage(Logger.FINE, (short)16, iOException);
                if (gnutellaInputStream != null) {
                    gnutellaInputStream.close();
                }
                try {
                    this.socket.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }
}

