/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.IncomingConnectionDispatcher;
import phex.connection.NetworkManager;
import phex.host.HostAddress;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;

public class IncomingListener
implements Runnable {
    private ServerSocket listeningSocket;
    private boolean isRequestedToDie = false;
    private boolean isRunning = false;
    private boolean hasConnectedIncomming = false;

    public synchronized void initialize() throws IOException {
        boolean bl;
        if (this.isRunning) {
            return;
        }
        int n = ServiceManager.sCfg.mListeningPort;
        int n2 = 0;
        do {
            bl = false;
            try {
                this.listeningSocket = new ServerSocket(n, 50);
            }
            catch (BindException bindException) {
                if (n2 > 10) {
                    throw bindException;
                }
                bl = true;
                ++n;
                ++n2;
            }
        } while (bl);
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            NetworkManager.getInstance().setForcedHostIP(HostAddress.parseIP(ServiceManager.sCfg.mMyIP));
        } else {
            byte[] byArray = this.resolveLocalHostIP();
            n = this.listeningSocket.getLocalPort();
            NetworkManager.getInstance().updateLocalAddress(byArray, n);
        }
    }

    public synchronized void startup() {
        if (this.isRunning) {
            return;
        }
        Logger.logMessage(Logger.FINER, (short)255, "Starting Listener");
        this.isRequestedToDie = false;
        this.isRunning = true;
        ThreadPool.getInstance().addJob(this, "IncommingListener-" + Integer.toHexString(this.hashCode()));
    }

    public synchronized void restart() throws IOException {
        this.shutdown(true);
        this.initialize();
        this.startup();
    }

    public synchronized void shutdown(boolean bl) {
        if (!this.isRunning || this.isRequestedToDie) {
            return;
        }
        Logger.logMessage(Logger.FINER, (short)255, "Shutting down Listener");
        this.isRequestedToDie = true;
        try {
            Socket socket = new Socket(HostAddress.LOCAL_HOST_NAME, this.listeningSocket.getLocalPort());
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (bl) {
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean getRunning() {
        return this.isRunning;
    }

    public int getListeningLocalPort() {
        return this.listeningSocket.getLocalPort();
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger.logMessage(Logger.FINER, (short)255, "Listener started. Listening on: " + this.listeningSocket.getInetAddress().getHostAddress() + ':' + this.listeningSocket.getLocalPort());
        while (!this.isRequestedToDie) {
            Socket socket;
            try {
                socket = this.listeningSocket.accept();
                socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
                this.hasConnectedIncomming = true;
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
                break;
            }
            if (this.isRequestedToDie) break;
            try {
                byte by = PhexSecurityManager.getInstance().controlHostIPAccess(socket.getInetAddress().getAddress());
                switch (by) {
                    case 2: 
                    case 3: {
                        throw new IOException("Host access denied: " + socket.getInetAddress().getHostAddress());
                    }
                }
                Logger.logMessage(Logger.FINE, (short)16, "Accepted incoming connection from: " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                IncomingConnectionDispatcher incomingConnectionDispatcher = new IncomingConnectionDispatcher(socket);
                ThreadPool.getInstance().addJob(incomingConnectionDispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
            }
            catch (Exception exception) {
                Logger.logError(exception);
            }
        }
        try {
            this.listeningSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isRunning = false;
        Logger.logMessage(Logger.FINER, (short)255, "Listener stopped.");
        NetworkManager.getInstance().updateLocalAddress(HostAddress.LOCAL_HOST_IP, 6346);
        IncomingListener incomingListener = this;
        synchronized (incomingListener) {
            this.notifyAll();
        }
    }

    public byte[] resolveLocalHostIP() {
        byte[] byArray = null;
        InetAddress inetAddress = this.listeningSocket.getInetAddress();
        byArray = inetAddress.getAddress();
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            byArray = HostAddress.LOCAL_HOST_IP;
        }
        return byArray;
    }
}

