/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.connection.IncomingListener;
import phex.event.AsynchronousDispatcher;
import phex.event.NetworkListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.query.QueryManager;
import phex.utils.IPUtils;
import phex.utils.Logger;

public class NetworkManager
implements Manager {
    private boolean isNetworkJoined;
    private boolean isConnected;
    private HostAddress forcedAddress;
    private HostAddress localAddress;
    private IncomingListener incomingListener;
    private static NetworkManager instance;
    private ArrayList listenerList = new ArrayList(1);

    private NetworkManager() {
        this.isNetworkJoined = ServiceManager.sCfg.mAutoJoin;
        this.isConnected = ServiceManager.sCfg.mAutoConnect;
    }

    public static NetworkManager getInstance() {
        if (instance == null) {
            instance = new NetworkManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.incomingListener = new IncomingListener();
        try {
            this.incomingListener.initialize();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        return true;
    }

    public boolean onPostInitialization() {
        this.incomingListener.startup();
        if (this.isNetworkJoined) {
            HostManager hostManager = HostManager.getInstance();
            hostManager.initializeCaughtHosts();
        }
        return true;
    }

    public void shutdown() {
    }

    public IncomingListener getIncomingListener() {
        return this.incomingListener;
    }

    public synchronized void connectToNetwork() {
        this.isConnected = true;
        if (!this.isNetworkJoined) {
            this.joinNetwork();
        }
        this.fireConnectedToNetwork();
    }

    public synchronized void disconnectNetwork() {
        this.isConnected = false;
        this.fireDisconnectedFromNetwork();
    }

    public synchronized void joinNetwork() {
        HostManager hostManager = HostManager.getInstance();
        hostManager.initializeCaughtHosts();
        this.isNetworkJoined = true;
        if (!this.isConnected && ServiceManager.sCfg.mAutoConnect) {
            this.connectToNetwork();
        }
        MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
        mainFrame.setTitle();
    }

    public synchronized void leaveNetwork() {
        if (this.isNetworkJoined) {
            this.isNetworkJoined = false;
            this.disconnectNetwork();
            MainFrame mainFrame = GUIRegistry.getInstance().getMainFrame();
            mainFrame.setTitle();
            HostManager.getInstance().removeAllNetworkHosts();
            QueryManager.getInstance().getSearchContainer().stopAllSearches();
            HostManager.getInstance().saveHostsContainer();
        }
    }

    public synchronized boolean isNetworkJoined() {
        return this.isNetworkJoined;
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public boolean areNoneUPConnectionsAllowed() {
        return !ServiceManager.sCfg.allowToBecomeLeaf || !ServiceManager.sCfg.forceUPConnections;
    }

    public String getNetworkGreeting() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            return "GNUTELLA CONNECT";
        }
        return "GNUTELLA PCONNECT " + ServiceManager.sCfg.mCurrentNetwork;
    }

    public HostAddress getLocalAddress() {
        if (this.forcedAddress != null) {
            return this.forcedAddress;
        }
        return this.localAddress;
    }

    public void updateLocalAddress(byte[] byArray) {
        if (this.forcedAddress != null) {
            return;
        }
        this.updateLocalAddress(byArray, this.incomingListener.getListeningLocalPort());
    }

    public void updateLocalAddress(byte[] byArray, int n) {
        if (this.forcedAddress != null) {
            return;
        }
        if (this.localAddress == null) {
            this.localAddress = new HostAddress(byArray, n);
        } else {
            this.localAddress.updateAddress(byArray, n);
        }
        this.fireNetworkIPChanged();
    }

    public void setForcedHostIP(byte[] byArray) {
        if (byArray == null) {
            this.forcedAddress = null;
            ServiceManager.sCfg.mMyIP = "";
            byte[] byArray2 = this.incomingListener.resolveLocalHostIP();
            int n = this.incomingListener.getListeningLocalPort();
            this.updateLocalAddress(byArray2, n);
            return;
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Wrong arguement length for IP " + byArray.length);
        }
        ServiceManager.sCfg.mMyIP = IPUtils.ip2string(byArray);
        if (this.forcedAddress == null) {
            this.forcedAddress = new HostAddress(byArray, this.incomingListener.getListeningLocalPort());
        } else {
            this.forcedAddress.updateAddress(byArray, this.incomingListener.getListeningLocalPort());
        }
        this.fireNetworkIPChanged();
    }

    public void addNetworkListener(NetworkListener networkListener) {
        this.listenerList.add(networkListener);
    }

    public void removeNetworkListener(NetworkListener networkListener) {
        this.listenerList.remove(networkListener);
    }

    public void fireConnectedToNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkManager.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    NetworkListener networkListener = (NetworkListener)objectArray[n];
                    networkListener.connectedToNetwork();
                    --n;
                }
            }
        });
    }

    public void fireDisconnectedFromNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkManager.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    NetworkListener networkListener = (NetworkListener)objectArray[n];
                    networkListener.disconnectedFromNetwork();
                    --n;
                }
            }
        });
    }

    public void fireNetworkIPChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = NetworkManager.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    NetworkListener networkListener = (NetworkListener)objectArray[n];
                    networkListener.networkIPChanged(NetworkManager.this.getLocalAddress());
                    --n;
                }
            }
        });
    }
}

