/*
 * Decompiled with CFR 0.152.
 */
package phex.download.swarming;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.ConnectionFailedException;
import phex.download.DownloadEngine;
import phex.download.HostBusyException;
import phex.download.PushHandler;
import phex.download.RangeUnavailableException;
import phex.download.RemotelyQueuedException;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SWDownloadSegment;
import phex.download.swarming.SWDownloadSet;
import phex.host.UnusableHostException;
import phex.http.HTTPMessageException;
import phex.utils.Logger;

public class SWDownloadWorker
implements Runnable {
    private boolean isTemporaryWorker;
    private boolean isRunning;
    private DownloadEngine downloadEngine;

    public void setTemporaryWorker(boolean bl) {
        this.isTemporaryWorker = bl;
    }

    public boolean isTemporaryWorker() {
        return this.isTemporaryWorker;
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void startWorker() {
        this.isRunning = true;
        ThreadPool.getInstance().addJob(this, "SWDownloadWorker-" + Integer.toHexString(this.hashCode()));
        Logger.logMessage(Logger.FINE, (short)2, "Started SWDownloadWorker " + this);
    }

    public void stopWorker() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stopDownload() {
        if (this.downloadEngine != null) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownload(SWDownloadSet sWDownloadSet) {
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        if (sWDownloadCandidate.isPushNeeded()) {
            this.connectDownloadEngineViaPush(sWDownloadSet);
        } else {
            this.connectDownloadEngine(sWDownloadSet);
        }
        if (this.downloadEngine == null) {
            return;
        }
        try {
            this.startDownload(sWDownloadSet);
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)10);
            Logger.logMessage(Logger.FINE, (short)2, iOException);
            Logger.logMessage(Logger.FINE, (short)2, sWDownloadCandidate);
        }
        finally {
            this.stopDownload();
            sWDownloadFile.mergeCompletedSegments(this);
            sWDownloadFile.verifyStatus();
            if (sWDownloadFile.isDownloadCompleted()) {
                sWDownloadFile.moveToDestinationFile();
            }
        }
    }

    private void connectDownloadEngine(SWDownloadSet sWDownloadSet) {
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        sWDownloadCandidate.setStatus((short)11);
        this.downloadEngine = null;
        this.downloadEngine = new DownloadEngine(sWDownloadFile, sWDownloadCandidate);
        try {
            this.downloadEngine.connect(0);
        }
        catch (ConnectionFailedException connectionFailedException) {
            Logger.logMessage(Logger.FINEST, (short)2, connectionFailedException);
            this.connectDownloadEngineViaPush(sWDownloadSet);
            return;
        }
        catch (IOException iOException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            this.connectDownloadEngineViaPush(sWDownloadSet);
            Logger.logMessage(Logger.SEVERE, (short)2, iOException, "Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor());
            return;
        }
    }

    private void connectDownloadEngineViaPush(SWDownloadSet sWDownloadSet) {
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        this.downloadEngine = null;
        if (ServiceManager.sCfg.isBehindFirewall && (!ServiceManager.sCfg.connectedToLAN || sWDownloadCandidate.getHostAddress().isPrivateIP())) {
            Logger.logMessage(Logger.FINER, (short)2, "We are behind a firewall, we are not in LAN or candidate has no private IP, so we can't try a PUSH.");
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            } else {
                sWDownloadCandidate.setStatus((short)15);
            }
            return;
        }
        sWDownloadCandidate.setStatus((short)14);
        Socket socket = PushHandler.requestSocketViaPush(sWDownloadCandidate);
        if (socket == null) {
            if (sWDownloadCandidate.isPushNeeded()) {
                sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            } else {
                sWDownloadCandidate.setStatus((short)15);
            }
            Logger.logMessage(Logger.FINE, (short)2, "Push request fails for candidate: " + sWDownloadCandidate);
            return;
        }
        this.downloadEngine = new DownloadEngine(socket, sWDownloadFile, sWDownloadCandidate);
        try {
            this.downloadEngine.connect(0);
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)15);
            Logger.logMessage(Logger.SEVERE, (short)2, iOException, "Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor());
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            return;
        }
    }

    private void exchangeHTTPHandshake(SWDownloadSet sWDownloadSet) {
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        try {
            sWDownloadCandidate.setStatus((short)11);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.allocateDownloadSegment(this);
            if (sWDownloadSegment == null) {
                Logger.logMessage(Logger.FINE, (short)2, "No segment to allocate found");
                sWDownloadCandidate.setStatus((short)10);
                this.downloadEngine = null;
                return;
            }
            this.downloadEngine.exchangeHTTPHandshake(sWDownloadSegment);
        }
        catch (RemotelyQueuedException remotelyQueuedException) {
            sWDownloadSet.releaseDownloadSegment();
            sWDownloadCandidate.updateXQueueParameters(remotelyQueuedException.getXQueueParameters());
            sWDownloadCandidate.setStatus((short)17);
        }
        catch (RangeUnavailableException rangeUnavailableException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            sWDownloadCandidate.setStatus((short)16);
            Logger.logMessage(Logger.FINEST, (short)2, rangeUnavailableException);
            return;
        }
        catch (HostBusyException hostBusyException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            sWDownloadCandidate.setStatus((short)13);
            Logger.logMessage(Logger.FINEST, (short)2, hostBusyException);
            return;
        }
        catch (UnusableHostException unusableHostException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            Logger.logMessage(Logger.FINE, (short)2, unusableHostException);
            sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            return;
        }
        catch (HTTPMessageException hTTPMessageException) {
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            Logger.logMessage(Logger.WARNING, (short)2, hTTPMessageException);
            sWDownloadFile.removeDownloadCandidate(sWDownloadCandidate);
            return;
        }
        catch (IOException iOException) {
            sWDownloadCandidate.setStatus((short)15);
            Logger.logMessage(Logger.WARNING, (short)2, iOException, "Error at Host: " + sWDownloadCandidate.getHostAddress().getFullHostName() + " Vendor: " + sWDownloadCandidate.getVendor());
            this.downloadEngine.stopDownload();
            this.downloadEngine = null;
            return;
        }
    }

    private void startDownload(SWDownloadSet sWDownloadSet) throws IOException {
        SWDownloadFile sWDownloadFile = sWDownloadSet.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadSet.getDownloadCandidate();
        while (true) {
            this.exchangeHTTPHandshake(sWDownloadSet);
            if (this.downloadEngine == null) {
                return;
            }
            if (sWDownloadCandidate.isRemotelyQueued()) {
                try {
                    Thread.sleep(sWDownloadCandidate.getXQueueParameters().getRequestSleepTime());
                    if (this.downloadEngine == null) {
                        Logger.logMessage(Logger.FINE, (short)2, "Download stopped while waiting for queue.");
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.logMessage(Logger.FINE, (short)2, "Interrupted Worker sleeping for queue.");
                    sWDownloadCandidate.setStatus((short)15);
                    this.downloadEngine.stopDownload();
                    this.downloadEngine = null;
                    return;
                }
            }
            if (sWDownloadCandidate.isRemotelyQueued()) continue;
            sWDownloadFile.setStatus((short)2);
            sWDownloadSet.getDownloadCandidate().setStatus((short)12);
            SWDownloadSegment sWDownloadSegment = sWDownloadSet.getDownloadSegment();
            File file = sWDownloadSegment.getIncompleteFile();
            this.downloadEngine.startDownload(file);
            sWDownloadFile.mergeCompletedSegments(this);
            if (!this.downloadEngine.isAcceptingNextSegment()) break;
        }
        sWDownloadCandidate.setStatus((short)10);
    }

    public String toString() {
        return super.toString() + "[isRunning:" + this.isRunning + ",isTemporaryWorker:" + this.isTemporaryWorker + ",DownloadEngine:" + this.downloadEngine + "]";
    }
}

