/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import phex.gui.actions.FWAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;
import phex.utils.Logger;

public class OpenURLAction
extends FWAction {
    private String url;

    public OpenURLAction(String string, String string2, Icon icon, String string3, Integer n, KeyStroke keyStroke) {
        super(string, icon, string3, n, keyStroke);
        this.url = string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        try {
            BrowserLauncher.openURL(this.url);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.logError(unsatisfiedLinkError);
            bl = true;
        }
        catch (IOException iOException) {
            Logger.logWarning(iOException);
            bl = true;
        }
        if (bl) {
            int n;
            Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
            JComponent jComponent = GUIRegistry.getInstance().getMainFrame().getSelectedTab();
            if (jComponent == null) {
                jComponent = GUIRegistry.getInstance().getMainFrame().getRootPane();
            }
            if ((n = JOptionPane.showOptionDialog(jComponent, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"))) == 0) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.url), null);
            }
        }
    }

    public void refreshActionState() {
    }
}

