/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.chat;

import java.util.HashMap;
import phex.chat.ChatEngine;
import phex.chat.ChatManager;
import phex.event.ChatListener;
import phex.gui.chat.ChatFrame;
import phex.utils.Localizer;

public class ChatFrameManager
implements ChatListener {
    private HashMap openChatsMap = new HashMap(4);

    public ChatFrameManager() {
        ChatManager.getInstance().addChatListener(this);
    }

    public void chatConnectionOpened(ChatEngine chatEngine) {
        ChatFrame chatFrame = new ChatFrame(chatEngine);
        chatFrame.setVisible(true);
        this.openChatsMap.put(chatEngine, chatFrame);
    }

    public void chatMessageReceived(ChatEngine chatEngine, String string) {
        ChatFrame chatFrame = (ChatFrame)this.openChatsMap.get(chatEngine);
        chatFrame.addChatMessage(string);
    }

    public void chatConnectionFailed(ChatEngine chatEngine) {
        ChatFrame chatFrame = (ChatFrame)this.openChatsMap.remove(chatEngine);
        if (chatFrame != null) {
            Object[] objectArray = new Object[]{chatEngine.getHostAddress().getHostName()};
            chatFrame.addInfoMessage(Localizer.getFormatedString("ChatConnectionClosed", objectArray));
        }
    }
}

