/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.io.File;
import java.util.HashMap;
import javax.swing.ToolTipManager;
import javax.xml.bind.JAXBException;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.gui.actions.ConnectNetworkAction;
import phex.gui.actions.DisconnectNetworkAction;
import phex.gui.actions.ExitPhexAction;
import phex.gui.actions.FWAction;
import phex.gui.actions.SwitchNetworkAction;
import phex.gui.chat.ChatFrameManager;
import phex.gui.common.DesktopIndicator;
import phex.gui.common.GUIRegistryConstants;
import phex.gui.common.GUIUpdateNotificationListener;
import phex.gui.common.IconFactory;
import phex.gui.common.LazyEventQueue;
import phex.gui.common.MainFrame;
import phex.gui.common.SplashWindow;
import phex.gui.common.TableUpdateService;
import phex.update.UpdateChecker;
import phex.utils.Logger;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITableList;
import phex.xml.XJBPhex;
import phex.xml.XMLBuilder;

public class GUIRegistry
implements GUIRegistryConstants {
    private static GUIRegistry instance = new GUIRegistry();
    private HashMap globalActionMap;
    private LazyEventQueue lazyEventQueue;
    private TableUpdateService tableUpdateService;
    private DesktopIndicator desktopIndicator;
    private IconFactory iconFactory;
    private ChatFrameManager chatFrameManager;
    private MainFrame mainFrame;
    private boolean showTableHorizontalLines;
    private boolean showTableVerticalLines;

    private GUIRegistry() {
    }

    public static GUIRegistry getInstance() {
        return instance;
    }

    public void initialize() {
        SplashWindow splashWindow = new SplashWindow();
        splashWindow.showSplash();
        XJBGUISettings xJBGUISettings = this.loadGUISettings();
        this.initializeGUISettings(xJBGUISettings);
        this.iconFactory = new IconFactory("phex.gui.resources.Icons");
        if (Environment.getInstance().isWindowsOS()) {
            try {
                this.desktopIndicator = new DesktopIndicator();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.desktopIndicator = null;
            }
        }
        this.initializeGlobalActions();
        this.chatFrameManager = new ChatFrameManager();
        this.mainFrame = new MainFrame(splashWindow, xJBGUISettings);
        Logger.logMessage(Logger.FINE, (short)32, "GUIRegistry initialized.");
        GUIUpdateNotificationListener gUIUpdateNotificationListener = new GUIUpdateNotificationListener();
        UpdateChecker.checkForUpdates(gUIUpdateNotificationListener);
    }

    public DesktopIndicator getDesktopIndicator() {
        return this.desktopIndicator;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public IconFactory getIconFactory() {
        return this.iconFactory;
    }

    public LazyEventQueue getLazyEventQueue() {
        if (this.lazyEventQueue == null) {
            this.lazyEventQueue = new LazyEventQueue();
        }
        return this.lazyEventQueue;
    }

    public TableUpdateService getTableUpdateService() {
        if (this.tableUpdateService == null) {
            this.tableUpdateService = new TableUpdateService();
        }
        return this.tableUpdateService;
    }

    public FWAction getGlobalAction(String string) {
        return (FWAction)this.globalActionMap.get(string);
    }

    public boolean getShowTableHorizontalLines() {
        return this.showTableHorizontalLines;
    }

    public void setShowTableHorizontalLines(boolean bl) {
        this.showTableHorizontalLines = bl;
    }

    public boolean getShowTableVerticalLines() {
        return this.showTableVerticalLines;
    }

    public void setShowTableVerticalLines(boolean bl) {
        this.showTableVerticalLines = bl;
    }

    private XJBGUISettings loadGUISettings() {
        Logger.logMessage(Logger.FINE, (short)255, "Load gui settings file.");
        File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
        try {
            XJBPhex xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.FINE, (short)255, "No gui settings configuration file found.");
                return null;
            }
            return xJBPhex.getGuiSettings();
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            return null;
        }
    }

    public void saveGUISettings() {
        Logger.logMessage(Logger.CONFIG, (short)8, "Saving gui settings...");
        try {
            PhexElement phexElement = ObjectFactory.createPhexElement();
            phexElement.setPhexVersion(VersionUtils.getProgramVersion());
            XJBGUISettings xJBGUISettings = ObjectFactory.createXJBGUISettings();
            phexElement.setGuiSettings(xJBGUISettings);
            XJBGUITableList xJBGUITableList = ObjectFactory.createXJBGUITableList();
            xJBGUITableList.setShowHorizontalLines(this.showTableHorizontalLines);
            xJBGUITableList.setShowVerticalLines(this.showTableVerticalLines);
            xJBGUISettings.setTableList(xJBGUITableList);
            this.mainFrame.saveGUISettings(xJBGUISettings);
            File file = Environment.getInstance().getPhexConfigFile("phexgui.xml");
            XMLBuilder.saveToFile(file, phexElement);
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
        }
    }

    private void initializeGlobalActions() {
        this.globalActionMap = new HashMap(2);
        FWAction fWAction = new ExitPhexAction();
        this.globalActionMap.put("ExitPhexAction", fWAction);
        fWAction = new ConnectNetworkAction();
        this.globalActionMap.put("ConnectNetworkAction", fWAction);
        fWAction = new DisconnectNetworkAction();
        this.globalActionMap.put("DisconnectNetworkAction", fWAction);
        fWAction = new SwitchNetworkAction();
        this.globalActionMap.put("SwitchNetworkAction", fWAction);
    }

    private void initializeGUISettings(XJBGUISettings xJBGUISettings) {
        Environment environment = Environment.getInstance();
        if (environment.isMacOSX() || environment.isWindowsOS()) {
            this.showTableHorizontalLines = false;
            this.showTableVerticalLines = false;
        } else {
            this.showTableHorizontalLines = true;
            this.showTableVerticalLines = true;
        }
        ToolTipManager.sharedInstance().setEnabled(ServiceManager.sCfg.mUIDisplayTooltip);
        if (xJBGUISettings == null) {
            return;
        }
        XJBGUITableList xJBGUITableList = xJBGUISettings.getTableList();
        if (xJBGUISettings.getTableList().isSetShowHorizontalLines()) {
            this.showTableHorizontalLines = xJBGUITableList.isShowHorizontalLines();
        }
        if (xJBGUISettings.getTableList().isSetShowVerticalLines()) {
            this.showTableVerticalLines = xJBGUITableList.isShowVerticalLines();
        }
    }
}

