/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerTextField
extends JTextField {
    private int maxChar;

    public IntegerTextField(int n) {
        this(null, n, n);
    }

    public IntegerTextField(int n, int n2) {
        this(null, n, n2);
    }

    public IntegerTextField(String string, int n, int n2) {
        super(n);
        this.setHorizontalAlignment(4);
        this.maxChar = n2;
        this.setText(string);
    }

    public Integer getIntegerValue() {
        String string = this.getText();
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            int n2 = string.length() + this.getLength() - IntegerTextField.this.maxChar;
            if (n2 > 0) {
                string = string.substring(0, string.length() - n2);
                Toolkit.getDefaultToolkit().beep();
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < cArray.length) {
                if (Character.isDigit(cArray[n4])) {
                    cArray2[n3] = cArray[n4];
                    ++n3;
                }
                ++n4;
            }
            super.insertString(n, new String(cArray2, 0, n3), attributeSet);
        }
    }
}

