/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.share.FileAdministration;
import phex.share.ShareManager;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.FileUtils;
import phex.utils.Localizer;

public class DirectoriesPane
extends OptionsSettingsPane {
    private static final String DIRECTORY_ERROR_KEY = "DirectoryErrorKey";
    private static final String DOWNLOAD_DIRECTORY_KEY = "DownloadDirectory";
    private static final String INCOMPLETE_DIRECTORY_KEY = "IncompleteDirectory";
    private static final String SHARE_DIRECTORIES_KEY = "ShareDirectories";
    private static final String INCOMPLETE_DIR_SHARED = "IncompleteDirShared";
    private static final String NO_DIRECTORY_SHARED = "NoDirectoryShared";
    private static final String CANT_CREATE_DOWNLOAD_DIR = "CantCreateDownloadDir";
    private static final String CANT_CREATE_INCOMPLETE_DIR = "CantCreateIncompleteDir";
    private JTextField incompleteDirectoryTF;
    private JTextField downloadDirectoryTF;
    private JList sharedDirectoryList;
    private JCheckBox shareSubDirectoriesChkBx;
    private JTextField includeFilesTF;
    private JTextField excludeFilesTF;

    public DirectoriesPane() {
        super("Directories");
    }

    protected void prepareComponent() {
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("DownloadDirectorySettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString(INCOMPLETE_DIRECTORY_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.incompleteDirectoryTF = new JTextField(ServiceManager.sCfg.incompleteDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.incompleteDirectoryTF, gridBagConstraints);
        JButton jButton = new JButton(Localizer.getString("SetDirectory"));
        jButton.setMargin(insets);
        jButton.addActionListener(new SetIncompleteDirectoryListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(DOWNLOAD_DIRECTORY_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)jLabel, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.downloadDirectoryTF = new JTextField(ServiceManager.sCfg.mDownloadDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.downloadDirectoryTF, gridBagConstraints);
        jButton = new JButton(Localizer.getString("SetDirectory"));
        jButton.setMargin(insets);
        jButton.addActionListener(new SetDownlodDirectoryListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)jButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("SharingDirectorySettings")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel3, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("SharedDirectories") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets;
        jPanel3.add((Component)jLabel, gridBagConstraints);
        FileAdministration fileAdministration = ShareManager.getInstance().getFileAdministration();
        File[] fileArray = fileAdministration.getSharedDirectories();
        DefaultListModel<File> defaultListModel = new DefaultListModel<File>();
        int n = 0;
        while (n < fileArray.length) {
            defaultListModel.addElement(fileArray[n]);
            ++n;
        }
        this.sharedDirectoryList = new JList(defaultListModel);
        this.sharedDirectoryList.setVisibleRowCount(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)new JScrollPane(this.sharedDirectoryList), gridBagConstraints);
        jButton = new JButton(Localizer.getString("Add"));
        jButton.setMargin(insets);
        jButton.addActionListener(new AddUploadDirectoryListener());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel3.add((Component)jButton, gridBagConstraints);
        jButton = new JButton(Localizer.getString("Remove"));
        jButton.setMargin(insets);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DirectoriesPane.this.sharedDirectoryList.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                DefaultListModel defaultListModel = (DefaultListModel)DirectoriesPane.this.sharedDirectoryList.getModel();
                defaultListModel.removeElementAt(n);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        jPanel3.add((Component)jButton, gridBagConstraints);
        this.shareSubDirectoriesChkBx = new JCheckBox(Localizer.getString("ShareSubDirectories"), ServiceManager.sCfg.mUploadScanRecursively);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)this.shareSubDirectoriesChkBx, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("IncludeFiles") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.includeFilesTF = new JTextField(ServiceManager.sCfg.mUploadFileInclusions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.includeFilesTF, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ExcludeFiles") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.excludeFilesTF = new JTextField(ServiceManager.sCfg.mUploadFileExclusions);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.excludeFilesTF, gridBagConstraints);
    }

    public void checkInput(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        File file = null;
        String string = this.downloadDirectoryTF.getText();
        file = new File(string);
        String string2 = this.incompleteDirectoryTF.getText();
        File file2 = new File(string2);
        boolean bl3 = this.shareSubDirectoriesChkBx.isSelected();
        ListModel listModel = this.sharedDirectoryList.getModel();
        int n = listModel.getSize();
        if (n == 0) {
            hashMap.put(DIRECTORY_ERROR_KEY, NO_DIRECTORY_SHARED);
            this.setInputValid(hashMap, false);
            return;
        }
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            File file3 = (File)listModel.getElementAt(n2);
            boolean bl4 = file2.equals(file3);
            if (bl3 && !bl4) {
                bl4 = FileUtils.isChildOfDir(file2, file3);
            }
            if (bl4) {
                hashMap.put(DIRECTORY_ERROR_KEY, INCOMPLETE_DIR_SHARED);
                this.setInputValid(hashMap, false);
                return;
            }
            fileArray[n2] = file3;
            ++n2;
        }
        if (!(file.exists() && file.isDirectory() || (bl2 = file.mkdirs()))) {
            hashMap.put(DIRECTORY_ERROR_KEY, CANT_CREATE_DOWNLOAD_DIR);
            this.setInputValid(hashMap, false);
            return;
        }
        if (!(file2.exists() && file2.isDirectory() || (bl = file2.mkdirs()))) {
            hashMap.put(DIRECTORY_ERROR_KEY, CANT_CREATE_INCOMPLETE_DIR);
            this.setInputValid(hashMap, false);
            return;
        }
        hashMap.put(DOWNLOAD_DIRECTORY_KEY, file);
        hashMap.put(INCOMPLETE_DIRECTORY_KEY, file2);
        hashMap.put(SHARE_DIRECTORIES_KEY, fileArray);
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        Object v = hashMap.get(DIRECTORY_ERROR_KEY);
        if (v == null) {
            return;
        }
        if (v.equals(INCOMPLETE_DIR_SHARED)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString(INCOMPLETE_DIR_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(NO_DIRECTORY_SHARED)) {
            GUIUtils.showErrorMessage(Localizer.getString(NO_DIRECTORY_SHARED), Localizer.getString("DirectoryError"));
        } else if (v.equals(CANT_CREATE_DOWNLOAD_DIR)) {
            this.downloadDirectoryTF.requestFocus();
            this.downloadDirectoryTF.selectAll();
            Object[] objectArray = new String[]{this.downloadDirectoryTF.getText()};
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_DOWNLOAD_DIR, objectArray), Localizer.getString("DirectoryError"));
        } else if (v.equals(CANT_CREATE_INCOMPLETE_DIR)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            Object[] objectArray = new String[]{this.incompleteDirectoryTF.getText()};
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_INCOMPLETE_DIR, objectArray), Localizer.getString("DirectoryError"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        String string;
        String string2;
        boolean bl;
        File file;
        String string3;
        File file2 = (File)hashMap.get(DOWNLOAD_DIRECTORY_KEY);
        String string4 = file2.getAbsolutePath();
        if (!ServiceManager.sCfg.mDownloadDir.equals(string4)) {
            ServiceManager.sCfg.mDownloadDir = string4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (!ServiceManager.sCfg.incompleteDir.equals(string3 = (file = (File)hashMap.get(INCOMPLETE_DIRECTORY_KEY)).getAbsolutePath())) {
            ServiceManager.sCfg.incompleteDir = string3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        File[] fileArray = (File[])hashMap.get(SHARE_DIRECTORIES_KEY);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < fileArray.length) {
            stringBuffer.append(fileArray[n].getAbsolutePath());
            stringBuffer.append(';');
            ++n;
        }
        if (!ServiceManager.sCfg.mUploadDir.equals(stringBuffer.toString())) {
            ServiceManager.sCfg.mUploadDir = stringBuffer.toString();
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
        if (ServiceManager.sCfg.mUploadScanRecursively != (bl = this.shareSubDirectoriesChkBx.isSelected())) {
            ServiceManager.sCfg.mUploadScanRecursively = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
        if (!ServiceManager.sCfg.mUploadFileInclusions.equals(string2 = this.includeFilesTF.getText())) {
            ServiceManager.sCfg.mUploadFileInclusions = string2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
        if (!ServiceManager.sCfg.mUploadFileExclusions.equals(string = this.excludeFilesTF.getText())) {
            ServiceManager.sCfg.mUploadFileExclusions = string;
            OptionsSettingsPane.triggerConfigSave(hashMap);
            OptionsSettingsPane.triggerSharedFilesRescan(hashMap);
        }
    }

    private class SetIncompleteDirectoryListener
    implements ActionListener {
        private SetIncompleteDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(DirectoriesPane.this.incompleteDirectoryTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("SelectIncompleteDirectory"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.incompleteDirectoryTF.setText(string);
            }
        }
    }

    private class SetDownlodDirectoryListener
    implements ActionListener {
        private SetDownlodDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setSelectedFile(new File(DirectoriesPane.this.downloadDirectoryTF.getText()));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(Localizer.getString("SelectDownloadDirectory"));
            jFileChooser.setApproveButtonText(Localizer.getString("Select"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                String string = jFileChooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.downloadDirectoryTF.setText(string);
            }
        }
    }

    private class AddUploadDirectoryListener
    implements ActionListener {
        private AddUploadDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            DefaultListModel defaultListModel = (DefaultListModel)DirectoriesPane.this.sharedDirectoryList.getModel();
            if (defaultListModel.getSize() > 0) {
                File file = (File)defaultListModel.getElementAt(defaultListModel.getSize() - 1);
                jFileChooser.setSelectedFile(file);
            }
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setFileFilter(new DirectoryOnlyFileFilter());
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setDialogTitle(Localizer.getString("AddUploadDirectories"));
            jFileChooser.setApproveButtonText(Localizer.getString("Add"));
            jFileChooser.setApproveButtonMnemonic(Localizer.getChar("AddDirectoryMnemonic"));
            int n = jFileChooser.showDialog(DirectoriesPane.this, null);
            if (n == 0) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                int n2 = 0;
                while (n2 < fileArray.length) {
                    if (!defaultListModel.contains(fileArray[n2])) {
                        defaultListModel.addElement(fileArray[n2]);
                    }
                    ++n2;
                }
            }
        }
    }
}

