/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import phex.event.CaughtHostsChangeListener;
import phex.host.CaughtHostsContainer;
import phex.host.HostAddress;
import phex.host.HostManager;

public class AutoConnectHostsListModel
extends AbstractListModel {
    private CaughtHostsContainer caughtHostsContainer;

    public AutoConnectHostsListModel() {
        HostManager hostManager = HostManager.getInstance();
        this.caughtHostsContainer = hostManager.getCaughtHostsContainer();
        this.caughtHostsContainer.addCaughtHostsChangeListener(new AutoConnectHostsListener());
    }

    public int getSize() {
        return this.caughtHostsContainer.getAutoConnectHostsCount();
    }

    public Object getElementAt(int n) {
        HostAddress hostAddress = this.caughtHostsContainer.getAutoConnectHostAt(n);
        if (hostAddress == null) {
            this.fireIntervalRemoved(this, n, n);
            return "";
        }
        return hostAddress;
    }

    private class AutoConnectHostsListener
    implements CaughtHostsChangeListener {
        private AutoConnectHostsListener() {
        }

        public void caughtHostsChanged() {
        }

        public void autoConnectHostAdded(int n) {
            AutoConnectHostsListModel.this.fireIntervalAdded(this, n, n);
        }

        public void autoConnectHostRemoved(int n) {
            AutoConnectHostsListModel.this.fireIntervalRemoved(this, n, n);
        }
    }
}

