/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import phex.gui.models.FWTableModel;

public class FWSortedTableModel
extends AbstractTableModel {
    protected FWTableModel tableModel;
    private int sortedColumn;
    private Comparator columnComparator;
    private boolean isAscending;
    protected int[] sortedIndexMapping;

    public FWSortedTableModel(FWTableModel fWTableModel) {
        this.tableModel = fWTableModel;
        this.tableModel.addTableModelListener(new ModelChangeHandler());
        this.sortedColumn = -1;
        this.sortedIndexMapping = new int[0];
        this.reallocateIndexes();
    }

    public Object getValueAt(int n, int n2) {
        this.reallocateIndexes();
        if (n >= this.sortedIndexMapping.length) {
            return "";
        }
        return this.tableModel.getValueAt(this.sortedIndexMapping[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.tableModel.setValueAt(object, this.sortedIndexMapping[n], n2);
    }

    public int convertRowIndexToModel(int n) {
        if (n < 0) {
            return n;
        }
        return this.sortedIndexMapping[n];
    }

    public synchronized void sortByColumn(int n, boolean bl) {
        this.isAscending = bl;
        if (n != this.sortedColumn) {
            this.sortedColumn = n;
            this.columnComparator = this.tableModel.getColumnComparator(this.sortedColumn);
            if (this.columnComparator == null) {
                this.columnComparator = new NaturalComparator();
            }
        }
        this.sort();
        this.fireTableChanged(new TableModelEvent(this));
    }

    public synchronized int getSortByColumn() {
        return this.sortedColumn;
    }

    public synchronized boolean isSortedAscending() {
        return this.isAscending;
    }

    private synchronized void reallocateIndexes() {
        int n;
        int n2 = this.tableModel.getRowCount();
        if (n2 == (n = this.sortedIndexMapping.length)) {
            return;
        }
        int[] nArray = new int[n2];
        if (n2 > n) {
            System.arraycopy(this.sortedIndexMapping, 0, nArray, 0, n);
            int n3 = n;
            while (n3 < n2) {
                nArray[n3] = n3;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = n4;
                ++n4;
            }
        }
        this.sortedIndexMapping = nArray;
        n = n2;
        if (this.sortedColumn == -1) {
            return;
        }
        this.mergeSort((int[])this.sortedIndexMapping.clone(), this.sortedIndexMapping, 0, this.sortedIndexMapping.length);
        this.fireTableChanged(new TableModelEvent(this));
    }

    private synchronized void sort() {
        this.reallocateIndexes();
        this.mergeSort((int[])this.sortedIndexMapping.clone(), this.sortedIndexMapping, 0, this.sortedIndexMapping.length);
    }

    private int compare(int n, int n2) {
        Object object = this.tableModel.getComparableValueAt(n, this.sortedColumn);
        Object object2 = this.tableModel.getComparableValueAt(n2, this.sortedColumn);
        int n3 = object == null && object2 == null ? 0 : (object == null ? -1 : (object2 == null ? 1 : this.columnComparator.compare(object, object2)));
        if (n3 != 0) {
            return this.isAscending ? n3 : -n3;
        }
        return 0;
    }

    private synchronized void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private synchronized void mergeSort(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            int n4 = n;
            while (n4 < n2) {
                int n5 = n4;
                while (n5 > n && this.compare(nArray2[n5 - 1], nArray2[n5]) > 0) {
                    this.swap(nArray2, n5, n5 - 1);
                    --n5;
                }
                ++n4;
            }
            return;
        }
        int n6 = (n + n2) / 2;
        this.mergeSort(nArray2, nArray, n, n6);
        this.mergeSort(nArray2, nArray, n6, n2);
        if (this.compare(nArray[n6 - 1], nArray[n6]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n3);
            return;
        }
        int n7 = n;
        int n8 = n;
        int n9 = n6;
        while (n7 < n2) {
            nArray2[n7] = n9 >= n2 || n8 < n6 && this.compare(nArray[n8], nArray[n9]) <= 0 ? nArray[n8++] : nArray[n9++];
            ++n7;
        }
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.tableModel.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.tableModel.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.tableModel.isCellEditable(n, n2);
    }

    class ModelChangeHandler
    implements TableModelListener {
        ModelChangeHandler() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            FWSortedTableModel.this.fireTableChanged(tableModelEvent);
        }
    }

    class NaturalComparator
    implements Comparator {
        NaturalComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo((Comparable)object2);
        }
    }
}

