/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.download.RemoteFile;
import phex.gui.models.FWTableModel;
import phex.gui.tabs.SearchTab;
import phex.query.Search;
import phex.utils.Localizer;

public class SearchTableModel
extends FWTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int FILE_COLUMN_ID = 1002;
    public static final int EXTENSION_COLUMN_ID = 1003;
    public static final int SIZE_COLUMN_ID = 1004;
    public static final int SCORE_COLUMN_ID = 1005;
    public static final int HOST_RATING_COLUMN_ID = 1006;
    public static final int HOST_SPEED_COLUMN_ID = 1007;
    public static final int HOST_VENDOR_COLUMN_ID = 1008;
    public static final int META_DATA_COLUMN_ID = 1009;
    public static final int SHA1_COLUMN_ID = 1010;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int FILE_MODEL_INDEX = 1;
    public static final int EXTENSION_MODEL_INDEX = 2;
    public static final int SIZE_MODEL_INDEX = 3;
    public static final int SCORE_MODEL_INDEX = 4;
    public static final int HOST_RATING_MODEL_INDEX = 5;
    public static final int HOST_SPEED_MODEL_INDEX = 6;
    public static final int HOST_VENDOR_MODEL_INDEX = 7;
    public static final int META_DATA_MODEL_INDEX = 8;
    public static final int SHA1_MODEL_INDEX = 9;
    private static String[] tableColumns = new String[]{Localizer.getString("SharingHost"), Localizer.getString("File"), Localizer.getString("Extension"), Localizer.getString("Size"), Localizer.getString("Score"), Localizer.getString("Rating"), Localizer.getString("HostSpeed"), Localizer.getString("Vendor"), Localizer.getString("Information"), Localizer.getString("SHA1")};
    private static Class[] tableClasses = new Class[]{class$phex$gui$renderer$IPCellRenderer == null ? (class$phex$gui$renderer$IPCellRenderer = SearchTableModel.class$("phex.gui.renderer.IPCellRenderer")) : class$phex$gui$renderer$IPCellRenderer, class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String, class$phex$gui$renderer$FileSizeCellRenderer == null ? (class$phex$gui$renderer$FileSizeCellRenderer = SearchTableModel.class$("phex.gui.renderer.FileSizeCellRenderer")) : class$phex$gui$renderer$FileSizeCellRenderer, class$java$lang$Short == null ? (class$java$lang$Short = SearchTableModel.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Short == null ? (class$java$lang$Short = SearchTableModel.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = SearchTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = SearchTableModel.class$("java.lang.String")) : class$java$lang$String};
    private SearchTab searchTab;
    static /* synthetic */ Class class$phex$gui$renderer$IPCellRenderer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$phex$gui$renderer$FileSizeCellRenderer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;

    public SearchTableModel(SearchTab searchTab) {
        super(tableColumns, tableClasses);
        this.searchTab = searchTab;
    }

    public int getRowCount() {
        Search search = this.searchTab.getSelectedSearchResult();
        if (search == null) {
            return 0;
        }
        return search.getQueryHitCount();
    }

    public Object getValueAt(int n, int n2) {
        Search search = this.searchTab.getSelectedSearchResult();
        if (search == null) {
            return "";
        }
        if (n >= search.getQueryHitCount()) {
            return "";
        }
        RemoteFile remoteFile = search.getQueryHit(n);
        switch (n2) {
            case 0: {
                return remoteFile.getHostAddress().getFullHostName();
            }
            case 1: {
                return remoteFile.getShortname();
            }
            case 2: {
                return remoteFile.getFileExt() + (remoteFile.isInDownloadQueue() ? " *" : "");
            }
            case 3: {
                return remoteFile.getFileSizeObject();
            }
            case 4: {
                return remoteFile.getScore();
            }
            case 5: {
                return remoteFile.getQueryHitHost().getHostRatingObject();
            }
            case 6: {
                return remoteFile.getSpeedObject();
            }
            case 7: {
                return remoteFile.getQueryHitHost().getVendor();
            }
            case 8: {
                return remoteFile.getMetaData();
            }
            case 9: {
                return remoteFile.getSHA1();
            }
        }
        return "";
    }

    public Object getComparableValueAt(int n, int n2) {
        switch (n2) {
            case 3: {
                Search search = this.searchTab.getSelectedSearchResult();
                if (search == null) {
                    return "";
                }
                if (n >= search.getQueryHitCount()) {
                    return "";
                }
                RemoteFile remoteFile = search.getQueryHit(n);
                return remoteFile.getFileSizeObject();
            }
        }
        return this.getValueAt(n, n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1004: {
                return 3;
            }
            case 1005: {
                return 4;
            }
            case 1006: {
                return 5;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
            case 1010: {
                return 9;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1002;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010};
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

