/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Keymap;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.common.ExpiryDate;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.connection.NetworkManager;
import phex.event.NetworkListener;
import phex.gui.actions.FWAction;
import phex.gui.common.FWTable;
import phex.gui.common.FWTableColumn;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.models.AutoConnectHostsListModel;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.NetworkTableModel;
import phex.gui.tabs.FWTab;
import phex.host.GWebCacheContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.HostManager;
import phex.host.MalformedHostAddressException;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class NetworkTab
extends FWTab {
    private static final String NETWORK_TABLE_IDENTIFIER = "NetworkTable";
    private static final Host[] EMPTY_HOST_ARRAY = new Host[0];
    private MainFrame mainFrame;
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private GWebCacheContainer gWebCacheCont;
    private ServiceManager serviceMgr;
    private MsgManager msgManager;
    private FWTable networkTable;
    private JScrollPane networkTableScrollPane;
    private FWTableColumnModel networkColumnModel;
    private NetworkTableModel networkModel;
    private JPopupMenu networkPopup;
    private JLabel myIPLabel;
    private DefaultComboBoxModel connectToComboModel;
    private JComboBox connectToComboBox;
    private JTextField newAutoConnectHostTF;
    private JList autoConnectList;
    private JButton addAutoConnectHostBtn;
    private JButton removeAutoConnectHostBtn;
    private JButton connectAutoConnectHostBtn;
    private JLabel catcherStatLabel;
    private JLabel gWebCacheStatLabel;
    private static final String DISCONNECT_HOST_ACTION_KEY = "DisconnectHostAction";
    private static final String IGNORE_HOST_ACTION_KEY = "IgnoreHostAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";

    public NetworkTab(MainFrame mainFrame) {
        super(1000, Localizer.getString("GnutellaNet"), GUIRegistry.getInstance().getIconFactory().getIcon("Network"), Localizer.getString("TTTGnutellaNet"), Localizer.getChar("GnutellaNetMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("GnutellaNetAccelerator")), 0);
        this.mainFrame = mainFrame;
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.gWebCacheCont = this.hostMgr.getGWebCacheContainer();
        this.msgManager = MsgManager.getInstance();
        this.serviceMgr = ServiceManager.getInstance();
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.networkModel = new NetworkTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, NETWORK_TABLE_IDENTIFIER);
        this.buildNetworkTableColumnModel(xJBGUITable);
        this.networkTable = new FWTable((TableModel)new FWSortedTableModel(this.networkModel), this.networkColumnModel);
        this.networkTable.activateAllHeaderActions();
        this.networkTable.setAutoResizeMode(0);
        this.networkTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.networkTable.addMouseListener(mouseHandler);
        this.networkTableScrollPane = FWTable.createFWTableScrollPane(this.networkTable);
        this.networkTableScrollPane.addMouseListener(mouseHandler);
        jPanel.add("Center", this.networkTableScrollPane);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.myIPLabel = new JLabel(Localizer.getFormatedString("MyAddress", new String[]{""}));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel2.add((Component)this.myIPLabel, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("ConnectTo") + Localizer.getChar("ColonSign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ConnectToHostHandler connectToHostHandler = new ConnectToHostHandler();
        this.connectToComboModel = new DefaultComboBoxModel<Object>(ServiceManager.sCfg.connectToHistory.toArray());
        this.connectToComboBox = new JComboBox(this.connectToComboModel);
        this.connectToComboBox.setEditable(true);
        JTextField jTextField = (JTextField)this.connectToComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("ConnectToEditor", jTextField.getKeymap());
        jTextField.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), connectToHostHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.connectToComboBox);
        this.connectToComboBox.setSelectedItem("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        jPanel2.add((Component)this.connectToComboBox, gridBagConstraints);
        JButton jButton = new JButton(Localizer.getString("Connect"));
        jButton.setMargin(insets);
        jButton.addActionListener(connectToHostHandler);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel2.add((Component)jButton, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("Connections")));
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("AutoConnectHosts")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        this.newAutoConnectHostTF = new JTextField(25);
        this.newAutoConnectHostTF.setMinimumSize(this.newAutoConnectHostTF.getPreferredSize());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel6.add((Component)this.newAutoConnectHostTF, gridBagConstraints);
        this.addAutoConnectHostBtn = new JButton(Localizer.getString("Add"));
        this.addAutoConnectHostBtn.setMargin(insets);
        this.addAutoConnectHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTab.this.performAddAutoConnectHostAction();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)this.addAutoConnectHostBtn, gridBagConstraints);
        this.connectAutoConnectHostBtn = new JButton(Localizer.getString("Connect"));
        this.connectAutoConnectHostBtn.setMargin(insets);
        this.connectAutoConnectHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTab.this.performConnectAutoConnectHostAction();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel6.add((Component)this.connectAutoConnectHostBtn, gridBagConstraints);
        this.removeAutoConnectHostBtn = new JButton(Localizer.getString("Remove"));
        this.removeAutoConnectHostBtn.setMargin(insets);
        this.removeAutoConnectHostBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkTab.this.performRemoveAutoConnectHostAction();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel6.add((Component)this.removeAutoConnectHostBtn, gridBagConstraints);
        this.autoConnectList = new JList(new AutoConnectHostsListModel());
        this.autoConnectList.setVisibleRowCount(5);
        this.autoConnectList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    NetworkTab.this.autoConnectListValueChanged();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        jPanel6.add((Component)new JScrollPane(this.autoConnectList), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("ConnectionInfo")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        jPanel4.add((Component)jPanel7, gridBagConstraints);
        this.catcherStatLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 2, 0);
        jPanel7.add((Component)this.catcherStatLabel, gridBagConstraints);
        this.gWebCacheStatLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 2, 0);
        jPanel7.add((Component)this.gWebCacheStatLabel, gridBagConstraints);
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        jPanel7.add((Component)jPanel8, gridBagConstraints);
        final JButton jButton2 = new JButton(Localizer.getString("QueryGWebCache"));
        jButton2.setToolTipText(Localizer.getString("TTTQueryGWebCache"));
        jButton2.setMargin(insets);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jButton2.setEnabled(false);
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        NetworkTab.access$800(5.access$700(this.this$1)).queryMoreHosts();
                        NetworkTab.access$800(5.access$700(this.this$1)).queryMoreGWebCaches();
                        5.access$900(this.this$1).setEnabled(true);
                    }
                };
                ThreadPool.getInstance().addJob(runnable, "UserGWebCacheQuery-" + Integer.toHexString(runnable.hashCode()));
            }

            static /* synthetic */ NetworkTab access$700(5 var0) {
                return var0.NetworkTab.this;
            }

            static /* synthetic */ JButton access$900(5 var0) {
                return var0.jButton2;
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel8.add((Component)jButton2, gridBagConstraints);
        this.add("Center", jPanel3);
        this.add("South", jPanel4);
        CellRenderer cellRenderer = new CellRenderer();
        Iterator iterator = this.networkColumnModel.createAllColumnsIterator();
        while (iterator.hasNext()) {
            serializable = (FWTableColumn)iterator.next();
            serializable.setCellRenderer(cellRenderer);
        }
        this.networkPopup = new JPopupMenu();
        serializable = new DisconnectHostAction();
        this.addTabAction(DISCONNECT_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.add((Action)((Object)serializable));
        this.networkPopup.addSeparator();
        serializable = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.add((Action)((Object)serializable));
        serializable = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.add((Action)((Object)serializable));
        serializable = new BanHostAction();
        this.addTabAction(IGNORE_HOST_ACTION_KEY, (FWAction)serializable);
        this.networkPopup.add((Action)((Object)serializable));
        this.networkPopup.addSeparator();
        JMenu jMenu = new JMenu(Localizer.getString("Network"));
        jMenu.add(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
        jMenu.add(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
        this.networkPopup.add(jMenu);
        NetworkManager networkManager = NetworkManager.getInstance();
        IPChangedListener iPChangedListener = new IPChangedListener();
        iPChangedListener.networkIPChanged(networkManager.getLocalAddress());
        networkManager.addNetworkListener(iPChangedListener);
    }

    public void updateUI() {
        super.updateUI();
        if (this.connectToComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.connectToComboBox);
            ListCellRenderer listCellRenderer = this.connectToComboBox.getRenderer();
            if (listCellRenderer != null) {
                FontMetrics fontMetrics = this.connectToComboBox.getFontMetrics(this.connectToComboBox.getFont());
                int n = fontMetrics.getMaxAdvance() * 15;
                Dimension dimension = this.connectToComboBox.getMaximumSize();
                dimension.width = Math.min(n, dimension.width);
                dimension = this.connectToComboBox.getPreferredSize();
                dimension.width = Math.min(n, dimension.width);
            }
        }
        if (this.networkTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.networkTableScrollPane);
        }
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.networkColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(NETWORK_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    public void tabSelectedNotify() {
        this.refresh();
    }

    public void refresh() {
        Object[] objectArray = new Object[]{new Integer(this.hostMgr.getCaughtHostCount())};
        this.catcherStatLabel.setText(Localizer.getFormatedString("HostCacheStat", objectArray));
        objectArray = new Object[]{new Integer(this.gWebCacheCont.getGWebCacheCount())};
        this.gWebCacheStatLabel.setText(Localizer.getFormatedString("GWebCacheStat", objectArray));
        GUIUtils.fireTableChanged(this.networkTable, this.networkModel);
    }

    private void buildNetworkTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = NetworkTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.networkColumnModel = new FWTableColumnModel(this.networkModel, nArray, xJBGUITableColumnList);
    }

    private void performAddAutoConnectHostAction() {
        block2: {
            String string = this.newAutoConnectHostTF.getText();
            if ((string = string.trim()).length() <= 0) break block2;
            try {
                this.hostMgr.getCaughtHostsContainer().addAutoConnectHost(new HostAddress(string));
                this.newAutoConnectHostTF.setText("");
            }
            catch (MalformedHostAddressException malformedHostAddressException) {}
        }
    }

    private void performRemoveAutoConnectHostAction() {
        block2: {
            String string = this.newAutoConnectHostTF.getText();
            if ((string = string.trim()).length() <= 0) break block2;
            try {
                this.hostMgr.getCaughtHostsContainer().removeAutoConnectHost(new HostAddress(string));
                this.newAutoConnectHostTF.setText("");
            }
            catch (MalformedHostAddressException malformedHostAddressException) {}
        }
    }

    private void performConnectAutoConnectHostAction() {
        block2: {
            String string = this.newAutoConnectHostTF.getText();
            if ((string = string.trim()).length() <= 0) break block2;
            try {
                this.hostMgr.getNetworkHostsContainer().createOutgoingConnectionToHost(new HostAddress(string));
                this.newAutoConnectHostTF.setText("");
            }
            catch (MalformedHostAddressException malformedHostAddressException) {}
        }
    }

    private void autoConnectListValueChanged() {
        HostAddress hostAddress = (HostAddress)this.autoConnectList.getSelectedValue();
        if (hostAddress != null) {
            this.newAutoConnectHostTF.setText(hostAddress.getFullHostName());
        }
    }

    private Host[] getSelectedHosts() {
        int[] nArray = this.networkTable.getSelectedRows();
        if (nArray.length == 0) {
            return EMPTY_HOST_ARRAY;
        }
        int[] nArray2 = this.networkTable.convertRowIndicesToModel(nArray);
        Host[] hostArray = this.hostsContainer.getNetworkHostsAt(nArray2);
        return hostArray;
    }

    private Host getSelectedHost() {
        int n = this.networkTable.getSelectedRow();
        int n2 = this.networkTable.convertRowIndexToModel(n);
        Host host = this.hostsContainer.getNetworkHostAt(n2);
        return host;
    }

    static /* synthetic */ GWebCacheContainer access$800(NetworkTab networkTab) {
        return networkTab.gWebCacheCont;
    }

    private class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            block14: {
                super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                this.setForeground(Color.black);
                if (jTable != NetworkTab.this.networkTable) {
                    return this;
                }
                if (n >= NetworkTab.this.hostsContainer.getNetworkHostCount()) return this;
                int n3 = ((FWTable)jTable).convertRowIndexToModel(n);
                Host host = NetworkTab.this.hostsContainer.getNetworkHostAt(n3);
                if (host == null) {
                    return this;
                }
                switch (host.getStatus()) {
                    case 0: {
                        return this;
                    }
                    case 1: 
                    case 5: {
                        this.setForeground(Color.gray);
                        return this;
                    }
                    case 2: 
                    case 3: {
                        this.setForeground(Color.red);
                        return this;
                    }
                    case 4: {
                        this.setForeground(Color.blue);
                        switch (n2) {
                            case 2: {
                                if (!host.dropPacketsInRed()) return this;
                                this.setForeground(Color.red);
                                break block14;
                            }
                            case 3: {
                                if (!host.isSendQueueInRed()) return this;
                                this.setForeground(Color.red);
                            }
                        }
                    }
                }
            }
            return this;
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == NetworkTab.this.networkTable || component == NetworkTab.this.networkTableScrollPane) {
                NetworkTab.this.networkPopup.show(component, n, n2);
            }
        }
    }

    private class ConnectToHostHandler
    extends AbstractAction
    implements ActionListener {
        private ConnectToHostHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)NetworkTab.this.connectToComboBox.getEditor().getItem();
            NetworkTab.this.connectToComboModel.setSelectedItem(string);
            string = string.trim();
            if (string.length() == 0) {
                return;
            }
            int n = NetworkTab.this.connectToComboModel.getIndexOf(string);
            if (n < 0) {
                NetworkTab.this.connectToComboModel.insertElementAt(string, 0);
                if (NetworkTab.this.connectToComboModel.getSize() > ServiceManager.sCfg.maxConnectToHistorySize) {
                    NetworkTab.this.connectToComboModel.removeElementAt(NetworkTab.this.connectToComboModel.getSize() - 1);
                }
                this.saveConnectToHostList();
            } else if (n > 0) {
                NetworkTab.this.connectToComboModel.removeElementAt(n);
                NetworkTab.this.connectToComboModel.insertElementAt(string, 0);
                this.saveConnectToHostList();
            }
            this.connectToHost(string);
            NetworkTab.this.connectToComboBox.setSelectedItem("");
        }

        private void connectToHost(String string) {
            if (string.length() == 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            String string2 = stringTokenizer.nextToken();
            try {
                NetworkTab.this.hostMgr.getNetworkHostsContainer().createOutgoingConnectionToHost(new HostAddress(string2));
            }
            catch (MalformedHostAddressException malformedHostAddressException) {
                // empty catch block
            }
            GUIUtils.fireTableChanged(NetworkTab.this.networkTable, NetworkTab.this.networkModel);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf(58);
                String string4 = string3.substring(0, n);
                String string5 = string3.substring(n + 1, string3.length());
                int n2 = Integer.parseInt(string5);
                HostAddress hostAddress = new HostAddress(string4, n2);
                NetworkTab.this.hostMgr.getCaughtHostsContainer().addCaughtHost(hostAddress, 2);
            }
        }

        private void saveConnectToHostList() {
            int n = NetworkTab.this.connectToComboModel.getSize();
            ArrayList arrayList = new ArrayList(n);
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(NetworkTab.this.connectToComboModel.getElementAt(n2));
                ++n2;
            }
            ServiceManager.sCfg.connectToHistory.clear();
            ServiceManager.sCfg.connectToHistory.addAll(arrayList);
            ServiceManager.sCfg.save();
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                NetworkTab.this.refreshTabActions();
            }
        }
    }

    private class IPChangedListener
    implements NetworkListener {
        private IPChangedListener() {
        }

        public void networkIPChanged(HostAddress hostAddress) {
            Object[] objectArray = new String[]{hostAddress.getHostName() + ":" + hostAddress.getPort()};
            NetworkTab.this.myIPLabel.setText(Localizer.getFormatedString("MyAddress", objectArray));
        }

        public void connectedToNetwork() {
        }

        public void disconnectedFromNetwork() {
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
            searchContainer.createBrowseHostSearch(host.getHostAddress(), null);
            NetworkTab.this.mainFrame.setSelectedTab(1001);
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            ChatManager.getInstance().openChat(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class BanHostAction
    extends FWAction {
        public BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host[] hostArray = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hostArray);
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            int n = 0;
            while (n < hostArray.length) {
                try {
                    phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, hostArray[n].getHostAddress().getHostIP(), null, false, ExpiryDate.SESSION_EXPIRY_DATE, true);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ++n;
            }
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private class DisconnectHostAction
    extends FWAction {
        public DisconnectHostAction() {
            super(Localizer.getString("DisconnectHost"), GUIRegistry.getInstance().getIconFactory().getIcon("DisconnectHost"), Localizer.getString("TTTDisconnectHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Host[] hostArray = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hostArray);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

