/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.gui.common.FWTable;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.StatisticsTableModel;
import phex.gui.tabs.FWTab;
import phex.utils.Localizer;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class StatisticsTab
extends FWTab {
    private static final String STATISTICS_TABLE_IDENTIFIER = "StatisticsTable";
    private StatisticsTableModel statisticsModel;
    private FWTableColumnModel statisticsColumnModel;
    private FWTable statisticsTable;
    private JScrollPane statisticsTableScrollPane;

    public StatisticsTab() {
        super(1006, Localizer.getString("Statistics"), GUIRegistry.getInstance().getIconFactory().getIcon("Statistics"), Localizer.getString("TTTStatistics"), Localizer.getChar("StatisticsMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("StatisticsAccelerator")), 6);
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("Statistics")));
        this.statisticsModel = new StatisticsTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, STATISTICS_TABLE_IDENTIFIER);
        this.buildStatisticsTableColumnModel(xJBGUITable);
        this.statisticsTable = new FWTable((TableModel)new FWSortedTableModel(this.statisticsModel), this.statisticsColumnModel);
        this.statisticsTable.activateAllHeaderActions();
        this.statisticsTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.statisticsTable);
        this.statisticsTableScrollPane = FWTable.createFWTableScrollPane(this.statisticsTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.statisticsTableScrollPane, gridBagConstraints);
        this.add("Center", jPanel);
    }

    public void updateUI() {
        super.updateUI();
        if (this.statisticsTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.statisticsTableScrollPane);
        }
    }

    private void buildStatisticsTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = StatisticsTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.statisticsColumnModel = new FWTableColumnModel(this.statisticsModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.statisticsColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(STATISTICS_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }
}

