/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.io.IOException;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.connection.ConnectionEngine;
import phex.connection.ConnectionObserver;
import phex.connection.NetworkManager;
import phex.event.CaughtHostsChangeListener;
import phex.event.NetworkHostsChangeListener;
import phex.host.CaughtHostsContainer;
import phex.host.GWebCacheContainer;
import phex.host.Host;
import phex.host.HostAddress;
import phex.host.NetworkHostsContainer;
import phex.host.UltrapeerCapabilityChecker;
import phex.utils.Logger;

public final class HostManager
implements Manager {
    private static HostManager instance;
    private NetworkManager networkMgr;
    private CaughtHostsContainer caughtHostsContainer = new CaughtHostsContainer();
    private GWebCacheContainer gWebCacheContainer = new GWebCacheContainer();
    private NetworkHostsContainer networkHostsContainer;
    private UltrapeerCapabilityChecker upChecker;

    private HostManager() {
    }

    public static HostManager getInstance() {
        if (instance == null) {
            instance = new HostManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.networkMgr = NetworkManager.getInstance();
        this.networkHostsContainer = new NetworkHostsContainer();
        ConnectionObserver connectionObserver = new ConnectionObserver();
        connectionObserver.start();
        NetworkManager networkManager = NetworkManager.getInstance();
        networkManager.addNetworkListener(this.networkHostsContainer);
        this.upChecker = new UltrapeerCapabilityChecker();
        return true;
    }

    public void shutdown() {
        this.saveHostsContainer();
    }

    public GWebCacheContainer getGWebCacheContainer() {
        return this.gWebCacheContainer;
    }

    public void acceptIncomingConnection(Host host, String string) throws IOException {
        ConnectionEngine connectionEngine = new ConnectionEngine(host);
        connectionEngine.initializeIncomingConnection(string);
        connectionEngine.processIncomingData();
    }

    public CaughtHostsContainer getCaughtHostsContainer() {
        return this.caughtHostsContainer;
    }

    public void initializeCaughtHosts() {
        this.caughtHostsContainer.initializeCaughtHostsContainer();
    }

    public int getCaughtHostCount() {
        return this.caughtHostsContainer.getCaughtHostsCount();
    }

    public void resetCaughtHosts() {
        this.caughtHostsContainer.resetCaughtHosts();
    }

    public void saveHostsContainer() {
        try {
            this.caughtHostsContainer.saveHostsContainer();
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }

    public void addCaughtHostsChangeListener(CaughtHostsChangeListener caughtHostsChangeListener) {
        this.caughtHostsContainer.addCaughtHostsChangeListener(caughtHostsChangeListener);
    }

    public NetworkHostsContainer getNetworkHostsContainer() {
        return this.networkHostsContainer;
    }

    public boolean isShieldedLeafNode() {
        return this.networkHostsContainer.isShieldedLeafNode();
    }

    public boolean isAbleToBecomeUltrapeer() {
        return this.isUltrapeer() || ServiceManager.sCfg.allowToBecomeUP && this.upChecker.isUltrapeerCapable();
    }

    public boolean isUltrapeer() {
        return ServiceManager.sCfg.allowToBecomeUP && ServiceManager.sCfg.forceToBeUltrapeer || this.networkHostsContainer.hasLeafConnections();
    }

    public boolean areIncommingSlotsAdvertised() {
        if (this.networkHostsContainer.isShieldedLeafNode()) {
            return false;
        }
        return this.networkHostsContainer.hasPeerSlotsAvailable() || this.networkHostsContainer.hasUltrapeerSlotsAvailable() || this.networkHostsContainer.hasLeafSlotsAvailable();
    }

    public boolean isAbleToBecomeLeafNode() {
        if (!ServiceManager.sCfg.allowToBecomeLeaf) {
            return false;
        }
        return !this.isAbleToBecomeUltrapeer() || !this.networkHostsContainer.hasLeafConnections() && !this.networkHostsContainer.hasUltrapeerConnections();
    }

    public void addConnectedHost(Host host) {
        this.networkHostsContainer.addConnectedHost(host);
    }

    public void disconnectHost(Host host) {
        this.networkHostsContainer.disconnectHost(host);
    }

    public void addIncomingHost(Host host) {
        this.networkHostsContainer.addIncomingHost(host);
    }

    public void periodicallyCheckHosts() {
        this.networkHostsContainer.periodicallyCheckHosts();
    }

    public void removeAllNetworkHosts() {
        this.networkHostsContainer.removeAllNetworkHosts();
    }

    public void removeNetworkHosts(Host[] hostArray) {
        this.networkHostsContainer.removeNetworkHosts(hostArray);
    }

    public void removeNetworkHost(Host host) {
        this.networkHostsContainer.removeNetworkHost(host);
    }

    public void addNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.addNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void removeNetworkHostsChangeListener(NetworkHostsChangeListener networkHostsChangeListener) {
        this.networkHostsContainer.removeNetworkHostsChangeListener(networkHostsChangeListener);
    }

    public void fireNetworkHostChanged(Host host) {
        this.networkHostsContainer.fireNetworkHostChanged(host);
    }

    public void doAutoConnectCheck() {
        int n;
        int n2;
        if (!this.networkMgr.isNetworkJoined() || !this.networkMgr.isConnected()) {
            return;
        }
        if (this.isAbleToBecomeUltrapeer()) {
            n2 = this.networkHostsContainer.getUltrapeerConnectionCount();
            n = ServiceManager.sCfg.up2upConnections;
        } else if (this.isShieldedLeafNode() || ServiceManager.sCfg.allowToBecomeLeaf) {
            n2 = this.networkHostsContainer.getUltrapeerConnectionCount();
            n = ServiceManager.sCfg.leaf2upConnections;
        } else {
            n2 = this.networkHostsContainer.getTotalConnectionCount();
            n = ServiceManager.sCfg.peerConnections;
        }
        int n3 = (n - n2) * 2;
        int n4 = this.networkHostsContainer.getNetworkHostCount() - n2 - this.networkHostsContainer.getNetworkHostCount(1);
        if ((n3 -= n4) > 0) {
            int n5 = n3;
            while (n5 > 0) {
                this.autoConnectToNextCaughtHost();
                --n5;
            }
        }
    }

    private void autoConnectToNextCaughtHost() {
        HostAddress hostAddress = this.caughtHostsContainer.getNextCaughtHost();
        if (hostAddress != null) {
            this.networkHostsContainer.createOutgoingConnectionToHost(hostAddress);
        }
    }
}

