/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.TimerTask;
import phex.common.Environment;
import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.statistic.StatisticsManager;
import phex.statistic.UptimeStatisticProvider;

public class UltrapeerCapabilityChecker
extends TimerTask {
    private static final long TIMER_PERIOD = 10000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long TWO_HOURS = 0x6DDD00L;
    private boolean isUltrapeerCapable;
    private boolean isUltrapeerOS;
    private UptimeStatisticProvider uptimeProvider;

    public UltrapeerCapabilityChecker() {
        Environment environment = Environment.getInstance();
        this.isUltrapeerOS = environment.isUltrapeerOS();
        this.uptimeProvider = (UptimeStatisticProvider)StatisticsManager.getInstance().getStatisticProvider("UptimeProvider");
        environment.scheduleTimerTask(this, 0L, 10000L);
    }

    public void run() {
        this.checkIfUltrapeerCapable();
    }

    private void checkIfUltrapeerCapable() {
        boolean bl;
        this.isUltrapeerCapable = bl = ServiceManager.sCfg.allowToBecomeUP && !ServiceManager.sCfg.isBehindFirewall && this.isUltrapeerOS && ServiceManager.sCfg.networkSpeedKbps > 64 && ServiceManager.sCfg.mNetMaxRate > 15 && ServiceManager.sCfg.maxTotalBandwidth > 20 && (((LongObj)this.uptimeProvider.getValue()).getValue() > 0x6DDD00L || ((LongObj)this.uptimeProvider.getAverageValue()).getValue() > 3600000L);
    }

    public boolean isUltrapeerCapable() {
        return this.isUltrapeerCapable;
    }
}

