/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class GGEPBlock {
    public static final byte MAGIC_NUMBER = -61;
    public static final String BROWSE_HOST_HEADER_ID = "BH";
    private HashMap headerToDataMap = new HashMap(3);
    private static byte[] queryGGEPBlock;

    private GGEPBlock() {
    }

    public void debugDump() {
        System.out.println("--------------------------------------");
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            System.out.println(k + " = " + this.headerToDataMap.get(k));
        }
        System.out.println("--------------------------------------");
    }

    private void addExtension(String string) {
        this.headerToDataMap.put(string, "");
    }

    public void addExtension(String string, String string2) {
        this.headerToDataMap.put(string, string2);
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(30);
        byteArrayOutputStream.write(-61);
        Iterator iterator = this.headerToDataMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.headerToDataMap.get(string);
            int n = 0;
            if (!iterator.hasNext()) {
                n |= 0x80;
            }
            byte[] byArray = string.getBytes();
            byteArrayOutputStream.write(n |= byArray.length);
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = string2.getBytes();
            int n2 = byArray2.length;
            int n3 = n2 & 0x3F000;
            if (n3 != 0) {
                n3 >>= 12;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            if ((n3 = n2 & 0xFC0) != 0) {
                n3 >>= 6;
                n3 = 0x80 | n3;
                byteArrayOutputStream.write(n3);
            }
            n3 = n2 & 0x3F;
            n3 = 0x40 | n3;
            byteArrayOutputStream.write(n3);
            if (n2 <= 0) continue;
            byteArrayOutputStream.write(byArray2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean isExtensionAvailable(String string) {
        return this.headerToDataMap.containsKey(string);
    }

    public static byte[] getBrowseHostGGEPBlock() {
        block2: {
            if (queryGGEPBlock != null) break block2;
            GGEPBlock gGEPBlock = new GGEPBlock();
            gGEPBlock.addExtension(BROWSE_HOST_HEADER_ID);
            try {
                queryGGEPBlock = gGEPBlock.getBytes();
            }
            catch (IOException iOException) {
                Logger.logError(iOException);
            }
        }
        return queryGGEPBlock;
    }

    public static boolean isExtensionHeaderInBlocks(GGEPBlock[] gGEPBlockArray, String string) {
        int n = 0;
        while (n < gGEPBlockArray.length) {
            if (gGEPBlockArray[n].isExtensionAvailable(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
        GGEPParser gGEPParser = new GGEPParser();
        return gGEPParser.parseGGEPBlocks(byArray, n);
    }

    private static class GGEPParser {
        private int offset;
        private ArrayList ggepList = new ArrayList(3);

        public GGEPBlock[] parseGGEPBlocks(byte[] byArray, int n) throws InvalidGGEPBlockException {
            this.offset = n;
            while (byArray.length > this.offset && byArray[this.offset] == -61) {
                ++this.offset;
                this.ggepList.add(this.parseGGEPBlock(byArray));
            }
            GGEPBlock[] gGEPBlockArray = new GGEPBlock[this.ggepList.size()];
            this.ggepList.toArray(gGEPBlockArray);
            return gGEPBlockArray;
        }

        private GGEPBlock parseGGEPBlock(byte[] byArray) throws InvalidGGEPBlockException {
            GGEPBlock gGEPBlock = new GGEPBlock();
            boolean bl = false;
            while (!bl) {
                if ((byArray[this.offset] & 0x10) != 0) {
                    throw new InvalidGGEPBlockException();
                }
                bl = (byArray[this.offset] & 0x80) != 0;
                boolean bl2 = (byArray[this.offset] & 0x40) != 0;
                boolean bl3 = (byArray[this.offset] & 0x20) != 0;
                short s = (short)(byArray[this.offset] & 0xF);
                if (s == 0) {
                    throw new InvalidGGEPBlockException();
                }
                ++this.offset;
                String string = new String(byArray, this.offset, (int)s);
                this.offset += s;
                int n = this.parseDataLength(byArray);
                String string2 = null;
                if (n > 0) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, this.offset, byArray2, 0, n);
                    this.offset += n;
                    if (bl2) continue;
                    if (bl3) {
                        byArray2 = IOUtil.inflate(byArray2);
                    }
                    string2 = new String(byArray2);
                }
                gGEPBlock.addExtension(string, string2);
            }
            return gGEPBlock;
        }

        private int parseDataLength(byte[] byArray) throws InvalidGGEPBlockException {
            byte by;
            int n = 0;
            int n2 = 0;
            do {
                if (++n2 > 3) {
                    throw new InvalidGGEPBlockException();
                }
                by = byArray[this.offset];
                ++this.offset;
                n = n << 6 | by & 0x3F;
            } while (64 != (by & 0x40));
            return n;
        }
    }
}

