/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.io.IOException;
import java.util.ArrayList;
import phex.common.ThreadPool;
import phex.common.URN;
import phex.connection.BrowseHostConnection;
import phex.connection.BrowseHostException;
import phex.download.RemoteFile;
import phex.host.HostAddress;
import phex.msg.GUID;
import phex.msg.MsgQueryResponse;
import phex.msg.MsgResRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.Localizer;
import phex.utils.Logger;

public class BrowseHostResults
extends Search {
    public static final short NO_ERROR = 0;
    public static final short CONNECTION_ERROR = 1;
    public static final short BROWSE_HOST_ERROR = 2;
    private short browseHostError;
    private HostAddress hostAddress;
    private GUID hostGUID;

    public BrowseHostResults(HostAddress hostAddress, GUID gUID) {
        super(Localizer.getFormatedString("BrowsingHost", new Object[]{hostAddress.getFullHostName()}));
        this.hostAddress = hostAddress;
        this.hostGUID = gUID;
    }

    public void startSearching() {
        this.isSearching = true;
        this.browseHostError = 0;
        Runnable runnable = new Runnable(){

            public void run() {
                BrowseHostConnection browseHostConnection = new BrowseHostConnection(BrowseHostResults.this.hostAddress, BrowseHostResults.this.hostGUID, BrowseHostResults.this);
                try {
                    browseHostConnection.sendBrowseHostRequest();
                }
                catch (BrowseHostException browseHostException) {
                    Logger.logMessage(Logger.FINEST, (short)8, browseHostException);
                    BrowseHostResults.this.browseHostError = (short)2;
                    BrowseHostResults.this.stopSearching();
                }
                catch (IOException iOException) {
                    Logger.logMessage(Logger.FINEST, (short)8, iOException);
                    BrowseHostResults.this.browseHostError = (short)1;
                    BrowseHostResults.this.stopSearching();
                }
            }
        };
        ThreadPool.getInstance().addJob(runnable, "BrowseHostConnection-" + Integer.toHexString(runnable.hashCode()));
        this.fireSearchStarted();
    }

    public short getBrowseHostError() {
        return this.browseHostError;
    }

    public void stopSearching() {
        this.isSearching = false;
        this.fireSearchStoped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(MsgQueryResponse msgQueryResponse) {
        int n = msgQueryResponse.getRemoteHostSpeed();
        GUID gUID = msgQueryResponse.getRemoteClientID();
        HostAddress hostAddress = msgQueryResponse.getHostAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, hostAddress, n);
        queryHitHost.setQHDFlags(msgQueryResponse.getPushNeededFlag(), msgQueryResponse.getServerBusyFlag(), msgQueryResponse.getHasUploadedFlag(), msgQueryResponse.getUploadSpeedFlag());
        queryHitHost.setVendorCode(msgQueryResponse.getVendorCode());
        queryHitHost.setChatSupported(msgQueryResponse.isChatSupported());
        queryHitHost.setBrowseHostSupported(msgQueryResponse.isBrowseHostSupported());
        short s = queryHitHost.getHostRating();
        int n2 = this.queryHitList.size();
        int n3 = 0;
        while (n3 < msgQueryResponse.getRecordCount()) {
            MsgResRecord msgResRecord = msgQueryResponse.getMsgRecord(n3);
            ArrayList arrayList = this.filteredQueryHitList;
            synchronized (arrayList) {
                boolean bl = false;
                if (this.searchFilter != null) {
                    bl = this.searchFilter.isFiltered(this.filteredQueryHitList.size(), msgResRecord.getFileSize(), msgResRecord.getFilename(), n, s);
                }
                if (bl) {
                } else {
                    String string = msgResRecord.getFilename();
                    long l = msgResRecord.getFileSize();
                    URN uRN = msgResRecord.getURN();
                    int n4 = msgResRecord.getFileIndex();
                    RemoteFile remoteFile = new RemoteFile(queryHitHost, n4, string, l, uRN, msgResRecord.getMetaData(), 100);
                    this.queryHitList.add(remoteFile);
                    if (!bl) {
                        this.filteredQueryHitList.add(remoteFile);
                    }
                }
            }
            ++n3;
        }
        int n5 = this.queryHitList.size();
        if (n5 > n2) {
            this.fireSearchHitsAdded(n2, n5);
        }
    }
}

