/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.event.AsynchronousDispatcher;
import phex.event.SharedFilesChangeListener;
import phex.share.ShareFile;
import phex.utils.FileUtils;
import phex.utils.Logger;
import phex.utils.ReadWriteLock;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBPhex;
import phex.xml.XJBSharedFile;
import phex.xml.XJBSharedLibrary;
import phex.xml.XMLBuilder;

public class FileAdministration {
    private ReadWriteLock rwLock;
    private ArrayList sharedDirectories;
    private ArrayList sharedFiles;
    private ArrayList indexedSharedFiles;
    private HashMap urnToFileMap;
    private HashMap nameToFileMap;
    private ArrayList fileExclusionList;
    private ArrayList fileInclusionList;
    private int totalFileSizeKb = 0;
    private Thread rescanThread;
    private ArrayList listenerList = new ArrayList(2);

    public FileAdministration() {
        this.rwLock = new ReadWriteLock();
        this.sharedDirectories = new ArrayList(1);
        this.sharedFiles = new ArrayList();
        this.indexedSharedFiles = new ArrayList();
        this.urnToFileMap = new HashMap();
        this.fileExclusionList = new ArrayList();
        this.fileInclusionList = new ArrayList();
        this.nameToFileMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileAt(int n) {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (n < this.sharedFiles.size()) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.sharedFiles.get(n);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile[] getSharedFiles() {
        ShareFile[] shareFileArray;
        this.rwLock.readLock();
        try {
            ShareFile[] shareFileArray2 = new ShareFile[this.sharedFiles.size()];
            shareFileArray = shareFileArray2 = this.sharedFiles.toArray(shareFileArray2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return shareFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File[] getSharedDirectories() {
        File[] fileArray;
        this.rwLock.readLock();
        try {
            File[] fileArray2 = new File[this.sharedDirectories.size()];
            this.sharedDirectories.toArray(fileArray2);
            fileArray = fileArray2;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return fileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.sharedFiles.size();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByName(String string) {
        ShareFile shareFile;
        this.rwLock.readLock();
        try {
            shareFile = (ShareFile)this.nameToFileMap.get(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByIndex(int n) throws IndexOutOfBoundsException {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (n < this.indexedSharedFiles.size()) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.indexedSharedFiles.get(n);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByURN(URN uRN) throws IndexOutOfBoundsException {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (uRN != null) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.urnToFileMap.get(uRN);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilesByURNs(URN[] uRNArray) {
        ArrayList<ArrayList<Object>> arrayList;
        this.rwLock.readLock();
        try {
            ArrayList arrayList2 = new ArrayList(uRNArray.length);
            int n = 0;
            while (n < uRNArray.length) {
                arrayList = this.urnToFileMap.get(uRNArray[n]);
                if (arrayList != null) {
                    arrayList2.add(arrayList);
                }
                ++n;
            }
            arrayList = arrayList2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalFileSizeInKb() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.totalFileSizeKb;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return n;
    }

    public void rescan(boolean bl, boolean bl2) {
        if (bl2 && this.rescanThread != null && this.rescanThread.isAlive()) {
            this.rescanThread.interrupt();
            try {
                this.rescanThread.join();
            }
            catch (InterruptedException interruptedException) {
                Logger.logWarning(interruptedException);
            }
        }
        if (this.rescanThread == null || !this.rescanThread.isAlive()) {
            FileRescanRunner fileRescanRunner = new FileRescanRunner(bl);
            this.rescanThread = new Thread(ThreadTracking.rootThreadGroup, fileRescanRunner, "FileRescanRunner-" + Integer.toHexString(fileRescanRunner.hashCode()));
            this.rescanThread.setDaemon(true);
            this.rescanThread.setPriority(1);
            this.rescanThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileInvalid(File file) {
        block13: {
            block11: {
                boolean bl;
                if (file.getName().toLowerCase().endsWith(".dl")) {
                    return true;
                }
                if (file.getName().equals("files.idx")) {
                    return true;
                }
                this.rwLock.readLock();
                try {
                    if (this.isIncluded(file)) break block11;
                    bl = true;
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        this.rwLock.readUnlock();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.logError(illegalAccessException);
                    }
                    throw throwable;
                }
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                return bl;
            }
            if (!this.isExcluded(file)) break block13;
            boolean bl = true;
            Object var4_5 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            return bl;
        }
        Object var4_6 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return false;
    }

    private XJBSharedLibrary loadSharedLibrary() {
        XJBPhex xJBPhex;
        Logger.logMessage(Logger.FINE, (short)2, "Load shared library configuration file.");
        File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
        try {
            xJBPhex = XMLBuilder.loadXJBPhexFromFile(file);
            if (xJBPhex == null) {
                Logger.logMessage(Logger.FINE, (short)4, "No shared library configuration file found.");
                return ObjectFactory.createXJBSharedLibrary();
            }
        }
        catch (JAXBException jAXBException) {
            Logger.logError(jAXBException);
            try {
                return ObjectFactory.createXJBSharedLibrary();
            }
            catch (JAXBException jAXBException2) {
                Logger.logError(jAXBException2);
                throw new RuntimeException(jAXBException2.getMessage());
            }
        }
        XJBSharedLibrary xJBSharedLibrary = xJBPhex.getSharedLibrary();
        return xJBSharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveSharedLibrary() {
        block8: {
            Logger.logMessage(Logger.CONFIG, (short)4, "Saving shared library.");
            this.rwLock.readLock();
            PhexElement phexElement = ObjectFactory.createPhexElement();
            XJBSharedLibrary xJBSharedLibrary = this.createXJBSharedLibrary();
            phexElement.setSharedLibrary(xJBSharedLibrary);
            phexElement.setPhexVersion(VersionUtils.getProgramVersion());
            File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
            XMLBuilder.saveToFile(file, phexElement);
            Object var5_5 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            break block8;
            {
                catch (JAXBException jAXBException) {
                    Logger.logError(jAXBException);
                    Object var5_6 = null;
                    try {
                        this.rwLock.readUnlock();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Logger.logError(illegalAccessException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XJBSharedLibrary createXJBSharedLibrary() throws JAXBException {
        XJBSharedLibrary xJBSharedLibrary = ObjectFactory.createXJBSharedLibrary();
        this.rwLock.readLock();
        try {
            Iterator iterator = this.sharedFiles.iterator();
            List list = xJBSharedLibrary.getSharedFileList();
            while (iterator.hasNext()) {
                try {
                    ShareFile shareFile = (ShareFile)iterator.next();
                    if (shareFile.getURN() == null) continue;
                    XJBSharedFile xJBSharedFile = shareFile.createXJBSharedFile();
                    list.add(xJBSharedFile);
                }
                catch (Exception exception) {
                    Logger.logError(exception, "SharedFile skipped due to error.");
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        return xJBSharedLibrary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSharedFile(ShareFile shareFile) {
        int n;
        File file = shareFile.getFile();
        if (this.getFileByName(file.getAbsolutePath()) != null) {
            return;
        }
        this.rwLock.writeLock();
        try {
            n = this.indexedSharedFiles.size();
            shareFile.setFileIndex(n);
            this.indexedSharedFiles.add(n, shareFile);
            n = this.sharedFiles.size();
            this.sharedFiles.add(n, shareFile);
            this.urnToFileMap.put(shareFile.getURN(), shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        this.fireSharedFileAdded(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSharedFile(ShareFile shareFile) {
        int n;
        this.rwLock.writeLock();
        try {
            int n2 = shareFile.getFileIndex();
            this.indexedSharedFiles.set(n2, null);
            File file = shareFile.getFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            n = this.sharedFiles.indexOf(shareFile);
            if (n != -1) {
                this.sharedFiles.remove(n);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        if (n != -1) {
            this.fireSharedFileRemoved(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.totalFileSizeKb = 0;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
        this.fireAllSharedFilesChanged();
    }

    private void setInclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileInclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileInclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isIncluded(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        int n = 0;
        while (n < this.fileInclusionList.size()) {
            String string2 = (String)this.fileInclusionList.get(n);
            if (string2.equals("*")) {
                return true;
            }
            if (string2.equals("*.*")) {
                return true;
            }
            if (string2.startsWith("*")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string.indexOf(string2) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void setExclusions(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        this.fileExclusionList.clear();
        while (stringTokenizer.hasMoreTokens()) {
            this.fileExclusionList.add(stringTokenizer.nextToken().trim().toLowerCase());
        }
    }

    private boolean isExcluded(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = file.getName().toLowerCase();
        int n = 0;
        while (n < this.fileExclusionList.size()) {
            String string2 = (String)this.fileExclusionList.get(n);
            if (string.indexOf(string2) != -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSharedDirectories(String string) {
        this.rwLock.writeLock();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n = stringTokenizer.countTokens();
            this.sharedDirectories.clear();
            this.sharedDirectories.ensureCapacity(n);
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken().trim());
                if (this.sharedDirectories.contains(file)) continue;
                this.sharedDirectories.add(file);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.logError(illegalAccessException);
        }
    }

    public void addSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        this.listenerList.add(sharedFilesChangeListener);
    }

    public void removeSharedFilesChangeListener(SharedFilesChangeListener sharedFilesChangeListener) {
        this.listenerList.remove(sharedFilesChangeListener);
    }

    private void fireSharedFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
                    sharedFilesChangeListener.sharedFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireSharedFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
                    sharedFilesChangeListener.sharedFileAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireSharedFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n2];
                    sharedFilesChangeListener.sharedFileRemoved(n);
                    --n2;
                }
            }
        });
    }

    private void fireAllSharedFilesChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = FileAdministration.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    SharedFilesChangeListener sharedFilesChangeListener = (SharedFilesChangeListener)objectArray[n];
                    sharedFilesChangeListener.allSharedFilesChanged();
                    --n;
                }
            }
        });
    }

    public void fireSharedFileChanged(ShareFile shareFile) {
        int n = this.sharedFiles.indexOf(shareFile);
        if (n >= 0) {
            this.fireSharedFileChanged(n);
        }
    }

    private class FileRescanRunner
    implements Runnable {
        private boolean isInitialRescan;
        private HashMap sharedFilesCache;

        public FileRescanRunner(boolean bl) {
            this.isInitialRescan = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.logMessage(Logger.FINEST, (short)4, "Staring file rescan (Initial: " + this.isInitialRescan + ").");
            Cfg cfg = ServiceManager.sCfg;
            FileAdministration.this.setSharedDirectories(cfg.mUploadDir);
            FileAdministration.this.setExclusions(cfg.mUploadFileExclusions);
            FileAdministration.this.setInclusions(cfg.mUploadFileInclusions);
            if (FileAdministration.this.rescanThread.isInterrupted()) {
                return;
            }
            if (this.isInitialRescan) {
                FileAdministration.this.clearSharedFiles();
                if (FileAdministration.this.rescanThread.isInterrupted()) {
                    return;
                }
                this.buildSharedFilesCache();
            } else {
                this.removeUnsharedFiles();
            }
            if (FileAdministration.this.rescanThread.isInterrupted()) {
                return;
            }
            HashMap hashMap = new HashMap();
            FileAdministration.this.rwLock.readLock();
            try {
                Iterator iterator = FileAdministration.this.sharedDirectories.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    this.scanDir(file, hashMap, ServiceManager.sCfg.mUploadScanRecursively);
                    if (!FileAdministration.this.rescanThread.isInterrupted()) continue;
                    Object var6_5 = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    FileAdministration.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
            {
                try {
                    FileAdministration.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                return;
            }
            Object var6_6 = null;
            try {
                FileAdministration.this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
            }
            FileAdministration.this.saveSharedLibrary();
        }

        private void buildSharedFilesCache() {
            this.sharedFilesCache = new HashMap();
            XJBSharedLibrary xJBSharedLibrary = FileAdministration.this.loadSharedLibrary();
            Iterator iterator = xJBSharedLibrary.getSharedFileList().iterator();
            while (iterator.hasNext() && !FileAdministration.this.rescanThread.isInterrupted()) {
                XJBSharedFile xJBSharedFile = (XJBSharedFile)iterator.next();
                this.sharedFilesCache.put(xJBSharedFile.getFileName(), xJBSharedFile);
            }
        }

        private void scanDir(File file, HashMap hashMap, boolean bl) {
            String string;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Logger.logWarning(iOException);
                return;
            }
            if (hashMap.containsKey(string)) {
                return;
            }
            hashMap.put(string, "");
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                Logger.logError((short)4, "'" + file + "' is not a directory.");
                return;
            }
            int n = 0;
            while (n < fileArray.length && !FileAdministration.this.rescanThread.isInterrupted()) {
                if (!FileAdministration.this.isFileInvalid(fileArray[n])) {
                    if (fileArray[n].isFile()) {
                        this.handleScannedFile(fileArray[n]);
                    } else if (fileArray[n].isDirectory() && bl) {
                        this.scanDir(fileArray[n], hashMap, bl);
                    }
                }
                ++n;
            }
        }

        private void handleScannedFile(File file) {
            boolean bl = false;
            if (this.isInitialRescan) {
                ShareFile shareFile = new ShareFile(file);
                XJBSharedFile xJBSharedFile = (XJBSharedFile)this.sharedFilesCache.get(file.getAbsolutePath());
                if (xJBSharedFile != null && xJBSharedFile.getLastModified() == file.lastModified()) {
                    shareFile.updateFromCache(xJBSharedFile);
                } else {
                    shareFile.calculateURN();
                    if (FileAdministration.this.rescanThread.isInterrupted()) {
                        return;
                    }
                    bl = true;
                }
                FileAdministration.this.addSharedFile(shareFile);
            } else {
                ShareFile shareFile = FileAdministration.this.getFileByName(file.getAbsolutePath());
                if (shareFile == null) {
                    shareFile = new ShareFile(file);
                    shareFile.calculateURN();
                    if (FileAdministration.this.rescanThread.isInterrupted()) {
                        return;
                    }
                    bl = true;
                    FileAdministration.this.addSharedFile(shareFile);
                }
            }
            if (bl) {
                FileAdministration.this.saveSharedLibrary();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void removeUnsharedFiles() {
            FileAdministration.this.rwLock.readLock();
            try {
                int n = FileAdministration.this.sharedFiles.size() - 1;
                while (true) {
                    block10: {
                        block9: {
                            if (n < 0) break block9;
                            if (!FileAdministration.this.rescanThread.isInterrupted()) break block10;
                        }
                        Object var5_4 = null;
                        break;
                    }
                    ShareFile shareFile = (ShareFile)FileAdministration.this.sharedFiles.get(n);
                    File file = shareFile.getFile();
                    if (!this.isInSharedDirectory(file) || !file.exists()) {
                        FileAdministration.this.removeSharedFile(shareFile);
                    }
                    --n;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    FileAdministration.this.rwLock.readUnlock();
                    throw throwable;
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.logError(illegalAccessException);
                }
                throw throwable;
            }
            try {}
            catch (IllegalAccessException illegalAccessException) {
                Logger.logError(illegalAccessException);
                return;
            }
            FileAdministration.this.rwLock.readUnlock();
        }

        private boolean isInSharedDirectory(File file) {
            Iterator iterator = FileAdministration.this.sharedDirectories.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!FileUtils.isChildOfDir(file, file2)) continue;
                return true;
            }
            return false;
        }
    }
}

