/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Socket;
import phex.common.AlternateLocationContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.bandwidth.BandwidthController;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostAddress;
import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.XQueueParameters;
import phex.share.FileAdministration;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.GnutellaInputStream;
import phex.utils.Logger;

public class UploadEngine {
    private static final int BUFFER_LENGTH = 1024;
    private RandomAccessFile raFile;
    private Socket socket;
    private OutputStream outStream;
    private GnutellaInputStream inStream;
    private boolean isUploadQueued;
    private long minNextPollTime;
    private long startOffset;
    private long endOffset;
    private long fileStartOffset;
    private HTTPRequest httpRequest;
    private UploadState uploadState;
    private boolean isIPCounted;
    private HostAddress hostAddress;
    private boolean isPersistentConnection;

    public UploadEngine(Socket socket, GnutellaInputStream gnutellaInputStream, HTTPRequest hTTPRequest) throws IOException {
        this.socket = socket;
        this.inStream = gnutellaInputStream;
        gnutellaInputStream.setBandwidthController(ServiceManager.getInstance().getUploadBandwidthController());
        this.outStream = socket.getOutputStream();
        this.httpRequest = hTTPRequest;
        this.isIPCounted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startUpload() throws IOException {
        Logger.logMessage(Logger.FINE, (short)4, "Upload Engine starts upload.");
        try {
            do {
                boolean bl;
                if (!(bl = this.evaluateHTTPRequest())) {
                    return;
                }
                try {
                    if (!this.isUploadQueued) {
                        this.sendBinaryData();
                    }
                }
                catch (IOException iOException) {
                    this.uploadState.setStatus((short)4);
                    throw iOException;
                }
                if (!this.isPersistentConnection) continue;
                this.readNextHTTPRequest();
            } while (this.isPersistentConnection);
        }
        finally {
            this.stopUpload();
            UploadManager uploadManager = UploadManager.getInstance();
            if (this.isIPCounted) {
                uploadManager.releaseUploadIP(this.hostAddress);
            }
            if (this.uploadState != null) {
                this.uploadState.setUploadEngine(null);
            }
            if (this.isUploadQueued) {
                uploadManager.removeQueuedUpload(this.uploadState);
            }
        }
    }

    public void stopUpload() {
        block11: {
            if (this.inStream != null) {
                this.inStream.close();
            }
            if (this.outStream != null) {
                try {
                    this.outStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.raFile != null) {
                try {
                    this.raFile.getFD().sync();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.raFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.socket == null) break block11;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sendBinaryData() throws IOException {
        this.uploadState.setStatus((short)2);
        File file = this.uploadState.getUploadFile();
        this.raFile = new RandomAccessFile(file, "r");
        this.raFile.seek(this.fileStartOffset);
        BandwidthController bandwidthController = ServiceManager.getInstance().getUploadBandwidthController();
        long l = this.endOffset - this.startOffset + 1L;
        long l2 = 0L;
        int n = -1;
        byte[] byArray = new byte[1024];
        while (l > 0L) {
            n = this.raFile.read(byArray);
            if (n == -1) break;
            if ((long)n > l) {
                n = (int)l;
            }
            this.outStream.write(byArray, 0, n);
            l -= (long)n;
            this.uploadState.setTransferredDataSize(l2 += (long)n);
            bandwidthController.controlBandwidth(n);
        }
        this.uploadState.setStatus((short)3);
    }

    private boolean evaluateHTTPRequest() throws IOException {
        HTTPRangeSet.Range range;
        short s;
        HTTPRangeSet hTTPRangeSet;
        HTTPHeader hTTPHeader;
        ShareFile shareFile;
        HTTPHeader hTTPHeader2;
        Logger.logMessage(Logger.FINE, (short)4, "HTTP Request: " + this.httpRequest.buildHTTPRequestString());
        GnutellaRequest gnutellaRequest = this.httpRequest.getGnutellaRequest();
        if (gnutellaRequest == null) {
            throw new IOException("Not a Gnutella file request.");
        }
        if (gnutellaRequest.getURN() == null && (hTTPHeader2 = this.httpRequest.getHeader("X-Gnutella-Content-URN")) != null && URN.isValidURN(hTTPHeader2.getValue())) {
            URN uRN = new URN(hTTPHeader2.getValue());
            gnutellaRequest.setContentURN(uRN);
        }
        int n = -1;
        hTTPHeader2 = this.httpRequest.getHeader("Listen-IP");
        if (hTTPHeader2 == null) {
            hTTPHeader2 = this.httpRequest.getHeader("X-My-Address");
        }
        if (hTTPHeader2 != null) {
            n = HostAddress.parsePort(hTTPHeader2.getValue());
        }
        if (n <= 0) {
            n = this.socket.getPort();
        }
        this.hostAddress = new HostAddress(this.socket.getInetAddress().getHostAddress(), n);
        UploadManager uploadManager = UploadManager.getInstance();
        if (!this.isIPCounted) {
            boolean bl = uploadManager.validateAndCountIP(this.hostAddress);
            if (!bl) {
                HTTPResponse hTTPResponse = new HTTPResponse(503, "Upload Limit Reached for IP", true);
                this.sendHTTPResponse(hTTPResponse);
                return false;
            }
            this.isIPCounted = true;
        }
        if ((shareFile = this.findShareFile(gnutellaRequest)) == null) {
            HTTPResponse hTTPResponse = new HTTPResponse(404, "File not found", true);
            this.sendHTTPResponse(hTTPResponse);
            return false;
        }
        this.isUploadQueued = false;
        if (uploadManager.isHostBusy()) {
            hTTPHeader2 = this.httpRequest.getHeader("X-Queue");
            if (hTTPHeader2 == null || !ServiceManager.sCfg.allowUploadQueuing || uploadManager.isQueueLimitReached()) {
                HTTPResponse hTTPResponse = new HTTPResponse(503, "Upload Limit Reached", true);
                AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
                HTTPHeader[] hTTPHeaderArray = alternateLocationContainer.getAltLocHTTPHeadersForAddress(this.hostAddress);
                hTTPResponse.addHeaders(hTTPHeaderArray);
                this.sendHTTPResponse(hTTPResponse);
                return false;
            }
            this.isUploadQueued = true;
        }
        if ((hTTPHeader = this.httpRequest.getHeader("Range")) != null) {
            hTTPRangeSet = HTTPRangeSet.parseHTTPRangeSet(hTTPHeader.getValue());
            if (hTTPRangeSet == null) {
                HTTPResponse hTTPResponse = new HTTPResponse(500, "Requested Range Not Parseable", true);
                AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
                HTTPHeader[] hTTPHeaderArray = alternateLocationContainer.getAltLocHTTPHeadersForAddress(this.hostAddress);
                hTTPResponse.addHeaders(hTTPHeaderArray);
                this.sendHTTPResponse(hTTPResponse);
                return false;
            }
        } else {
            hTTPRangeSet = new HTTPRangeSet(0L, -1L);
        }
        if ((s = shareFile.getRangeAvailableStatus(range = hTTPRangeSet.getFirstRange())) != 0) {
            Object object;
            HTTPResponse hTTPResponse = s == 1 ? new HTTPResponse(503, "Requested Range Not Available", true) : new HTTPResponse(416, "Requested Range Not Satisfiable", true);
            if (shareFile instanceof PartialShareFile) {
                object = (PartialShareFile)shareFile;
                hTTPResponse.addHeader(new HTTPHeader("X-Available-Ranges", ((PartialShareFile)object).buildXAvailableRangesString()));
            }
            object = shareFile.getAltLocContainer();
            HTTPHeader[] hTTPHeaderArray = ((AlternateLocationContainer)object).getAltLocHTTPHeadersForAddress(this.hostAddress);
            hTTPResponse.addHeaders(hTTPHeaderArray);
            this.sendHTTPResponse(hTTPResponse);
            return false;
        }
        String string = null;
        hTTPHeader2 = this.httpRequest.getHeader("User-Agent");
        string = hTTPHeader2 != null ? hTTPHeader2.getValue() : "";
        hTTPHeader2 = this.httpRequest.getHeader("Connection");
        this.isPersistentConnection = "HTTP/1.1".equals(this.httpRequest.getHTTPVersion()) ? hTTPHeader2 == null || !hTTPHeader2.getValue().equalsIgnoreCase("CLOSE") : hTTPHeader2 != null && hTTPHeader2.getValue().equalsIgnoreCase("KEEP-ALIVE");
        if (this.isUploadQueued) {
            int n2;
            if (this.uploadState == null) {
                this.uploadState = new UploadState(this.hostAddress, string);
                n2 = uploadManager.addQueuedUpload(this.uploadState) + 1;
            } else {
                this.uploadState.update(this.hostAddress, string);
                n2 = uploadManager.getQueuedPosition(this.uploadState) + 1;
            }
            this.uploadState.setStatus((short)1);
            int n3 = uploadManager.getUploadQueueSize();
            int n4 = ServiceManager.sCfg.mMaxUpload;
            int n5 = ServiceManager.sCfg.minUploadQueuePollTime;
            int n6 = ServiceManager.sCfg.maxUploadQueuePollTime;
            HTTPResponse hTTPResponse = new HTTPResponse(503, "Remotely Queued", true);
            AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
            HTTPHeader[] hTTPHeaderArray = alternateLocationContainer.getAltLocHTTPHeadersForAddress(this.hostAddress);
            hTTPResponse.addHeaders(hTTPHeaderArray);
            XQueueParameters xQueueParameters = new XQueueParameters(n2, n3, n4, n5, n6);
            hTTPResponse.addHeader(new HTTPHeader("X-Queue", xQueueParameters.buildHTTPString()));
            this.sendHTTPResponse(hTTPResponse);
            this.socket.setSoTimeout(n6 * 1000);
            this.minNextPollTime = System.currentTimeMillis() + (long)(n5 * 1000);
            return true;
        }
        HTTPHeader hTTPHeader3 = null;
        if (shareFile instanceof PartialShareFile) {
            PartialShareFile partialShareFile = (PartialShareFile)shareFile;
            partialShareFile.findFittingPartForRange(range);
            this.fileStartOffset = partialShareFile.getFileStartOffset();
            hTTPHeader3 = new HTTPHeader("X-Available-Ranges", partialShareFile.buildXAvailableRangesString());
        } else {
            shareFile.incUploadCount();
            this.fileStartOffset = range.getStartOffset(shareFile.getFileSize());
        }
        this.startOffset = range.getStartOffset(shareFile.getFileSize());
        this.endOffset = range.getEndOffset(shareFile.getFileSize());
        long l = this.endOffset - this.startOffset + 1L;
        if (this.uploadState == null) {
            this.uploadState = new UploadState(this.hostAddress, string, shareFile.getFileName(), shareFile.getURN(), shareFile.getFile(), l);
        } else {
            this.uploadState.update(this.hostAddress, string, shareFile.getFileName(), shareFile.getURN(), shareFile.getFile(), l);
        }
        this.uploadState.setUploadEngine(this);
        uploadManager.addUploadState(this.uploadState);
        HTTPResponse hTTPResponse = this.startOffset == 0L && this.endOffset == shareFile.getFileSize() - 1L ? new HTTPResponse(200, "OK", true) : new HTTPResponse(206, "Partial Content", true);
        if (hTTPHeader3 != null) {
            hTTPResponse.addHeader(hTTPHeader3);
        }
        hTTPResponse.addHeader(new HTTPHeader("Content-Type", "application/binary"));
        hTTPResponse.addHeader(new HTTPHeader("Content-Length", String.valueOf(l)));
        hTTPResponse.addHeader(new HTTPHeader("Content-Range", "bytes " + this.startOffset + "-" + this.endOffset + "/" + shareFile.getFileSize()));
        if (this.isPersistentConnection) {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        } else {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "close"));
        }
        if (shareFile.getURN() != null) {
            hTTPResponse.addHeader(new HTTPHeader("X-Gnutella-Content-URN", shareFile.getURN().getAsString()));
        }
        AlternateLocationContainer alternateLocationContainer = shareFile.getAltLocContainer();
        HTTPHeader[] hTTPHeaderArray = alternateLocationContainer.getAltLocHTTPHeadersForAddress(this.hostAddress);
        hTTPResponse.addHeaders(hTTPHeaderArray);
        hTTPHeaderArray = this.httpRequest.getHeaders("Alt-Location");
        alternateLocationContainer.addFromHTTPHeaders(hTTPHeaderArray);
        hTTPHeaderArray = this.httpRequest.getHeaders("X-Gnutella-Alternate-Location");
        alternateLocationContainer.addFromHTTPHeaders(hTTPHeaderArray);
        this.sendHTTPResponse(hTTPResponse);
        this.socket.setSoTimeout(ServiceManager.sCfg.mSocketTimeout);
        this.minNextPollTime = -1L;
        return true;
    }

    private void readNextHTTPRequest() throws IOException {
        try {
            this.httpRequest = HTTPProcessor.parseHTTPRequest(this.inStream);
            if (this.minNextPollTime > 0L && System.currentTimeMillis() < this.minNextPollTime) {
                throw new IOException("Queued host is requesting too soon.");
            }
        }
        catch (HTTPMessageException hTTPMessageException) {
            throw new IOException("Invalid HTTP Message: " + hTTPMessageException.getMessage());
        }
    }

    private void sendHTTPResponse(HTTPResponse hTTPResponse) throws IOException {
        String string = hTTPResponse.buildHTTPResponseString();
        Logger.logMessage(Logger.FINE, (short)4, "HTTP Response: " + string);
        this.outStream.write(string.getBytes());
    }

    private ShareFile findShareFile(GnutellaRequest gnutellaRequest) {
        ShareFile shareFile = null;
        FileAdministration fileAdministration = ShareManager.getInstance().getFileAdministration();
        URN uRN = gnutellaRequest.getURN();
        if (uRN != null) {
            SwarmingManager swarmingManager;
            SWDownloadFile sWDownloadFile;
            shareFile = fileAdministration.getFileByURN(uRN);
            if (shareFile == null && ServiceManager.sCfg.arePartialFilesShared && (sWDownloadFile = (swarmingManager = SwarmingManager.getInstance()).getDownloadFileByURN(uRN)) != null) {
                shareFile = new PartialShareFile(sWDownloadFile);
            }
        } else if (gnutellaRequest.getFileIndex() != -1) {
            int n = gnutellaRequest.getFileIndex();
            shareFile = fileAdministration.getFileByIndex(n);
            if (shareFile != null) {
                String string = shareFile.getFileName();
                if (!gnutellaRequest.getFileName().equalsIgnoreCase(string)) {
                    Logger.logMessage(Logger.FINEST, (short)2, "Requested index '" + n + "' with filename '" + string + "' dosn't match request filename '" + gnutellaRequest.getFileName() + "'.");
                    shareFile = null;
                }
            } else if (gnutellaRequest.getFileName() != null) {
                shareFile = fileAdministration.getFileByName(gnutellaRequest.getFileName());
            }
        }
        return shareFile;
    }
}

