/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import phex.common.IPCounter;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.common.TransferRateService;
import phex.download.HostBusyException;
import phex.event.AsynchronousDispatcher;
import phex.event.UploadFilesChangeListener;
import phex.host.HostAddress;
import phex.http.HTTPRequest;
import phex.upload.UploadEngine;
import phex.upload.UploadState;
import phex.utils.GnutellaInputStream;

public class UploadManager
implements Manager {
    private IPCounter uploadIPCounter;
    private ArrayList uploadStateList;
    private ArrayList queuedStateList;
    private TransferRateService transferRateService;
    private static UploadManager instance;
    private ArrayList listenerList = new ArrayList(2);

    private UploadManager() {
        this.uploadIPCounter = new IPCounter(ServiceManager.sCfg.mMaxUploadPerIP);
        this.uploadStateList = new ArrayList();
        this.queuedStateList = new ArrayList();
    }

    public static UploadManager getInstance() {
        if (instance == null) {
            instance = new UploadManager();
        }
        return instance;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.transferRateService = ServiceManager.getTransferRateService();
        return true;
    }

    public void shutdown() {
    }

    public void handleUploadRequest(Socket socket, GnutellaInputStream gnutellaInputStream, HTTPRequest hTTPRequest) throws IOException {
        UploadEngine uploadEngine = new UploadEngine(socket, gnutellaInputStream, hTTPRequest);
        uploadEngine.startUpload();
    }

    public boolean isHostBusy() {
        return this.getUploadingCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public boolean isQueueLimitReached() {
        return this.queuedStateList.size() >= ServiceManager.sCfg.maxUploadQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndCountIP(HostAddress hostAddress) throws HostBusyException {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            return this.uploadIPCounter.validateAndCountIP(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUploadIP(HostAddress hostAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.relaseIP(hostAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.size();
            this.uploadStateList.add(n, uploadState);
            this.transferRateService.registerTransferDataProvider(uploadState);
            this.fireUploadFileAdded(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadListSize() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingCount() {
        int n = 0;
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n2 = this.uploadStateList.size() - 1;
            while (n2 >= 0) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(n2);
                if (uploadState.getStatus() == 2 || uploadState.getStatus() == 0) {
                    ++n;
                }
                --n2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState getUploadStateAt(int n) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.uploadStateList.size()) {
                return null;
            }
            return (UploadState)this.uploadStateList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState[] getUploadStatesAt(int[] nArray) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = nArray.length;
            UploadState[] uploadStateArray = new UploadState[n];
            int n2 = this.uploadStateList.size();
            int n3 = 0;
            while (n3 < n) {
                uploadStateArray[n3] = nArray[n3] < 0 || nArray[n3] >= n2 ? null : (UploadState)this.uploadStateList.get(nArray[n3]);
                ++n3;
            }
            return uploadStateArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadState(UploadState uploadState) {
        uploadState.stopUpload();
        this.transferRateService.unregisterTransferDataProvider(uploadState);
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.indexOf(uploadState);
            if (n != -1) {
                this.uploadStateList.remove(n);
                this.fireUploadFileRemoved(n);
            }
        }
        ArrayList arrayList2 = this.queuedStateList;
        synchronized (arrayList2) {
            int n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploadStateList() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.size() - 1;
            while (n >= 0) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(n);
                short s = uploadState.getStatus();
                if (s != 2 && s != 0) {
                    this.transferRateService.unregisterTransferDataProvider(uploadState);
                    this.uploadStateList.remove(n);
                    this.fireUploadFileRemoved(n);
                }
                --n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addQueuedUpload(UploadState uploadState) {
        int n;
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            n = this.queuedStateList.size();
            this.queuedStateList.add(n, uploadState);
        }
        this.fireUploadQueueChanged();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedUpload(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            int n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
                this.fireUploadQueueChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedPosition(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.indexOf(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadQueueSize() {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.size();
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.add(uploadFilesChangeListener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.remove(uploadFilesChangeListener);
    }

    private void fireUploadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileChanged(n);
                    --n2;
                }
            }
        });
    }

    private void fireUploadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileAdded(n);
                    --n2;
                }
            }
        });
    }

    private void fireUploadQueueChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                int n = objectArray.length - 1;
                while (n >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n];
                    uploadFilesChangeListener.uploadQueueChanged();
                    --n;
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                int n2 = objectArray.length - 1;
                while (n2 >= 0) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[n2];
                    uploadFilesChangeListener.uploadFileRemoved(n);
                    --n2;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUploadFileChanged(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.indexOf(uploadState);
            if (n >= 0) {
                this.fireUploadFileChanged(n);
            }
        }
    }
}

