/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

import com.sun.xml.bind.Messages;
import java.util.HashMap;

public class ImplementationRegistry {
    private static ImplementationRegistry instance = null;
    private static HashMap defaultImplMap = null;

    private ImplementationRegistry() {
        defaultImplMap = new HashMap(7);
    }

    public static ImplementationRegistry getInstance() {
        if (instance == null) {
            instance = new ImplementationRegistry();
        }
        return instance;
    }

    public Object newInstance(Class contentInterface) throws Exception {
        Class c = null;
        if (defaultImplMap.containsKey(contentInterface)) {
            c = (Class)defaultImplMap.get(contentInterface);
        } else {
            ImplementationRegistry._assert(false, Messages.format("ImplementationRegistry.MissingInterface", contentInterface));
        }
        return c.newInstance();
    }

    public void setDefaultImpl(Class contentInterface, Class defaultImpl) {
        defaultImplMap.put(contentInterface, defaultImpl);
    }

    private static void _assert(boolean b, String msg) {
        if (!b) {
            throw new InternalError(msg);
        }
    }
}

