/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import redlight.client.AbstractCellEditor;
import redlight.client.DownloadInterface;
import redlight.client.FilesInterface;
import redlight.client.FolderDownloadInterface;
import redlight.client.Machine;
import redlight.client.TreeTableModel;
import redlight.client.TreeTableModelAdapter;
import redlight.client.UploadInterface;
import redlight.hotline.HLProtocol;

public class JTreeTable
extends JTable
implements DropTargetListener,
DragSourceListener,
DragGestureListener,
Autoscroll {
    Machine rlm;
    String rootPath;
    DropTarget dropTarget = new DropTarget(this, this);
    DragSource dragSource = DragSource.getDefaultDragSource();
    public int AutoscrollSensitivity = 60;
    protected TreeTableCellRenderer tree;
    static /* synthetic */ Class class$redlight$client$TreeTableModel;

    public JTreeTable(Machine machine, String rootPath, TreeTableModel treeTableModel) {
        this.rootPath = rootPath;
        this.rlm = machine;
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$redlight$client$TreeTableModel == null ? (class$redlight$client$TreeTableModel = JTreeTable.class$("redlight.client.TreeTableModel")) : class$redlight$client$TreeTableModel, this.tree);
        this.setDefaultEditor(class$redlight$client$TreeTableModel == null ? (class$redlight$client$TreeTableModel = JTreeTable.class$("redlight.client.TreeTableModel")) : class$redlight$client$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.tree.setScrollsOnExpand(true);
        if (this.tree.getRowHeight() < 1) {
            // empty if block
        }
    }

    public Insets getAutoscrollInsets() {
        return new Insets(-this.AutoscrollSensitivity, -this.AutoscrollSensitivity, this.getSize().height + this.AutoscrollSensitivity, this.getSize().width + this.AutoscrollSensitivity);
    }

    public void autoscroll(Point cursorLoc) {
        Rectangle visR = this.getVisibleRect();
        int rowNum = -1;
        if (cursorLoc.y < visR.y + this.AutoscrollSensitivity) {
            rowNum = this.rowAtPoint(cursorLoc) - 1;
        } else if (cursorLoc.y > visR.height - this.AutoscrollSensitivity) {
            rowNum = this.rowAtPoint(cursorLoc) + 1;
        }
        if (rowNum != -1) {
            Rectangle r = this.getCellRect(rowNum, 1, false);
            this.scrollRectToVisible(r);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        DragSourceContext dsc = dragSourceDropEvent.getDragSourceContext();
        Transferable tr = dsc.getTransferable();
        DataFlavor[] flavors = tr.getTransferDataFlavors();
        int i = 0;
        while (i < flavors.length) {
            this.setBorder(BorderFactory.createEmptyBorder());
            ++i;
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent e) {
        e.acceptDrag(e.getDropAction());
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Point dropLocation = dropTargetDragEvent.getLocation();
        int selRow = this.getTree().getClosestRowForLocation(dropLocation.x, dropLocation.y);
        TreePath selPath = this.getTree().getPathForRow(selRow);
        Object o = ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
        if (!(o instanceof HLProtocol.FileListComponent)) {
            return;
        }
        HLProtocol.FileListComponent hlf = (HLProtocol.FileListComponent)o;
        if (hlf.fileType.equals("fldr")) {
            this.setRowSelectionInterval(selRow, selRow);
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            this.setBorder(BorderFactory.createEmptyBorder());
        } else {
            this.getTree().setSelectionPath(selPath.getParentPath());
            if (selPath.getParentPath().getPathCount() == 1) {
                this.setBorder(BorderFactory.createLineBorder(SystemColor.textHighlightText, 4));
            }
            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Point dropLocation = dropTargetDropEvent.getLocation();
            int selRow = this.getTree().getClosestRowForLocation(dropLocation.x, dropLocation.y);
            TreePath selPath = this.getTree().getPathForRow(selRow);
            HLProtocol.FileListComponent hlf = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
            String target = FilesInterface.treePathToFilePath(this.rootPath, selPath);
            Transferable tr = dropTargetDropEvent.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                this.setBorder(BorderFactory.createEmptyBorder());
                ++i;
            }
            if (dropTargetDropEvent.isLocalTransfer()) {
                String from = (String)tr.getTransferData(DataFlavor.stringFlavor);
                if (!hlf.fileType.equals("fldr")) {
                    target = target.substring(0, target.lastIndexOf(58));
                }
                this.rlm.getHLC().requestFileMove(from, target);
                dropTargetDropEvent.acceptDrop(3);
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                if (!hlf.fileType.equals("fldr")) {
                    target = target.substring(0, target.lastIndexOf(58));
                }
                dropTargetDropEvent.acceptDrop(3);
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                Iterator iterator = fileList.iterator();
                while (iterator.hasNext()) {
                    File file = (File)iterator.next();
                    if (file.toString().equals("")) continue;
                    new UploadInterface(this.rlm, target, file);
                }
                dropTargetDropEvent.dropComplete(true);
                return;
            }
            if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String moveTo = (String)tr.getTransferData(DataFlavor.stringFlavor);
            } else {
                System.err.println("Rejected");
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException io) {
            io.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Point dropLocation = dragGestureEvent.getDragOrigin();
        int selRow = this.getTree().getClosestRowForLocation(dropLocation.x, dropLocation.y);
        TreePath selPath = this.getTree().getPathForRow(selRow);
        final HLProtocol.FileListComponent hlf = (HLProtocol.FileListComponent)((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
        final String filePath = FilesInterface.treePathToFilePath(this.rootPath, selPath);
        Transferable fileList = new Transferable(){

            public Object getTransferData(DataFlavor flavor) {
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return filePath;
                }
                if (!hlf.fileType.equals("fldr")) {
                    DownloadInterface dli = new DownloadInterface(JTreeTable.this.rlm, filePath, hlf);
                    File f = dli.getLocalFile();
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (f == null) {
                        return null;
                    }
                    ArrayList<File> al = new ArrayList<File>();
                    al.add(f);
                    return al;
                }
                new FolderDownloadInterface(JTreeTable.this.rlm, filePath, hlf);
                return null;
            }

            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, DataFlavor.stringFlavor};
                return flavors;
            }

            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(DataFlavor.javaFileListFlavor) || flavor.equals(DataFlavor.stringFlavor);
            }
        };
        this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, fileList, this);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$redlight$client$TreeTableModel == null ? (class$redlight$client$TreeTableModel = JTreeTable.class$("redlight.client.TreeTableModel")) : class$redlight$client$TreeTableModel) ? -1 : this.editingRow;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        int counter = min;
                        while (counter <= max) {
                            TreePath selPath;
                            if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = JTreeTable.this.tree.getPathForRow(counter)) != null) {
                                this.addSelectionPath(selPath);
                            }
                            ++counter;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static /* synthetic */ Class class$redlight$client$TreeTableModel;

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                int counter = JTreeTable.this.getColumnCount() - 1;
                while (counter >= 0) {
                    if (JTreeTable.this.getColumnClass(counter) == (class$redlight$client$TreeTableModel == null ? TreeTableCellEditor.class$("redlight.client.TreeTableModel") : class$redlight$client$TreeTableModel)) {
                        MouseEvent me = (MouseEvent)e;
                        MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(newME);
                        break;
                    }
                    --counter;
                }
            }
            return false;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }
}

