/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import redlight.client.ColorScheme;
import redlight.client.Connection;
import redlight.client.Main;
import redlight.macfiles.MacFile;
import redlight.utils.AppAudioClip;
import redlight.utils.DebuggerOutput;
import redlight.utils.LegacyAudioClip;

public class Options {
    transient LegacyAudioClip[] audioClips;
    transient LegacyAudioClip ac;
    public static final int CHAT_ICON = 0;
    public static final int NEWS_ICON = 1;
    public static final int FILES_ICON = 2;
    public static final int MESSAGE_ICON = 3;
    public static final int STOP_ICON = 4;
    public static final int DISCONNECT_ICON = 5;
    public static final int USER_ICON = 6;
    public static final int UPLOAD_ICON = 7;
    public static final int DOWNLOAD_ICON = 8;
    public static final int REFRESH_ICON = 9;
    public static final int TRASH_ICON = 10;
    public static final int FOLDER_ICON = 11;
    public static final int FIND_ICON = 12;
    public static final int INFO_ICON = 13;
    public static final int SPACER_ICON = 14;
    public static final int NEWUSER_ICON = 15;
    public static final int OPENUSER_ICON = 16;
    String[] audioClipNames;
    Vector trackers;
    Hashtable imageFiles;
    Hashtable imageSets;
    Hashtable properties = new Hashtable();
    Hashtable helperApps;

    public Options() {
        this.setProperty("Home", new Connection("awacs.dhs.org", 5500, "guest", "", "Red Light"));
        this.setupDefaults();
        this.trackers = new Vector();
        this.trackers.addElement(this.getStringProperty("Tracker.Default"));
        this.imageSets = new Hashtable();
        this.imageFiles = new Hashtable();
        this.helperApps = new Hashtable();
    }

    void setupDefaults() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Point topLeft = new Point(4, 64);
        if (this.getProperty("MacFileMethod") == null) {
            this.setProperty("MacFileMethod", MacFile.isSupportedMacFileMethod("Native") ? "Native" : "Split");
        }
        if (this.getProperty("BorderInsets") == null) {
            this.setProperty("BorderInsets", new Insets(4, 4, 4, 4));
        }
        if (this.getProperty("Toggle.LiveResizing") == null) {
            this.setBooleanProperty("Toggle.LiveResizing", true);
        }
        if (this.getProperty("Toggle.QueueDownloads") == null) {
            this.setBooleanProperty("Toggle.QueueDownloads", true);
        }
        if (this.getProperty("Toggle.Color") == null) {
            this.setBooleanProperty("Toggle.Color", false);
        }
        if (this.getProperty("Toggle.JoinLeave") == null) {
            this.setBooleanProperty("Toggle.JoinLeave", true);
        }
        if (this.getProperty("Toggle.Log") == null) {
            this.setBooleanProperty("Toggle.Log", false);
        }
        if (this.getProperty("Toggle.SwallowConnections") == null) {
            this.setBooleanProperty("Toggle.SwallowConnections", true);
        }
        if (this.getProperty("Toggle.RememberWindowPositions") == null) {
            this.setBooleanProperty("Toggle.RememberWindowPositions", true);
        }
        if (this.getProperty("Toggle.LoadNews") == null) {
            this.setBooleanProperty("Toggle.LoadNews", true);
        }
        if (this.getProperty("Toggle.ShowIcons") == null) {
            this.setBooleanProperty("Toggle.ShowIcons", true);
        }
        if (this.getProperty("Auto.DownloadRetries") == null) {
            this.setIntegerProperty("Auto.DownloadRetries", 3);
        }
        if (this.getProperty("Auto.StallTimeout") == null) {
            this.setIntegerProperty("Auto.StallTimeout", 180);
        }
        if (this.getProperty("Auto.MaxFolderErrors") == null) {
            this.setIntegerProperty("Auto.MaxFolderErrors", 10);
        }
        if (this.getProperty("Path.Downloads") == null) {
            this.setProperty("Path.Downloads", new File(Main.CONFIGURATION_DIRECTORY, "Downloads"));
        }
        if (this.getProperty("Path.ServerHome") == null) {
            this.setProperty("Path.ServerHome", new File(Main.CONFIGURATION_DIRECTORY, "Downloads"));
        }
        if (this.getProperty("Path.Bookmarks") == null) {
            this.setProperty("Path.Bookmarks", new File(Main.CONFIGURATION_DIRECTORY, "Bookmarks"));
        }
        if (this.getProperty("Path.ColorSchemes") == null) {
            this.setProperty("Path.ColorSchemes", new File(Main.CONFIGURATION_DIRECTORY, "ColorSchemes"));
        }
        if (this.getProperty("Path.Sounds") == null) {
            this.setProperty("Path.Sounds", new File(Main.CONFIGURATION_DIRECTORY, "Sounds"));
        }
        if (this.getProperty("User.IconNumber") == null) {
            this.setIntegerProperty("User.IconNumber", 2003);
        }
        if (this.getProperty("User.Nick") == null) {
            this.setStringProperty("User.Nick", "Red Light");
        }
        if (this.getProperty("Tracker.Default") == null) {
            this.setStringProperty("Tracker.Default", "tracked.group.org");
        }
        if (this.getProperty("WindowLocation.Tracker") == null) {
            this.setProperty("WindowLocation.Tracker", topLeft);
        }
        if (this.getProperty("WindowLocation.Bookmarks") == null) {
            this.setProperty("WindowLocation.Bookmarks", topLeft);
        }
        if (this.getProperty("WindowLocation.Main") == null) {
            this.setProperty("WindowLocation.Main", new Point((screenSize.width - 600) / 2, (screenSize.height - 420) / 2));
        }
        if (this.getProperty("WindowDimension.Tracker") == null) {
            this.setProperty("WindowDimension.Tracker", new Dimension(450, 300));
        }
        if (this.getProperty("WindowDimension.Bookmarks") == null) {
            this.setProperty("WindowDimension.Bookmarks", new Dimension(250, 300));
        }
        if (this.getProperty("WindowDimension.Main") == null) {
            this.setProperty("WindowDimension.Main", new Dimension(600, 420));
        }
        if (this.getProperty("Font.text") == null) {
            this.setProperty("Font.text", new Font("Monospaced", 0, 12));
        }
        if (this.getProperty("Font.list") == null) {
            this.setProperty("Font.list", new Font("SansSerif", 0, 12));
        }
        if (this.getProperty("Font.info") == null) {
            this.setProperty("Font.info", new Font("SansSerif", 0, 10));
        }
        if (this.getProperty("Font.small") == null) {
            this.setProperty("Font.small", new Font("Dialog", 0, 10));
        }
        if (this.getProperty("Font.gui") == null) {
            this.setProperty("Font.gui", new Font("Dialog", 0, 12));
        }
        if (this.getProperty("ServerName") == null) {
            this.setProperty("ServerName", "Your server name");
        }
        if (this.getProperty("ServerDescription") == null) {
            this.setProperty("ServerDescription", "What you provide");
        }
        if (this.getProperty("ServerTracker1") == null) {
            this.setProperty("ServerTracker1", "");
        }
        if (this.getProperty("ServerTracker2") == null) {
            this.setProperty("ServerTracker2", "");
        }
        if (this.getProperty("ServerTracker3") == null) {
            this.setProperty("ServerTracker3", "");
        }
        if (this.getProperty("ServerTracker4") == null) {
            this.setProperty("ServerTracker4", "");
        }
        this.trackers = new Vector();
        this.trackers.addElement(this.getStringProperty("Tracker.Default"));
        this.imageSets = new Hashtable();
        this.imageFiles = new Hashtable();
        this.helperApps = new Hashtable();
    }

    public boolean getBooleanProperty(String property) {
        Object value = this.properties.get(property);
        if (value == null) {
            return false;
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException(property + " is not a boolean property");
        }
        return (Boolean)value;
    }

    public void setBooleanProperty(String property, boolean value) {
        this.properties.put(property, new Boolean(value));
    }

    public int getIntegerProperty(String property) {
        Object value = this.properties.get(property);
        if (value == null) {
            return 0;
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException(property + " is not an integer property");
        }
        return (Integer)value;
    }

    public void setIntegerProperty(String property, int value) {
        this.properties.put(property, new Integer(value));
    }

    public String getStringProperty(String property) {
        Object value = this.properties.get(property);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            return value.toString();
        }
        return (String)value;
    }

    public void setStringProperty(String property, String value) {
        this.properties.put(property, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void addTracker(String s) {
        this.trackers.addElement(s);
    }

    public void removeTracker(String s) {
        this.trackers.removeElement(s);
    }

    public String[] getTrackers() {
        String[] s = new String[this.trackers.size()];
        int i = 0;
        while (i < this.trackers.size()) {
            s[i] = (String)this.trackers.elementAt(i);
            ++i;
        }
        return s;
    }

    public String getHelperApp(URL url) {
        String helper = this.getHelperForType(url.getProtocol(), true);
        if (helper == null) {
            return this.getHelperForType("http", false);
        }
        return helper;
    }

    private String getHelperForType(String type, boolean ask) {
        String app = (String)this.helperApps.get(type);
        if (app == null && ask) {
            FileDialog fd = new FileDialog((Frame)Main.getActiveShell().f, "Select a helper app for type " + type);
            fd.show();
            if (fd.getFile() != null && fd.getDirectory() != null) {
                this.helperApps.put(type, new File(fd.getDirectory(), fd.getFile().toString()).toString());
            }
        }
        return (String)this.helperApps.get(type);
    }

    public void registerImageSet(String name, String[] images) {
        if (name != null && images != null) {
            this.imageFiles.put(name, images);
            this.loadImageSet(name);
        }
    }

    private void loadImageSet(String set) {
        String[] files = (String[])this.imageFiles.get(set);
        Image[] images = new Image[files.length];
        Frame frame = new Frame();
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            int i = 0;
            while (i < images.length) {
                URL imageURL = this.getClass().getResource(files[i]);
                if (imageURL == null) {
                    DebuggerOutput.debug("Cannot load image " + files[i] + "; have to abort.");
                    System.exit(1);
                }
                images[i] = tk.createImage((ImageProducer)imageURL.getContent());
                this.imageSets.put(set, images);
                ++i;
            }
        }
        catch (IOException ex) {
            DebuggerOutput.debug("loadImageSet: hmmm, error loading image set " + set + ": " + ex);
            this.imageSets.put(set, null);
        }
    }

    private void loadAllImageSets() {
        Enumeration e = this.imageFiles.keys();
        while (e.hasMoreElements()) {
            this.loadImageSet((String)e.nextElement());
        }
    }

    public Image[] getImageSet(String set) {
        return (Image[])this.imageSets.get(set);
    }

    public void registerAudioClips(String[] clips) {
        if (clips != null) {
            this.audioClipNames = clips;
            this.loadAudioClips();
        }
    }

    private void loadAudioClips() {
        this.audioClipNames = null;
        if (this.audioClipNames != null) {
            this.audioClips = new LegacyAudioClip[this.audioClipNames.length];
            int i = 0;
            while (i < this.audioClips.length) {
                this.audioClips[i] = new AppAudioClip(this.getClass().getResource(this.audioClipNames[i]));
                ++i;
            }
        }
    }

    public synchronized void playAudioClip(String clipName) {
        if (this.audioClipNames != null) {
            int i = 0;
            while (i < this.audioClipNames.length) {
                if (this.audioClipNames[i].equals("snd/" + clipName + ".au") && this.audioClips != null) {
                    this.ac = this.audioClips[i];
                    this.ac.play();
                    this.ac.stop();
                }
                ++i;
            }
        }
    }

    public ColorScheme getColorScheme(String s) {
        File colorSchemePath = (File)this.getProperty("Path.ColorSchemes");
        String[] schemes = colorSchemePath.list();
        if (schemes != null) {
            String match = s.toUpperCase();
            int i = 0;
            while (i < schemes.length) {
                if (match.equals(schemes[i].toUpperCase())) {
                    File schemeFile = new File(colorSchemePath, schemes[i]);
                    return this.parseSchemeFile(schemeFile);
                }
                ++i;
            }
        }
        return null;
    }

    public void setColorScheme(String s, ColorScheme cs) {
        File colorSchemePath = (File)this.getProperty("Path.ColorSchemes");
        this.writeSchemeFile(new File(colorSchemePath, s), cs);
    }

    /*
     * Loose catch block
     */
    private ColorScheme parseSchemeFile(File f) {
        ColorScheme scheme;
        block12: {
            scheme = null;
            ColorScheme newScheme = new ColorScheme();
            BufferedReader lnr = null;
            FileReader fr = new FileReader(f);
            lnr = new LineNumberReader(fr);
            while (lnr.ready()) {
                String line = ((LineNumberReader)lnr).readLine();
                StringTokenizer st = new StringTokenizer(line, "=");
                while (st.hasMoreTokens()) {
                    String schemePart = st.nextToken().trim();
                    Color schemeColor = new Color(Integer.parseInt(st.nextToken().trim(), 16));
                    newScheme.setSchemeColor(schemePart, schemeColor);
                }
            }
            scheme = newScheme;
            Object var11_12 = null;
            try {
                lnr.close();
            }
            catch (IOException e2) {}
            break block12;
            {
                catch (NumberFormatException e) {
                    Object var11_13 = null;
                    try {
                        lnr.close();
                    }
                    catch (IOException e2) {}
                    break block12;
                }
                catch (IOException e) {
                    Object var11_14 = null;
                    try {
                        lnr.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    lnr.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return scheme;
    }

    private void writeSchemeFile(File f, ColorScheme cs) {
        File colorSchemePath = (File)this.getProperty("Path.ColorSchemes");
        PrintWriter pw = null;
        try {
            FileWriter fw = new FileWriter(f);
            pw = new PrintWriter(fw);
            Enumeration e = cs.getSchemeParts();
            while (e.hasMoreElements()) {
                String schemePart = (String)e.nextElement();
                pw.println(schemePart + " = " + Integer.toHexString(cs.getSchemeColor(schemePart).getRGB()).substring(2));
            }
            if (pw != null) {
                pw.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void store(File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        GZIPOutputStream gzos = new GZIPOutputStream(fos);
        ObjectOutputStream out = new ObjectOutputStream(gzos);
        out.writeObject(this.properties);
        out.writeObject(this.helperApps);
        out.writeObject(this.trackers);
        out.flush();
        out.close();
    }

    public void load(File f) {
        Hashtable backupProperties = this.properties;
        Hashtable backupHelperApps = this.helperApps;
        Vector backupTrackers = this.trackers;
        try {
            FileInputStream fis = new FileInputStream(f);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            this.properties = (Hashtable)in.readObject();
            this.helperApps = (Hashtable)in.readObject();
            this.trackers = (Vector)in.readObject();
            in.close();
        }
        catch (Exception e) {
            DebuggerOutput.stackTrace(e);
            this.properties = backupProperties;
            this.helperApps = backupHelperApps;
            this.trackers = backupTrackers;
        }
        this.setupDefaults();
    }
}

