/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import javax.swing.JOptionPane;
import redlight.client.ResumeActionListener;
import redlight.utils.TextUtils;

public class ResumeInterface {
    private Thread thread;
    private ResumeActionListener ral;
    private String filename;

    public ResumeInterface(String filename, final boolean autoResume, final ResumeActionListener ral) {
        this.filename = filename;
        this.ral = ral;
        this.thread = new Thread(new Runnable(){

            public void run() {
                int action = 0;
                if (autoResume) {
                    action = 1;
                } else if (ral.canResume()) {
                    action = ResumeInterface.this.promptUser();
                }
                if (action == -1) {
                    ral.resumeCancelled();
                } else {
                    ral.resumeAnswered(autoResume || action == 1);
                }
            }
        });
        this.thread.start();
    }

    public void interrupt() {
        this.thread.interrupt();
    }

    int promptUser() {
        boolean button = true;
        int action = -1;
        action = JOptionPane.showConfirmDialog(null, TextUtils.wordWrap("Do you want to resume " + this.filename + ", continuing the transfer where you left off?", 40), "Resume?", 1, 3);
        if (action != 0 && action != 1) {
            action = 2;
        }
        if (action == 2 || this.thread.isInterrupted()) {
            return -1;
        }
        action = action == 0 ? 1 : 0;
        return action;
    }
}

