/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import redlight.client.Main;
import redlight.client.User;

class UserCellRenderer
extends JLabel
implements ListCellRenderer {
    boolean selected;
    boolean usePlaceholder = true;
    Font font;
    Color selectedBackgroundColor;
    Color backgroundColor;
    static Color idleColor = new Color(0xABABAB);
    static Color idleAdminColor = new Color(0xFFABAB);
    User user;

    public UserCellRenderer() {
        this.setHorizontalTextPosition(2);
        this.setVerticalTextPosition(3);
        this.selectedBackgroundColor = this.getBackground();
        this.backgroundColor = this.getBackground();
        this.setOpaque(true);
    }

    public UserCellRenderer(Font f) {
        this();
        this.font = f;
        this.setFont(new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize()));
    }

    public UserCellRenderer(User user, boolean usePlaceholder) {
        this();
        this.font = this.getFont();
        this.setFont(new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize()));
        this.usePlaceholder = usePlaceholder;
        this.initFromUser(user);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        if (preferredSize.height < fm.getHeight()) {
            preferredSize.height = fm.getHeight();
        }
        return preferredSize;
    }

    private void initFromJList(JList list) {
        this.selectedBackgroundColor = list.getSelectionBackground();
        this.backgroundColor = list.getBackground();
        this.font = list.getFont();
        this.setFont(new Font(this.font.getName(), this.font.getStyle() | 1, this.font.getSize()));
    }

    private void initFromUser(User user) {
        this.user = user;
        if ((user.color & 1) == 1) {
            this.setEnabled(true);
            this.setForeground(idleColor);
            if ((user.color & 2) == 2) {
                this.setForeground(idleAdminColor);
            }
        } else {
            this.setEnabled(true);
            this.setForeground(Color.black);
            if ((user.color & 2) == 2) {
                this.setForeground(Color.red);
            }
        }
        if (Main.iconFile == null) {
            this.setText(user.nick);
            this.usePlaceholder = false;
        } else if (this.usePlaceholder) {
            this.setIcon(Main.iconFile.getIconOrPlaceholder(user.icon));
        } else {
            Icon icon = Main.iconFile.getIcon(user.icon);
            if (icon != null) {
                this.setIcon(Main.iconFile.getIconOrPlaceholder(user.icon));
            } else {
                this.setText(user.nick);
            }
        }
    }

    private void initFromSelectedState(boolean isSelected) {
        this.selected = isSelected;
        this.setBackground(this.selected ? this.selectedBackgroundColor : this.backgroundColor);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.initFromJList(list);
        this.initFromSelectedState(isSelected);
        this.initFromUser((User)value);
        return this;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.usePlaceholder || this.getIcon() != null) {
            int adjust = 0;
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            if (this.getHeight() > fm.getHeight()) {
                adjust = (this.getHeight() - fm.getHeight()) / 2;
            }
            g.drawString(this.user.nick, 34, this.getFont().getSize() + adjust);
        }
    }
}

