/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.MessageTransmit;
import redlight.client.StateObject;
import redlight.client.User;
import redlight.client.UserCellRenderer;
import redlight.client.UserEditInterface;
import redlight.client.UserOpenInterface;
import redlight.client.UserToolBar;
import redlight.hotline.HLClientAdapter;
import redlight.hotline.HLProtocol;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;

public class UsersInterface
implements ActionListener,
Scriptable {
    Machine rlm;
    Container contentPane;
    JList list;
    UserToolBar toolBar;
    JButton openAccount;
    JButton createAccount;
    JCheckBox joinLeave;
    JFrame f;
    DefaultListModel listModel;
    Hashtable users;
    HLProtocol hlp;
    static int x = 0;
    static int y = 0;
    static Integer lock = new Integer(0);
    boolean swallow;

    public UsersInterface(Machine machine) {
        this(machine, false);
    }

    public UsersInterface(Machine machine, boolean sw) {
        this.rlm = machine;
        this.swallow = sw;
        this.users = new Hashtable();
        this.hlp = new HLProtocol();
        this.rlm.getScriptBroker().addTarget(this);
        if (!this.swallow) {
            this.f = new JFrame("Users (" + this.rlm.getServerName() + ")");
            this.contentPane = this.f.getContentPane();
            this.f.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    e.getWindow().setVisible(false);
                }
            });
        } else {
            try {
                ScriptResult[] sr = this.rlm.getScriptBroker().executeScript(new ScriptObject(1L, this));
                this.contentPane = (Container)sr[0].getUserObject();
            }
            catch (UnknownMessageException e) {
                e.printStackTrace();
            }
        }
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.toolBar = new UserToolBar(this.rlm, null){

            public void actionPerformed(ActionEvent e) {
                User user = (User)UsersInterface.this.list.getSelectedValue();
                if (user != null) {
                    this.user = user;
                    super.actionPerformed(e);
                }
            }
        };
        JToolBar toolbarRight = new JToolBar();
        this.createAccount = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[15]));
        this.openAccount = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[16]));
        this.listModel = this.rlm.getUserListModel();
        this.list = new JList(this.listModel);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p2 = new JPanel();
        this.joinLeave = new JCheckBox("Show join/leave in chat", Main.rlo.getBooleanProperty("Toggle.JoinLeave"));
        this.createAccount.setFont(guiFont);
        this.openAccount.setFont(guiFont);
        this.joinLeave.setFont(guiFont);
        this.createAccount.setToolTipText("Create account");
        this.openAccount.setToolTipText("Edit account");
        this.joinLeave.setActionCommand("ActivateJoinLeave");
        this.createAccount.setActionCommand("ActivateNewuser");
        this.openAccount.setActionCommand("ActivateOpenuser");
        this.list.setBackground(this.rlm.getSchemeColor("background"));
        this.list.setForeground(this.rlm.getSchemeColor("foreground"));
        this.list.setCellRenderer(new UserCellRenderer((Font)Main.rlo.getProperty("Font.list")));
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                User user;
                if (e.getClickCount() == 2 && (user = (User)UsersInterface.this.list.getSelectedValue()) != null) {
                    new MessageTransmit(UsersInterface.this.rlm, user);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    UsersInterface.this.updateButtonStates();
                }
            }
        });
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.createAccount.addActionListener(this);
        this.openAccount.addActionListener(this);
        this.joinLeave.addActionListener(this);
        this.contentPane.setLayout(gbl);
        this.toolBar.reload.setVisible(false);
        toolbarRight.setFloatable(false);
        toolbarRight.add(this.openAccount);
        toolbarRight.add(this.createAccount);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.toolBar, gbc);
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        this.contentPane.add((Component)toolbarRight, gbc);
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.ipady = 50;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 4, 1, 4);
        gbc.anchor = 12;
        this.contentPane.add((Component)new JScrollPane(this.list), gbc);
        p2.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 8, 4, 0);
        p2.add((Component)this.joinLeave, gbc2);
        gbc.anchor = 17;
        gbc.ipady = 0;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.contentPane.add((Component)p2, gbc);
        if (!this.swallow) {
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension w = this.f.getSize();
            Integer n = lock;
            synchronized (n) {
                if (x == 0) {
                    x = d.width / 100 * 60;
                    y = d.height / 100 * 2;
                }
                this.f.setLocation(x, y);
                if ((x += w.width + 16) > d.width - w.width) {
                    x = d.width / 100 * 60;
                    y += w.height;
                }
                if (y > d.height / 100 * 60 - w.height) {
                    y = d.height / 100 * 20;
                    x += w.width / 2;
                }
            }
            this.f.pack();
            this.f.show();
        }
        this.rlm.getHLC().addHLClientListener(new HLClientAdapter(){

            public void handleUserLeave(int sock) {
                UsersInterface.this.updateButtonStates();
            }
        });
        this.list.setSelectedIndex(0);
    }

    void updateButtonStates() {
        boolean state = this.list.getSelectedIndex() != -1;
        this.setButtonStates(state);
    }

    void setButtonStates(boolean state) {
        this.toolBar.priv.setEnabled(state);
        this.toolBar.info.setEnabled(state);
        this.toolBar.kick.setEnabled(state);
        this.toolBar.msg.setEnabled(state);
    }

    public void show() {
        if (!this.swallow) {
            this.f.show();
        }
        this.list.requestFocus();
    }

    ScriptResult processStateChange(StateObject state) {
        if (state.isPublicState()) {
            switch (state.what) {
                case 2: {
                    this.joinLeave.setSelected(this.rlm.isShowJoinLeaveEnabled());
                }
            }
        }
        return new ScriptResult((Scriptable)this, null);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ActivateNewuser")) {
            HLProtocol hlp = new HLProtocol();
            HLProtocol.AccountInfo account = new HLProtocol.AccountInfo(hlp);
            new UserEditInterface(this.rlm, account, true);
        } else if (e.getActionCommand().equals("ActivateOpenuser")) {
            new UserOpenInterface(this.rlm);
        }
        if (e.getActionCommand().equals("ActivateJoinLeave")) {
            this.rlm.setState(2, new Boolean(this.joinLeave.isSelected()));
        }
    }

    public void close() {
        if (!this.swallow) {
            this.f.setVisible(false);
            this.f.dispose();
        } else {
            try {
                this.rlm.getScriptBroker().executeScript(new ScriptObject(2L, this.contentPane));
            }
            catch (UnknownMessageException unknownMessageException) {
                // empty catch block
            }
        }
        this.rlm.getScriptBroker().removeTarget(this);
    }

    public void displayPropertyChanged(String what, final Object property) {
        if (what.equals("listfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UsersInterface.this.list.setFont((Font)property);
                    UsersInterface.this.list.repaint();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UsersInterface.this.list.setForeground(UsersInterface.this.rlm.getSchemeColor("foreground"));
                    UsersInterface.this.list.setBackground(UsersInterface.this.rlm.getSchemeColor("background"));
                }
            });
        }
        this.contentPane.repaint();
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 24L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 8: {
                if (s.getUserObject() instanceof Container && (Container)s.getUserObject() == this.contentPane) {
                    return new ScriptResult((Scriptable)this, null);
                }
            }
            case 16: {
                if (!(s.getUserObject() instanceof StateObject)) break;
                StateObject state = (StateObject)s.getUserObject();
                return this.processStateChange(state);
            }
        }
        throw new UnknownMessageException();
    }
}

