/*
 * Decompiled with CFR 0.152.
 */
package redlight.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import redlight.utils.DebuggerOutput;

public class ImageFromStream
extends Component
implements Runnable {
    Image image;
    Thread builder;
    InputStream inputStream;
    Integer imageLock;
    JComponent container;

    public ImageFromStream(JComponent container, InputStream inputStream) {
        this.inputStream = inputStream;
        this.imageLock = new Integer(0);
        this.container = container;
        this.builder = new Thread(this);
        this.builder.start();
    }

    public void run() {
        DebuggerOutput.debug("ImageFromStream: started ...");
        ByteArrayOutputStream imageData = new ByteArrayOutputStream();
        byte[] buf = new byte[10000];
        Thread.currentThread().setName("ImageFromStream " + this.inputStream);
        int r = 0;
        try {
            while ((r = this.inputStream.read(buf, 0, 10000)) != -1) {
                imageData.write(buf, 0, r);
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        try {
            imageData.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        Integer n = this.imageLock;
        synchronized (n) {
            this.image = Toolkit.getDefaultToolkit().createImage(imageData.toByteArray());
        }
        imageData.reset();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImageFromStream.this.invalidate();
                ImageFromStream.this.container.revalidate();
                ImageFromStream.this.container.repaint();
            }
        });
        DebuggerOutput.debug("ImageFromStream: exiting");
    }

    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension(300, 200);
        }
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Integer n = this.imageLock;
        synchronized (n) {
            if (this.image != null) {
                g.drawImage(this.image, 0, 0, this);
            }
        }
    }
}

