/*
 * Decompiled with CFR 0.152.
 */
package redlight.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class Spinner
extends Component
implements Runnable {
    Image[] images;
    Thread spinner;
    protected int speed;
    protected int width;
    protected int height;
    int currentImage;
    boolean busy;

    public Spinner(Image[] imgs, int s, int w, int h) {
        this.speed = s;
        this.width = w;
        this.height = h;
        this.images = imgs;
        this.busy = false;
    }

    public void run() {
        Thread.currentThread().setName("Spinner " + this.images[0]);
        try {
            do {
                ++this.currentImage;
                if (this.currentImage == this.images.length) {
                    this.currentImage = 0;
                }
                this.repaint();
                Thread.currentThread();
                Thread.sleep(this.speed);
            } while (this.busy);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.busy) {
            g.drawImage(this.images[this.currentImage], 0, 0, this);
        } else {
            g.clearRect(0, 0, this.width, this.height);
        }
    }

    public void start() {
        if (!this.busy) {
            this.busy = true;
            this.spinner = new Thread(this);
            this.spinner.start();
        }
    }

    public void stop() {
        this.busy = false;
        this.spinner.interrupt();
        try {
            this.spinner.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
    }

    public boolean isBusy() {
        return this.busy;
    }
}

