/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline.iconlib;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import redlight.hotline.iconlib.HLData;
import redlight.hotline.iconlib.HLDataHdr;
import redlight.hotline.iconlib.HLIconData;
import redlight.hotline.iconlib.HLIndexTable;
import redlight.hotline.iconlib.HLTable;
import redlight.hotline.iconlib.HLUtils;
import redlight.utils.DebuggerOutput;

public class HLExtractor {
    final int POS_TABLE_SIZE = 24;
    final int POS_TABLE_OFFSET = 28;
    final int POS_VALID_OFFSET = 32;
    final int POS_OFFSET_UVT_SIZE = 44;
    final int POS_OFFSET_BLOCK_DIFF_EMSG = 48;
    final int POS_OFFSET_BLOCK_DIFF_GIFf = 64;
    final int POS_OFFSET_BLOCK_DIFF_ICON = 80;
    final int POS_OFFSET_BLOCK_DIFF_JPEG = 160;
    final int POS_OFFSET_BLOCK_DIFF_LVT = 176;
    final int POS_OFFSET_BLOCK_UVT_DATA = 8;
    final int SIZE_HLHDRDATA = 8;
    final int SIZE_HLTABLE = 16;
    final int SIZE_LVTROW = 16;
    final int BLOCK_COUNT = 8;
    final int SIZE_ICON_HEADER = 64;
    final int SIZE_WIN_BMP_HEADER = 54;
    int tableSize;
    long tableOffset;
    int dataSize;
    int dataOffset;
    Vector banners;
    int bannersCount;
    RandomAccessFile file;
    public HLIndexTable indexTable;
    public boolean hasGIF;
    public boolean hasICON;
    public int idGIFTable = -1;
    public int idICONTable = -1;

    HLTable populateTableUVT(HLTable table) throws IOException {
        byte[] tempData = new byte[16];
        if (table == null) {
            table = new HLTable();
        }
        this.file.read(tempData);
        table.blockName = new String(HLUtils.extractBytes(tempData, 0, 4));
        table.dataSizeUVT = HLUtils.extractInt(tempData, 8);
        table.dataOffsetUVT = HLUtils.extractInt(tempData, 12);
        return table;
    }

    HLTable populateTableUVTNames(HLTable table) throws IOException {
        if (table == null) {
            table = new HLTable();
        }
        long currentOffset = this.file.getFilePointer();
        this.file.seek(table.dataOffsetUVT);
        int idCount = this.file.readInt();
        int i = 0;
        while (i < idCount) {
            int k;
            HLData tempHLD = new HLData();
            tempHLD.identity = this.file.readInt();
            short strLength = this.file.readShort();
            byte[] tempData = new byte[strLength];
            this.file.read(tempData);
            tempHLD.name = new String(tempData);
            table.add(tempHLD);
            int j = (strLength + 6) / 4 * 4;
            if (j < strLength + 6) {
                j += 4;
            }
            if ((k = this.file.skipBytes(j -= strLength + 6)) != j) {
                this.file.seek(currentOffset);
                return null;
            }
            ++i;
        }
        this.file.seek(currentOffset);
        return table;
    }

    HLIndexTable buildIndexTable() throws IOException {
        HLTable table;
        long currentOffset = this.file.getFilePointer();
        int blockPosICON = -1;
        int blockPosGIF = -1;
        int indexTablePos = 0;
        HLIndexTable index = new HLIndexTable();
        this.file.seek(currentOffset + 44L);
        int blockCount = this.file.readInt();
        long tempOffset = this.file.getFilePointer();
        byte[][] blocks = new byte[blockCount][16];
        int i = 0;
        while (i < blockCount) {
            this.file.read(blocks[i]);
            if (HLUtils.compareBeginStr(blocks[i], "GIFf")) {
                this.hasGIF = true;
                blockPosGIF = i;
            }
            if (HLUtils.compareBeginStr(blocks[i], "ICON")) {
                this.hasICON = true;
                blockPosICON = i;
            }
            ++i;
        }
        if (this.hasGIF) {
            this.file.seek(tempOffset);
            this.file.skipBytes(16 * blockPosGIF);
            table = new HLTable();
            this.populateTableUVT(table);
            this.populateTableUVTNames(table);
            this.file.seek(tempOffset + (long)(blockCount * 16));
            if (this.skipToLVTBlock("GIFf", blockCount)) {
                this.populateLVTBlock(table);
                index.add(table);
                this.idGIFTable = indexTablePos++;
            }
        }
        if (this.hasICON) {
            this.file.seek(tempOffset);
            this.file.skipBytes(16 * blockPosICON);
            table = new HLTable();
            this.populateTableUVT(table);
            this.populateTableUVTNames(table);
            this.file.seek(tempOffset + (long)(blockCount * 16));
            if (this.skipToLVTBlock("ICON", blockCount)) {
                this.populateLVTBlock(table);
                index.add(table);
                this.idICONTable = indexTablePos++;
            }
        }
        this.file.seek(tempOffset + (long)(blockCount * 16));
        return index;
    }

    boolean skipToLVTBlock(String name, int blockCount) throws IOException {
        long currentOffset = this.file.getFilePointer();
        byte[] block = new byte[8];
        int i = 0;
        while (i < blockCount) {
            long lastOffset = this.file.getFilePointer();
            this.file.read(block);
            if (HLUtils.compareBeginStr(block, name)) {
                this.file.seek(lastOffset);
                return true;
            }
            int j = HLUtils.extractInt(block, 4);
            this.file.skipBytes(j * 16);
            ++i;
        }
        this.file.seek(currentOffset);
        return false;
    }

    public HLIconData getIcon(int identity) throws IOException {
        long currentOffset = this.file.getFilePointer();
        HLIconData hlicd = new HLIconData();
        byte[] tempHeader = new byte[64];
        HLTable table = this.indexTable.get(this.idICONTable);
        int pos = table.find(identity);
        if (pos < 0) {
            return null;
        }
        HLData tempHLD = table.get(pos);
        this.file.seek(tempHLD.dataOffset);
        this.file.read(tempHeader);
        hlicd.width = HLUtils.extractInt(tempHeader, 16);
        hlicd.height = HLUtils.extractInt(tempHeader, 20);
        hlicd.widthInBytes = HLUtils.extractInt(tempHeader, 24);
        hlicd.palLengthBytes = HLUtils.extractInt(tempHeader, 36);
        hlicd.transparency = HLUtils.extractInt(tempHeader, 44);
        hlicd.palLengthLW = HLUtils.extractInt(tempHeader, 48);
        int pads = hlicd.widthInBytes - hlicd.width;
        if (pads < 0) {
            pads = 0;
        }
        hlicd.palette = new byte[hlicd.palLengthLW * 3][3];
        byte[] tmpBRead = new byte[4];
        int i = 0;
        while (i < hlicd.palLengthLW) {
            this.file.read(tmpBRead);
            hlicd.palette[i][0] = tmpBRead[0];
            hlicd.palette[i][1] = tmpBRead[1];
            hlicd.palette[i][2] = tmpBRead[2];
            ++i;
        }
        int rawDataSize = hlicd.width * hlicd.height;
        hlicd.rawData = new byte[rawDataSize];
        byte[] tmpBytes = new byte[hlicd.width + pads];
        i = 0;
        while (i < hlicd.height) {
            this.file.read(tmpBytes);
            HLUtils.copyBytes(hlicd.rawData, tmpBytes, i * hlicd.width, 0, hlicd.width);
            ++i;
        }
        hlicd.malloc(rawDataSize);
        i = 0;
        while (i < rawDataSize) {
            int j = HLUtils.signedToUnsigned(hlicd.rawData[i]);
            if (j >= hlicd.palLengthLW) {
                DebuggerOutput.debug(" ICON USES ILLEGAL PALETTE COLOR OR THIS IS AN ISSUE TO BE FIXED! identity: " + identity);
                return null;
            }
            tmpBytes = hlicd.palette[j];
            hlicd.add(tmpBytes[0], tmpBytes[1], tmpBytes[2]);
            ++i;
        }
        this.file.seek(currentOffset);
        return hlicd;
    }

    boolean populateLVTBlock(HLTable table) throws IOException {
        HLDataHdr hdr = new HLDataHdr();
        long currentOffset = this.file.getFilePointer();
        byte[] tempField = new byte[8];
        this.file.read(tempField);
        hdr = HLUtils.extractDataFieldHLDataHdr(tempField);
        if (table.blockName.compareTo(hdr.blockName) != 0) {
            this.file.seek(currentOffset);
            return false;
        }
        tempField = new byte[16];
        int i = 0;
        while (i < hdr.rowCount) {
            this.file.read(tempField);
            HLData data = HLUtils.extractDataFieldHLData(tempField);
            int k = table.find(data.identity);
            if (k < 0) {
                data.name = new String("unnamed" + data.identity);
                table.add(data);
            } else {
                data.name = table.get((int)k).name;
                table.set(k, data);
            }
            ++i;
        }
        return true;
    }

    public byte[] createWinBitmap(HLIconData hlicd) {
        int SIZE_WIN_BMP_HEADER = 54;
        int SIZE_PIXEL_IN_BYTES = 3;
        int FILE_TYPE = 19778;
        boolean X_HOTSPOT = false;
        boolean Y_HOTSPOT = false;
        int OFFSET_BITS = 54;
        int SIZE_HEADER_STRUC = 40;
        boolean PLANES_COUNT = true;
        int BITS_PER_PIXEL = 24;
        boolean COMPRESSION_TYPE = false;
        int XPELS_PER_METER = 3779;
        int YPELS_PER_METER = 3779;
        boolean BITS_PER_COLOR_USED = false;
        boolean NUMBER_IMPORTANT_COLORS = false;
        if (hlicd == null) {
            return null;
        }
        int widthInBytes = hlicd.width * 3;
        int j = widthInBytes / 4 * 4;
        int pads = j < widthInBytes ? j + 4 - widthInBytes : 0;
        int bitmapSize = hlicd.height * (widthInBytes + pads);
        int size = bitmapSize + 54;
        int widthInPix = hlicd.width;
        int heightInPix = hlicd.height;
        byte[] data = new byte[size];
        HLUtils.storeReversed(data, HLUtils.intToBytes(19778), 0, 2, 2);
        HLUtils.storeReversed(data, HLUtils.intToBytes(size), 2, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(0), 6, 2, 2);
        HLUtils.storeReversed(data, HLUtils.intToBytes(0), 8, 2, 2);
        HLUtils.storeReversed(data, HLUtils.intToBytes(54), 10, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(40), 14, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(widthInPix), 18, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(heightInPix), 22, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(1), 26, 2, 2);
        HLUtils.storeReversed(data, HLUtils.intToBytes(24), 28, 2, 2);
        HLUtils.storeReversed(data, HLUtils.intToBytes(0), 30, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(bitmapSize), 34, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(3779), 38, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(3779), 42, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(0), 46, 0, 4);
        HLUtils.storeReversed(data, HLUtils.intToBytes(0), 50, 0, 4);
        int pos = 54;
        int k = 0;
        byte[][] koord = new byte[hlicd.height][widthInBytes];
        int i = hlicd.height - 1;
        while (i >= 0) {
            j = 0;
            while (j < hlicd.width) {
                koord[i][j * 3 + 0] = hlicd.getBlue(k);
                koord[i][j * 3 + 1] = hlicd.getGreen(k);
                koord[i][j * 3 + 2] = hlicd.getRed(k);
                ++k;
                ++j;
            }
            --i;
        }
        k = 0;
        i = 0;
        while (i < hlicd.height) {
            j = 0;
            while (j < hlicd.width) {
                HLUtils.copyBytes(data, koord[i], pos + k, j * 3, 3);
                k += 3;
                ++j;
            }
            pos += pads;
            ++i;
        }
        return data;
    }

    public boolean isHotline(long tableOffset) throws IOException {
        long currentOffset = this.file.getFilePointer();
        byte[] position = new byte[4];
        if (tableOffset >= this.file.length()) {
            return false;
        }
        this.file.seek(tableOffset + 32L);
        this.file.read(position);
        long readOffset = HLUtils.signedToUnsigned(position[0]) * 0x1000000 + HLUtils.signedToUnsigned(position[1]) * 65536 + HLUtils.signedToUnsigned(position[2]) * 256 + HLUtils.signedToUnsigned(position[3]);
        this.file.seek(currentOffset);
        return tableOffset + 32L == readOffset;
    }

    public int getTableSize() throws IOException {
        long currentOffset = this.file.getFilePointer();
        this.file.seek(24L);
        int tableSize = this.file.readInt();
        this.file.seek(currentOffset);
        return tableSize;
    }

    public int getTableOffset() throws IOException {
        long currentOffset = this.file.getFilePointer();
        this.file.seek(28L);
        int tableOffset = this.file.readInt();
        this.file.seek(currentOffset);
        return tableOffset;
    }

    public boolean quickStart(String hotlineFile) throws IOException {
        if (!this.open(hotlineFile)) {
            return false;
        }
        this.tableSize = this.getTableSize();
        this.tableOffset = this.getTableOffset();
        if (!this.isHotline(this.tableOffset)) {
            this.file.close();
            return false;
        }
        this.file.seek(this.tableOffset);
        this.indexTable = this.buildIndexTable();
        return true;
    }

    public boolean open(String name) throws IOException {
        this.file = new RandomAccessFile(name, "r");
        return this.file != null;
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public byte[] getGIF(int identity) throws IOException {
        HLTable table = this.indexTable.get(this.idGIFTable);
        int tablePos = table.find(identity);
        if (tablePos < 0) {
            return null;
        }
        HLData hld = table.get(tablePos);
        byte[] data = new byte[hld.dataSize];
        long currentOffset = this.file.getFilePointer();
        this.file.seek(hld.dataOffset);
        this.file.read(data);
        this.file.seek(currentOffset);
        return data;
    }
}

