/*
 * Decompiled with CFR 0.152.
 */
package redlight.script;

import java.util.Vector;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;
import redlight.utils.DebuggerOutput;

public class ScriptBroker {
    Vector targets = new Vector();

    public void addTarget(Scriptable s) {
        this.targets.addElement(new Target(s, s.getKnownMessages()));
        s.gotTarget(this);
    }

    public synchronized void removeTarget(Scriptable s) {
        Target t = this.getTarget(s);
        if (t != null) {
            this.targets.removeElement(t);
            s.lostTarget(this);
        } else {
            DebuggerOutput.tell("ScriptBroker: illegal target remove for " + s.toString());
        }
    }

    private Target getTarget(Scriptable s) {
        int i = 0;
        while (i < this.targets.size()) {
            if (((Target)this.targets.elementAt((int)i)).target == s) {
                return (Target)this.targets.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    public ScriptResult executeScript(Scriptable t, ScriptObject s) throws UnknownMessageException {
        ScriptResult r = t.executeScript(s);
        return r;
    }

    public ScriptResult[] executeScript(ScriptObject s) throws UnknownMessageException {
        ScriptResult[] sTemp = new ScriptResult[this.targets.size()];
        int j = 0;
        int i = 0;
        while (i < this.targets.size()) {
            try {
                ScriptResult result = this.executeScript((Target)this.targets.elementAt(i), s);
                sTemp[j++] = result;
            }
            catch (UnknownMessageException ex) {
                // empty catch block
            }
            ++i;
        }
        if (j == 0) {
            throw new UnknownMessageException(s.toString());
        }
        ScriptResult[] sr = new ScriptResult[j];
        int i2 = 0;
        while (i2 < j) {
            sr[i2] = sTemp[i2];
            ++i2;
        }
        return sr;
    }

    private ScriptResult executeScript(Target t, ScriptObject s) throws UnknownMessageException {
        if ((t.knowsMessages & s.type) == s.type) {
            return this.executeScript(t.target, s);
        }
        throw new UnknownMessageException(s.toString());
    }

    class Target {
        public Scriptable target;
        public long knowsMessages;

        public Target(Scriptable s, long m) {
            this.target = s;
            this.knowsMessages = m;
        }
    }
}

